/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mockito.Mockito;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.store.format.RecordFormat;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.test.Randoms;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.unsafe.impl.batchimport.input.Group;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityCacher;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.InputNodeCacher;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationshipCacher;

public class InputEntityCacherTokenCreationTest {
    private static final int SUPPORTED_NUMBER_OF_TOKENS = 10;
    private static final int UNSUPPORTED_NUMER_OF_TOKENS = 11;
    private static final AtomicInteger uniqueIdGenerator = new AtomicInteger(10);
    private final ExpectedException expectedException = ExpectedException.none();
    private final RandomRule randomRule = new RandomRule();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.randomRule).around((TestRule)this.expectedException);

    @Test
    public void notAllowCreationOfUnsupportedNumberOfProperties() throws IOException {
        this.initExpectedException(10);
        this.cacheNodeWithProperties(11, 10);
    }

    @Test
    public void allowCreationOfSupportedNumberOfProperties() throws IOException {
        this.cacheNodeWithProperties(10, 10);
    }

    @Test
    public void notAllowCreationOfUnsupportedNumberOfGroups() throws IOException {
        this.initExpectedException(10);
        this.cacheGroups(11, 10);
    }

    @Test
    public void allowCreationOfSupportedNumberOfGroups() throws IOException {
        this.cacheGroups(10, 10);
    }

    @Test
    public void notAllowCreationOfUnsupportedNumberOfLabels() throws IOException {
        this.initExpectedException(10);
        this.cacheLabels(11, 10);
    }

    @Test
    public void allowCreationOfSupportedNumberOfLabels() throws IOException {
        this.cacheLabels(10, 10);
    }

    @Test
    public void notAllowCreationOfUnsupportedNumberOfRelationshipTypes() throws IOException {
        this.initExpectedException(10);
        this.cacheRelationship(11, 10);
    }

    @Test
    public void allowCreationOfSupportedNumberOfRelationshipTypes() throws IOException {
        this.cacheRelationship(10, 10);
    }

    private void cacheRelationship(int iterations, int maxNumberOfRelationshipTypes) throws IOException {
        RecordFormats recordFormats = this.mockRecordFormats(1000L, 1000L, maxNumberOfRelationshipTypes, 1000L);
        try (InputRelationshipCacher cacher = this.getRelationshipCacher(recordFormats);){
            for (int i = 0; i < iterations; ++i) {
                cacher.writeEntity(this.generateRelationship(this.getRandoms()));
            }
        }
    }

    private void cacheLabels(int iterations, int maxNumberOfLabels) throws IOException {
        RecordFormats recordFormats = this.mockRecordFormats(1000L, maxNumberOfLabels, 1000L, 1000L);
        try (InputNodeCacher cacher = this.getNodeCacher(recordFormats);){
            for (int i = 0; i < iterations; ++i) {
                cacher.writeLabelDiff((byte)0, this.randomLabels(), new String[0]);
            }
        }
    }

    private void cacheGroups(int iterations, int maxNumberOfGroups) throws IOException {
        RecordFormats recordFormats = this.mockRecordFormats(1000L, 1000L, 1000L, maxNumberOfGroups);
        try (TestInputEntityCacher cacher = this.getEntityCacher(recordFormats);){
            for (int i = 0; i < iterations; ++i) {
                cacher.writeGroup(this.generateGroup(), i);
            }
        }
    }

    private void cacheNodeWithProperties(int iterations, int maxNumberOfProperties) throws IOException {
        RecordFormats recordFormats = this.mockRecordFormats(maxNumberOfProperties, 1000L, 1000L, 1000L);
        try (TestInputEntityCacher cacher = this.getEntityCacher(recordFormats);){
            Randoms randoms = this.getRandoms();
            for (int i = 0; i < iterations; ++i) {
                cacher.writeEntity((InputEntity)this.generateNode(randoms));
            }
        }
    }

    private void initExpectedException(int numberOfSupportedTokens) {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.expectedException.expectMessage("Too many tokens. Creation of more then " + numberOfSupportedTokens + " tokens is not supported.");
    }

    private InputRelationship generateRelationship(Randoms randoms) {
        return new InputRelationship(null, 0L, 0L, this.generatemProperties(randoms), null, this.generateGroup(), this.randomId(randoms), this.generateGroup(), this.randomId(randoms), this.getUniqueString(), null);
    }

    private InputNode generateNode(Randoms random) {
        return new InputNode(null, 0L, 0L, this.generateGroup(), this.randomId(random), this.generatemProperties(random), null, this.randomLabels(), null);
    }

    private Group generateGroup() {
        return new Group.Adapter(uniqueIdGenerator.getAndIncrement(), this.getUniqueString());
    }

    private String[] randomLabels() {
        String[] labels = new String[1];
        for (int i = 0; i < labels.length; ++i) {
            labels[i] = this.getUniqueString();
        }
        return labels;
    }

    private String getUniqueString() {
        return uniqueIdGenerator.getAndIncrement() + "";
    }

    private Object[] generatemProperties(Randoms random) {
        int length = 1;
        Object[] properties = new Object[length * 2];
        for (int i = 0; i < properties.length; ++i) {
            properties[i++] = this.getUniqueString();
            properties[i] = random.propertyValue() + "";
        }
        return properties;
    }

    private Object randomId(Randoms random) {
        return Math.abs(random.random().nextLong());
    }

    private RecordFormats mockRecordFormats(long maxPropertyKeyId, long maxLabelId, long maxRelationshipTypeId, long maxRelationshipGroupId) {
        RecordFormats recordFormats = (RecordFormats)Mockito.mock(RecordFormats.class);
        RecordFormat propertyKeyTokenFormat = this.getRecordFormatMock(maxPropertyKeyId);
        RecordFormat labelTokenFormat = this.getRecordFormatMock(maxLabelId);
        RecordFormat relationshipTypeTokenFormat = this.getRecordFormatMock(maxRelationshipTypeId);
        RecordFormat relationshipGroupTokenFormat = this.getRecordFormatMock(maxRelationshipGroupId);
        Mockito.when((Object)recordFormats.propertyKeyToken()).thenReturn((Object)propertyKeyTokenFormat);
        Mockito.when((Object)recordFormats.labelToken()).thenReturn((Object)labelTokenFormat);
        Mockito.when((Object)recordFormats.relationshipTypeToken()).thenReturn((Object)relationshipTypeTokenFormat);
        Mockito.when((Object)recordFormats.relationshipGroup()).thenReturn((Object)relationshipGroupTokenFormat);
        return recordFormats;
    }

    private RecordFormat getRecordFormatMock(long maxId) {
        RecordFormat recordFormat = (RecordFormat)Mockito.mock(RecordFormat.class);
        Mockito.when((Object)recordFormat.getMaxId()).thenReturn((Object)maxId);
        return recordFormat;
    }

    private Randoms getRandoms() {
        return new Randoms(this.randomRule.random(), Randoms.DEFAULT);
    }

    private TestInputEntityCacher getEntityCacher(RecordFormats recordFormats) throws IOException {
        return new TestInputEntityCacher((StoreChannel)Mockito.mock(StoreChannel.class), (StoreChannel)Mockito.mock(StoreChannel.class), recordFormats, 100, 100);
    }

    private InputNodeCacher getNodeCacher(RecordFormats recordFormats) throws IOException {
        return new InputNodeCacher((StoreChannel)Mockito.mock(StoreChannel.class), (StoreChannel)Mockito.mock(StoreChannel.class), recordFormats, 100, 100);
    }

    private InputRelationshipCacher getRelationshipCacher(RecordFormats recordFormats) throws IOException {
        return new InputRelationshipCacher((StoreChannel)Mockito.mock(StoreChannel.class), (StoreChannel)Mockito.mock(StoreChannel.class), recordFormats, 100, 100);
    }

    private class TestInputEntityCacher
    extends InputEntityCacher {
        TestInputEntityCacher(StoreChannel channel, StoreChannel header, RecordFormats recordFormats, int bufferSize, int groupSlots) throws IOException {
            super(channel, header, recordFormats, bufferSize, 100, groupSlots);
        }
    }
}

