/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.util.Arrays;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.CoarseBoundedProgressExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.ControlledStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageExecution;
import org.neo4j.unsafe.impl.batchimport.stats.Keys;

@RunWith(value=Parameterized.class)
public class CoarseBoundedProgressExecutionMonitorTest {
    @Parameterized.Parameter
    public int batchSize;

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Integer> parameters() {
        return Arrays.asList(1, 10, 123);
    }

    @Test
    public void shouldReportProgressOnSingleExecution() throws Exception {
        Configuration config = this.config();
        ProgressExecutionMonitor progressExecutionMonitor = new ProgressExecutionMonitor(this.batchSize, this.config());
        long total = this.monitorSingleStageExecution(progressExecutionMonitor, config);
        Assert.assertEquals((long)total, (long)progressExecutionMonitor.getProgress());
    }

    @Test
    public void progressOnMultipleExecutions() {
        Configuration config = this.config();
        ProgressExecutionMonitor progressExecutionMonitor = new ProgressExecutionMonitor(this.batchSize, config);
        long total = progressExecutionMonitor.total();
        for (int i = 0; i < 4; ++i) {
            progressExecutionMonitor.start(this.execution(0L, config));
            progressExecutionMonitor.check(this.execution(total / 4L, config));
        }
        progressExecutionMonitor.done(0L, "Completed");
        Assert.assertEquals((String)"Each item should be completed", (long)total, (long)progressExecutionMonitor.getProgress());
    }

    private long monitorSingleStageExecution(ProgressExecutionMonitor progressExecutionMonitor, Configuration config) {
        progressExecutionMonitor.start(this.execution(0L, config));
        long total = progressExecutionMonitor.total();
        long part = total / 10L;
        for (int i = 0; i < 9; ++i) {
            progressExecutionMonitor.check(this.execution(part * (long)(i + 1), config));
            Assert.assertTrue((progressExecutionMonitor.getProgress() < total ? 1 : 0) != 0);
        }
        progressExecutionMonitor.done(0L, "Test");
        return total;
    }

    private StageExecution execution(long doneBatches, Configuration config) {
        ControlledStep<?> step = ControlledStep.stepWithStats("Test", 0, Keys.done_batches, doneBatches);
        StageExecution execution = new StageExecution("Test", config, Collections.singletonList(step), 0);
        return execution;
    }

    private Configuration config() {
        return new Configuration.Overridden(Configuration.DEFAULT){

            public int batchSize() {
                return CoarseBoundedProgressExecutionMonitorTest.this.batchSize;
            }
        };
    }

    private class ProgressExecutionMonitor
    extends CoarseBoundedProgressExecutionMonitor {
        private long progress;

        ProgressExecutionMonitor(int batchSize, Configuration configuration) {
            super((long)(100 * batchSize), (long)(100 * batchSize), configuration);
        }

        protected void progress(long progress) {
            this.progress += progress;
        }

        public long getProgress() {
            return this.progress;
        }
    }
}

