/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.neo4j.concurrent.BinaryLatch;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.LonelyProcessingStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.staging.StageExecution;
import org.neo4j.unsafe.impl.batchimport.staging.Step;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;

public class LonelyProcessingStepTest {
    @ClassRule
    public static SuppressOutput mute = SuppressOutput.suppressAll();

    @Test
    public void issuePanicBeforeCompletionOnError() throws Exception {
        ArrayList stepsPipeline = new ArrayList();
        BinaryLatch endOfUpstreamLatch = new BinaryLatch();
        FaultyLonelyProcessingStepTest faultyStep = new FaultyLonelyProcessingStepTest(stepsPipeline, endOfUpstreamLatch);
        stepsPipeline.add((Step<?>)faultyStep);
        faultyStep.receive(1L, null);
        endOfUpstreamLatch.await();
        Assert.assertTrue((String)"On upstream end step should be already on panic in case of exception", (boolean)faultyStep.isPanicOnEndUpstream());
        Assert.assertTrue((boolean)faultyStep.isPanic());
        Assert.assertFalse((boolean)faultyStep.stillWorking());
        Assert.assertTrue((boolean)faultyStep.isCompleted());
    }

    private class FaultyLonelyProcessingStepTest
    extends LonelyProcessingStep {
        private final BinaryLatch endOfUpstreamLatch;
        private volatile boolean panicOnEndUpstream;

        FaultyLonelyProcessingStepTest(List<Step<?>> pipeLine, BinaryLatch endOfUpstreamLatch) {
            super((StageControl)new StageExecution("Faulty", Configuration.DEFAULT, pipeLine, 0), "Faulty", Configuration.DEFAULT, new StatsProvider[0]);
            this.endOfUpstreamLatch = endOfUpstreamLatch;
        }

        protected void process() {
            throw new RuntimeException("Process exception");
        }

        public void endOfUpstream() {
            this.panicOnEndUpstream = this.isPanic();
            super.endOfUpstream();
            this.endOfUpstreamLatch.release();
        }

        public boolean isPanicOnEndUpstream() {
            return this.panicOnEndUpstream;
        }
    }
}

