/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.store.id.IdRange;
import org.neo4j.kernel.impl.store.id.validation.IdValidator;
import org.neo4j.unsafe.impl.batchimport.store.BatchingIdSequence;

public class BatchingIdSequenceTest {
    @Test
    public void ShouldSkipNullId() throws Exception {
        BatchingIdSequence idSequence = new BatchingIdSequence();
        idSequence.set(0xFFFFFFFEL);
        Assert.assertEquals((long)0xFFFFFFFEL, (long)idSequence.peek());
        Assert.assertEquals((long)0xFFFFFFFEL, (long)idSequence.nextId());
        Assert.assertEquals((long)0x100000000L, (long)idSequence.peek());
        Assert.assertEquals((long)0x100000000L, (long)idSequence.nextId());
        idSequence.set(0xFFFFFFFFL);
        Assert.assertEquals((long)0x100000000L, (long)idSequence.peek());
        Assert.assertEquals((long)0x100000000L, (long)idSequence.nextId());
    }

    @Test
    public void resetShouldSetDefault() throws Exception {
        BatchingIdSequence idSequence = new BatchingIdSequence();
        idSequence.set(99L);
        Assert.assertEquals((long)99L, (long)idSequence.peek());
        Assert.assertEquals((long)99L, (long)idSequence.nextId());
        Assert.assertEquals((long)100L, (long)idSequence.peek());
        idSequence.reset();
        Assert.assertEquals((long)0L, (long)idSequence.peek());
        Assert.assertEquals((long)0L, (long)idSequence.nextId());
        Assert.assertEquals((long)1L, (long)idSequence.peek());
    }

    @Test
    public void shouldSkipReservedIdWhenGettingBatches() throws Exception {
        int batchSize = 10;
        BatchingIdSequence idSequence = new BatchingIdSequence(0xFFFFFFFFL - (long)batchSize - (long)(batchSize / 2));
        IdRange range1 = idSequence.nextIdBatch(batchSize);
        IdRange range2 = idSequence.nextIdBatch(batchSize);
        this.assertNoReservedId(range1);
        this.assertNoReservedId(range2);
    }

    private void assertNoReservedId(IdRange range) {
        for (long id : range.getDefragIds()) {
            Assert.assertFalse((boolean)IdValidator.isReservedId((long)id));
        }
        Assert.assertFalse((boolean)IdValidator.hasReservedIdInRange((long)range.getRangeStart(), (long)(range.getRangeStart() + (long)range.getRangeLength())));
    }
}

