/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.io.IOException;
import java.time.Clock;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Supplier;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Exceptions;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.NeoStoreKernelModule;
import org.neo4j.kernel.NeoStoreTransactionLogModule;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.explicitindex.AutoIndexing;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.dependency.AllByPrioritySelectionStrategy;
import org.neo4j.kernel.guard.Guard;
import org.neo4j.kernel.impl.api.CommitProcessFactory;
import org.neo4j.kernel.impl.api.ConstraintEnforcingEntityOperations;
import org.neo4j.kernel.impl.api.DataIntegrityValidatingStatementOperations;
import org.neo4j.kernel.impl.api.DatabaseSchemaState;
import org.neo4j.kernel.impl.api.ExplicitIndexProviderLookup;
import org.neo4j.kernel.impl.api.Kernel;
import org.neo4j.kernel.impl.api.KernelTransactionMonitorScheduler;
import org.neo4j.kernel.impl.api.KernelTransactionTimeoutMonitor;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.api.KernelTransactionsSnapshot;
import org.neo4j.kernel.impl.api.LockingStatementOperations;
import org.neo4j.kernel.impl.api.SchemaState;
import org.neo4j.kernel.impl.api.SchemaStateConcern;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.StackingQueryRegistrationOperations;
import org.neo4j.kernel.impl.api.StateHandlingStatementOperations;
import org.neo4j.kernel.impl.api.StatementOperationParts;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionHooks;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.SchemaIndexProviderMap;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.core.StartupStatisticsProvider;
import org.neo4j.kernel.impl.factory.AccessCapability;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.kernel.impl.index.ExplicitIndexStore;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.locking.ReentrantLockService;
import org.neo4j.kernel.impl.locking.StatementLocksFactory;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.id.IdController;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.store.format.RecordFormatPropertyConfigurator;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.storemigration.DatabaseMigrator;
import org.neo4j.kernel.impl.storemigration.monitoring.VisibleMigrationProgressMonitor;
import org.neo4j.kernel.impl.storemigration.participant.StoreMigrator;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.impl.transaction.log.BatchingTransactionAppender;
import org.neo4j.kernel.impl.transaction.log.LogHeaderCache;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogTailScanner;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.LogVersionUpgradeChecker;
import org.neo4j.kernel.impl.transaction.log.LoggingLogFileMonitor;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFile;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFileInformation;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointScheduler;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointThreshold;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointerImpl;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.StoreCopyCheckPointMutex;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruneStrategy;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruneStrategyFactory;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruningImpl;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotationImpl;
import org.neo4j.kernel.impl.transaction.state.DefaultSchemaIndexProviderMap;
import org.neo4j.kernel.impl.transaction.state.NeoStoreFileListing;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.impl.util.SynchronizedArrayIdOrderingQueue;
import org.neo4j.kernel.info.DiagnosticsExtractor;
import org.neo4j.kernel.info.DiagnosticsManager;
import org.neo4j.kernel.info.DiagnosticsPhase;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.kernel.internal.TransactionEventHandlers;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.lifecycle.Lifecycles;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.kernel.monitoring.tracing.Tracers;
import org.neo4j.kernel.recovery.DefaultRecoverySPI;
import org.neo4j.kernel.recovery.PositionToRecoverFrom;
import org.neo4j.kernel.recovery.Recovery;
import org.neo4j.kernel.spi.explicitindex.IndexImplementation;
import org.neo4j.kernel.spi.explicitindex.IndexProviders;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.Logger;
import org.neo4j.resources.CpuClock;
import org.neo4j.resources.HeapAllocation;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StoreFileMetadata;
import org.neo4j.storageengine.api.StoreReadLayer;
import org.neo4j.time.SystemNanoClock;

public class NeoStoreDataSource
implements Lifecycle,
IndexProviders {
    public static final String DEFAULT_DATA_SOURCE_NAME = "nioneodb";
    private final Monitors monitors;
    private final Tracers tracers;
    private final Log msgLog;
    private final LogService logService;
    private final AutoIndexing autoIndexing;
    private final LogProvider logProvider;
    private final DependencyResolver dependencyResolver;
    private final TokenNameLookup tokenNameLookup;
    private final PropertyKeyTokenHolder propertyKeyTokenHolder;
    private final LabelTokenHolder labelTokens;
    private final RelationshipTypeTokenHolder relationshipTypeTokens;
    private final StatementLocksFactory statementLocksFactory;
    private final SchemaWriteGuard schemaWriteGuard;
    private final TransactionEventHandlers transactionEventHandlers;
    private final IdGeneratorFactory idGeneratorFactory;
    private final JobScheduler scheduler;
    private final Config config;
    private final LockService lockService;
    private final IndexingService.Monitor indexingServiceMonitor;
    private final FileSystemAbstraction fs;
    private final TransactionMonitor transactionMonitor;
    private final DatabaseHealth databaseHealth;
    private final PhysicalLogFile.Monitor physicalLogMonitor;
    private final TransactionHeaderInformationFactory transactionHeaderInformationFactory;
    private final StartupStatisticsProvider startupStatistics;
    private final CommitProcessFactory commitProcessFactory;
    private final PageCache pageCache;
    private final Guard guard;
    private final Map<String, IndexImplementation> indexProviders = new HashMap<String, IndexImplementation>();
    private final ExplicitIndexProviderLookup explicitIndexProviderLookup;
    private final ConstraintSemantics constraintSemantics;
    private final Procedures procedures;
    private final IOLimiter ioLimiter;
    private final AvailabilityGuard availabilityGuard;
    private final SystemNanoClock clock;
    private final StoreCopyCheckPointMutex storeCopyCheckPointMutex;
    private Dependencies dependencies;
    private LifeSupport life;
    private SchemaIndexProviderMap schemaIndexProviderMap;
    private File storeDir;
    private boolean readOnly;
    private final IdController idController;
    private final OperationalMode operationalMode;
    private final RecoveryCleanupWorkCollector recoveryCleanupWorkCollector;
    private final VersionContextSupplier versionContextSupplier;
    private final AccessCapability accessCapability;
    private StorageEngine storageEngine;
    private NeoStoreTransactionLogModule transactionLogModule;
    private NeoStoreKernelModule kernelModule;

    public NeoStoreDataSource(File storeDir, Config config, IdGeneratorFactory idGeneratorFactory, LogService logService, JobScheduler scheduler, TokenNameLookup tokenNameLookup, DependencyResolver dependencyResolver, PropertyKeyTokenHolder propertyKeyTokens, LabelTokenHolder labelTokens, RelationshipTypeTokenHolder relationshipTypeTokens, StatementLocksFactory statementLocksFactory, SchemaWriteGuard schemaWriteGuard, TransactionEventHandlers transactionEventHandlers, IndexingService.Monitor indexingServiceMonitor, FileSystemAbstraction fs, TransactionMonitor transactionMonitor, DatabaseHealth databaseHealth, PhysicalLogFile.Monitor physicalLogMonitor, TransactionHeaderInformationFactory transactionHeaderInformationFactory, StartupStatisticsProvider startupStatistics, Guard guard, CommitProcessFactory commitProcessFactory, AutoIndexing autoIndexing, PageCache pageCache, ConstraintSemantics constraintSemantics, Monitors monitors, Tracers tracers, Procedures procedures, IOLimiter ioLimiter, AvailabilityGuard availabilityGuard, SystemNanoClock clock, AccessCapability accessCapability, StoreCopyCheckPointMutex storeCopyCheckPointMutex, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, IdController idController, OperationalMode operationalMode, VersionContextSupplier versionContextSupplier) {
        this.storeDir = storeDir;
        this.config = config;
        this.idGeneratorFactory = idGeneratorFactory;
        this.tokenNameLookup = tokenNameLookup;
        this.dependencyResolver = dependencyResolver;
        this.scheduler = scheduler;
        this.logService = logService;
        this.autoIndexing = autoIndexing;
        this.storeCopyCheckPointMutex = storeCopyCheckPointMutex;
        this.logProvider = logService.getInternalLogProvider();
        this.propertyKeyTokenHolder = propertyKeyTokens;
        this.labelTokens = labelTokens;
        this.relationshipTypeTokens = relationshipTypeTokens;
        this.statementLocksFactory = statementLocksFactory;
        this.schemaWriteGuard = schemaWriteGuard;
        this.transactionEventHandlers = transactionEventHandlers;
        this.indexingServiceMonitor = indexingServiceMonitor;
        this.fs = fs;
        this.transactionMonitor = transactionMonitor;
        this.databaseHealth = databaseHealth;
        this.physicalLogMonitor = physicalLogMonitor;
        this.transactionHeaderInformationFactory = transactionHeaderInformationFactory;
        this.startupStatistics = startupStatistics;
        this.guard = guard;
        this.constraintSemantics = constraintSemantics;
        this.monitors = monitors;
        this.tracers = tracers;
        this.procedures = procedures;
        this.ioLimiter = ioLimiter;
        this.availabilityGuard = availabilityGuard;
        this.clock = clock;
        this.accessCapability = accessCapability;
        this.recoveryCleanupWorkCollector = recoveryCleanupWorkCollector;
        this.readOnly = config.get(Configuration.read_only);
        this.idController = idController;
        this.operationalMode = operationalMode;
        this.versionContextSupplier = versionContextSupplier;
        this.msgLog = this.logProvider.getLog(this.getClass());
        this.lockService = new ReentrantLockService();
        this.explicitIndexProviderLookup = new ExplicitIndexProviderLookup(){

            @Override
            public IndexImplementation apply(String name) {
                assert (name != null) : "Null provider name supplied";
                IndexImplementation provider = (IndexImplementation)NeoStoreDataSource.this.indexProviders.get(name);
                if (provider == null) {
                    throw new IllegalArgumentException("No index provider '" + name + "' found. Maybe the intended provider (or one more of its dependencies) aren't on the classpath or it failed to load.");
                }
                return provider;
            }

            @Override
            public Iterable<IndexImplementation> all() {
                return NeoStoreDataSource.this.indexProviders.values();
            }
        };
        this.commitProcessFactory = commitProcessFactory;
        this.pageCache = pageCache;
        this.monitors.addMonitorListener(new LoggingLogFileMonitor(this.msgLog), new String[0]);
    }

    public void init() {
    }

    public void start() throws IOException {
        this.dependencies = new Dependencies();
        this.life = new LifeSupport();
        this.life.add((Lifecycle)this.recoveryCleanupWorkCollector);
        AllByPrioritySelectionStrategy indexProviderSelection = new AllByPrioritySelectionStrategy();
        SchemaIndexProvider defaultIndexProvider = (SchemaIndexProvider)this.dependencyResolver.resolveDependency(SchemaIndexProvider.class, indexProviderSelection);
        this.schemaIndexProviderMap = new DefaultSchemaIndexProviderMap(defaultIndexProvider, indexProviderSelection.lowerPrioritizedCandidates());
        this.dependencies.satisfyDependency(this.schemaIndexProviderMap);
        IndexConfigStore indexConfigStore = new IndexConfigStore(this.storeDir, this.fs);
        this.dependencies.satisfyDependency(this.lockService);
        this.dependencies.satisfyDependency(indexConfigStore);
        this.life.add((Lifecycle)indexConfigStore);
        this.life.add((Lifecycle)new Lifecycle.Delegate(Lifecycles.multiple(this.indexProviders.values())));
        PhysicalLogFiles logFiles = new PhysicalLogFiles(this.storeDir, "neostore.transaction.db", this.fs);
        VersionAwareLogEntryReader<ReadableClosablePositionAwareChannel> logEntryReader = new VersionAwareLogEntryReader<ReadableClosablePositionAwareChannel>();
        LogTailScanner tailScanner = new LogTailScanner(logFiles, this.fs, logEntryReader);
        LogVersionUpgradeChecker.check(tailScanner, this.config);
        RecordFormats formats = NeoStoreDataSource.selectStoreFormats(this.config, this.storeDir, this.fs, this.pageCache, this.logService);
        this.upgradeStore(formats, tailScanner);
        StorageEngine storageEngine = null;
        try {
            DatabaseSchemaState databaseSchemaState = new DatabaseSchemaState(this.logProvider);
            SynchronizedArrayIdOrderingQueue explicitIndexTransactionOrdering = new SynchronizedArrayIdOrderingQueue(20);
            Supplier<KernelTransactionsSnapshot> transactionsSnapshotSupplier = () -> this.kernelModule.kernelTransactions().get();
            this.idController.initialize(transactionsSnapshotSupplier);
            storageEngine = this.buildStorageEngine(this.propertyKeyTokenHolder, this.labelTokens, this.relationshipTypeTokens, this.explicitIndexProviderLookup, indexConfigStore, databaseSchemaState, explicitIndexTransactionOrdering, this.operationalMode, this.versionContextSupplier);
            TransactionIdStore transactionIdStore = (TransactionIdStore)this.dependencies.resolveDependency(TransactionIdStore.class);
            this.versionContextSupplier.init(transactionIdStore::getLastClosedTransactionId);
            LogVersionRepository logVersionRepository = (LogVersionRepository)this.dependencies.resolveDependency(LogVersionRepository.class);
            NeoStoreTransactionLogModule transactionLogModule = this.buildTransactionLogs(logFiles, this.config, this.logProvider, this.scheduler, this.fs, storageEngine, logEntryReader, explicitIndexTransactionOrdering, transactionIdStore, logVersionRepository);
            transactionLogModule.satisfyDependencies(this.dependencies);
            this.buildRecovery(this.fs, transactionIdStore, tailScanner, this.monitors.newMonitor(Recovery.Monitor.class, new String[0]), this.monitors.newMonitor(PositionToRecoverFrom.Monitor.class, new String[0]), logFiles, this.startupStatistics, storageEngine, transactionLogModule.logicalTransactionStore());
            PropertyAccessor propertyAccessor = (PropertyAccessor)this.dependencies.resolveDependency(PropertyAccessor.class);
            NeoStoreKernelModule kernelModule = this.buildKernel(transactionLogModule.transactionAppender(), (IndexingService)this.dependencies.resolveDependency(IndexingService.class), storageEngine.storeReadLayer(), databaseSchemaState, (LabelScanStore)this.dependencies.resolveDependency(LabelScanStore.class), storageEngine, indexConfigStore, transactionIdStore, this.availabilityGuard, (Clock)this.clock, propertyAccessor);
            kernelModule.satisfyDependencies(this.dependencies);
            this.storageEngine = storageEngine;
            this.transactionLogModule = transactionLogModule;
            this.kernelModule = kernelModule;
            this.dependencies.satisfyDependency(this);
            this.dependencies.satisfyDependency(databaseSchemaState);
            this.dependencies.satisfyDependency(storageEngine.storeReadLayer());
            this.dependencies.satisfyDependency(logEntryReader);
            this.dependencies.satisfyDependency(storageEngine);
            this.dependencies.satisfyDependency(this.explicitIndexProviderLookup);
        }
        catch (Throwable e) {
            this.msgLog.warn("Exception occurred while setting up store modules. Attempting to close things down.", e);
            try {
                if (storageEngine != null) {
                    storageEngine.forceClose();
                }
            }
            catch (Exception closeException) {
                this.msgLog.error("Couldn't close neostore after startup failure", (Throwable)closeException);
            }
            throw Exceptions.launderedException((Throwable)e);
        }
        this.life.add(this.lifecycleToTriggerCheckPointOnShutdown());
        try {
            this.life.start();
        }
        catch (Throwable e) {
            this.msgLog.warn("Exception occurred while starting the datasource. Attempting to close things down.", e);
            try {
                this.life.shutdown();
                storageEngine.forceClose();
            }
            catch (Exception closeException) {
                this.msgLog.error("Couldn't close neostore after startup failure", (Throwable)closeException);
            }
            throw Exceptions.launderedException((Throwable)e);
        }
        this.databaseHealth.healed();
    }

    private static RecordFormats selectStoreFormats(Config config, File storeDir, FileSystemAbstraction fs, PageCache pageCache, LogService logService) {
        LogProvider logging = logService.getInternalLogProvider();
        RecordFormats formats = RecordFormatSelector.selectNewestFormat(config, storeDir, fs, pageCache, logging);
        new RecordFormatPropertyConfigurator(formats, config).configure();
        return formats;
    }

    private void upgradeStore(RecordFormats format, LogTailScanner tailScanner) {
        VisibleMigrationProgressMonitor progressMonitor = new VisibleMigrationProgressMonitor(this.logService.getUserLog(StoreMigrator.class));
        new DatabaseMigrator(progressMonitor, this.fs, this.config, this.logService, this.schemaIndexProviderMap, this.indexProviders, this.pageCache, format, tailScanner).migrate(this.storeDir);
    }

    private StorageEngine buildStorageEngine(PropertyKeyTokenHolder propertyKeyTokenHolder, LabelTokenHolder labelTokens, RelationshipTypeTokenHolder relationshipTypeTokens, ExplicitIndexProviderLookup explicitIndexProviderLookup, IndexConfigStore indexConfigStore, SchemaState schemaState, SynchronizedArrayIdOrderingQueue explicitIndexTransactionOrdering, OperationalMode operationalMode, VersionContextSupplier versionContextSupplier) {
        RecordStorageEngine storageEngine = new RecordStorageEngine(this.storeDir, this.config, this.pageCache, this.fs, this.logProvider, propertyKeyTokenHolder, labelTokens, relationshipTypeTokens, schemaState, this.constraintSemantics, this.scheduler, this.tokenNameLookup, this.lockService, this.schemaIndexProviderMap, this.indexingServiceMonitor, this.databaseHealth, explicitIndexProviderLookup, indexConfigStore, explicitIndexTransactionOrdering, this.idGeneratorFactory, this.idController, this.monitors, this.recoveryCleanupWorkCollector, operationalMode, versionContextSupplier);
        storageEngine.satisfyDependencies(this.dependencies);
        return (StorageEngine)this.life.add((Lifecycle)storageEngine);
    }

    private NeoStoreTransactionLogModule buildTransactionLogs(PhysicalLogFiles logFiles, Config config, LogProvider logProvider, JobScheduler scheduler, FileSystemAbstraction fileSystemAbstraction, StorageEngine storageEngine, LogEntryReader<ReadableClosablePositionAwareChannel> logEntryReader, SynchronizedArrayIdOrderingQueue explicitIndexTransactionOrdering, TransactionIdStore transactionIdStore, LogVersionRepository logVersionRepository) {
        TransactionMetadataCache transactionMetadataCache = new TransactionMetadataCache(100000);
        LogHeaderCache logHeaderCache = new LogHeaderCache(1000);
        PhysicalLogFile logFile = (PhysicalLogFile)this.life.add((Lifecycle)new PhysicalLogFile(fileSystemAbstraction, logFiles, config.get(GraphDatabaseSettings.logical_log_rotation_threshold), transactionIdStore::getLastCommittedTransactionId, logVersionRepository, this.physicalLogMonitor, logHeaderCache));
        PhysicalLogFileInformation.LogVersionToTimestamp logInformation = version -> {
            LogPosition position = LogPosition.start(version);
            try (ReadableLogChannel channel = logFile.getReader(position);){
                LogEntry entry;
                while ((entry = logEntryReader.readLogEntry(channel)) != null) {
                    if (!(entry instanceof LogEntryStart)) continue;
                    long l = ((LogEntryStart)entry.as()).getTimeWritten();
                    return l;
                }
            }
            return -1L;
        };
        PhysicalLogFileInformation logFileInformation = new PhysicalLogFileInformation(logFiles, logHeaderCache, transactionIdStore::getLastCommittedTransactionId, logInformation);
        if (config.get(GraphDatabaseFacadeFactory.Configuration.ephemeral).booleanValue()) {
            config.augmentDefaults(GraphDatabaseSettings.keep_logical_logs, "1 files");
        }
        String pruningConf = config.get(GraphDatabaseSettings.keep_logical_logs);
        LogPruneStrategy logPruneStrategy = LogPruneStrategyFactory.fromConfigValue(this.fs, logFileInformation, logFiles, pruningConf);
        LogPruningImpl logPruning = new LogPruningImpl(this.fs, logPruneStrategy, logFiles, logProvider);
        LogRotationImpl logRotation = new LogRotationImpl(this.monitors.newMonitor(LogRotation.Monitor.class, new String[0]), logFile, this.databaseHealth);
        TransactionAppender appender = (TransactionAppender)this.life.add((Lifecycle)new BatchingTransactionAppender(logFile, logRotation, transactionMetadataCache, transactionIdStore, explicitIndexTransactionOrdering, this.databaseHealth));
        PhysicalLogicalTransactionStore logicalTransactionStore = new PhysicalLogicalTransactionStore(logFile, transactionMetadataCache, logEntryReader);
        CheckPointThreshold threshold = CheckPointThreshold.createThreshold(config, (Clock)this.clock, logPruning, logProvider);
        CheckPointerImpl checkPointer = new CheckPointerImpl(transactionIdStore, threshold, storageEngine, logPruning, appender, this.databaseHealth, logProvider, this.tracers.checkPointTracer, this.ioLimiter, this.storeCopyCheckPointMutex);
        long recurringPeriod = threshold.checkFrequencyMillis();
        CheckPointScheduler checkPointScheduler = new CheckPointScheduler(checkPointer, this.ioLimiter, scheduler, recurringPeriod, this.databaseHealth);
        this.life.add((Lifecycle)checkPointer);
        this.life.add((Lifecycle)checkPointScheduler);
        return new NeoStoreTransactionLogModule(logicalTransactionStore, logFileInformation, logFiles, logFile, logRotation, checkPointer, appender, explicitIndexTransactionOrdering);
    }

    private void buildRecovery(FileSystemAbstraction fileSystemAbstraction, TransactionIdStore transactionIdStore, LogTailScanner tailScanner, Recovery.Monitor recoveryMonitor, PositionToRecoverFrom.Monitor positionMonitor, PhysicalLogFiles logFiles, final StartupStatisticsProvider startupStatistics, StorageEngine storageEngine, LogicalTransactionStore logicalTransactionStore) {
        DefaultRecoverySPI spi = new DefaultRecoverySPI(storageEngine, logFiles, fileSystemAbstraction, tailScanner, transactionIdStore, logicalTransactionStore, positionMonitor);
        Recovery recovery = new Recovery(spi, recoveryMonitor);
        this.monitors.addMonitorListener(new Recovery.Monitor(){

            @Override
            public void recoveryCompleted(int numberOfRecoveredTransactions) {
                startupStatistics.setNumberOfRecoveredTransactions(numberOfRecoveredTransactions);
            }
        }, new String[0]);
        this.life.add((Lifecycle)recovery);
    }

    private NeoStoreKernelModule buildKernel(TransactionAppender appender, IndexingService indexingService, StoreReadLayer storeLayer, DatabaseSchemaState databaseSchemaState, LabelScanStore labelScanStore, StorageEngine storageEngine, IndexConfigStore indexConfigStore, TransactionIdStore transactionIdStore, AvailabilityGuard availabilityGuard, Clock clock, PropertyAccessor propertyAccessor) throws KernelException, IOException {
        TransactionCommitProcess transactionCommitProcess = this.commitProcessFactory.create(appender, storageEngine, this.config);
        Supplier<KernelAPI> kernelProvider = () -> this.kernelModule.kernelAPI();
        ConstraintIndexCreator constraintIndexCreator = new ConstraintIndexCreator(kernelProvider, indexingService, propertyAccessor);
        ExplicitIndexStore explicitIndexStore = new ExplicitIndexStore(this.config, indexConfigStore, kernelProvider, this.explicitIndexProviderLookup);
        StatementOperationParts statementOperationParts = this.dependencies.satisfyDependency(this.buildStatementOperations(storeLayer, this.autoIndexing, constraintIndexCreator, databaseSchemaState, this.guard, explicitIndexStore));
        TransactionHooks hooks = new TransactionHooks();
        KernelTransactions kernelTransactions = (KernelTransactions)this.life.add((Lifecycle)new KernelTransactions(this.statementLocksFactory, constraintIndexCreator, statementOperationParts, this.schemaWriteGuard, this.transactionHeaderInformationFactory, transactionCommitProcess, indexConfigStore, this.explicitIndexProviderLookup, hooks, this.transactionMonitor, availabilityGuard, this.tracers, storageEngine, this.procedures, transactionIdStore, clock, this.accessCapability, this.versionContextSupplier));
        this.buildTransactionMonitor(kernelTransactions, clock, this.config);
        Kernel kernel = new Kernel(kernelTransactions, hooks, this.databaseHealth, this.transactionMonitor, this.procedures, this.config);
        kernel.registerTransactionHook(this.transactionEventHandlers);
        NeoStoreFileListing fileListing = new NeoStoreFileListing(this.storeDir, labelScanStore, indexingService, this.explicitIndexProviderLookup, storageEngine);
        return new NeoStoreKernelModule(transactionCommitProcess, kernel, kernelTransactions, fileListing);
    }

    private void buildTransactionMonitor(KernelTransactions kernelTransactions, Clock clock, Config config) {
        KernelTransactionTimeoutMonitor kernelTransactionTimeoutMonitor = new KernelTransactionTimeoutMonitor(kernelTransactions, clock, this.logService);
        this.dependencies.satisfyDependency(kernelTransactionTimeoutMonitor);
        KernelTransactionMonitorScheduler transactionMonitorScheduler = new KernelTransactionMonitorScheduler(kernelTransactionTimeoutMonitor, this.scheduler, config.get(GraphDatabaseSettings.transaction_monitor_check_interval).toMillis());
        this.life.add((Lifecycle)transactionMonitorScheduler);
    }

    public synchronized void stop() {
        if (!this.life.isRunning()) {
            return;
        }
        this.life.stop();
        this.awaitAllClosingTransactions();
        this.life.shutdown();
    }

    private void awaitAllClosingTransactions() {
        KernelTransactions kernelTransactions = this.kernelModule.kernelTransactions();
        kernelTransactions.terminateTransactions();
        while (kernelTransactions.haveClosingTransaction()) {
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
        }
    }

    private Lifecycle lifecycleToTriggerCheckPointOnShutdown() {
        return new LifecycleAdapter(){

            public void shutdown() throws Throwable {
                if (NeoStoreDataSource.this.databaseHealth.isHealthy()) {
                    NeoStoreDataSource.this.transactionLogModule.checkPointing().forceCheckPoint(new SimpleTriggerInfo("database shutdown"));
                }
            }
        };
    }

    public void shutdown() {
    }

    public StoreId getStoreId() {
        return ((MetaDataStore)this.getDependencyResolver().resolveDependency(MetaDataStore.class)).getStoreId();
    }

    public File getStoreDir() {
        return this.storeDir;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public KernelAPI getKernel() {
        return this.kernelModule.kernelAPI();
    }

    public ResourceIterator<StoreFileMetadata> listStoreFiles(boolean includeLogs) throws IOException {
        return this.kernelModule.fileListing().listStoreFiles(includeLogs);
    }

    public void registerDiagnosticsWith(DiagnosticsManager manager) {
        this.storageEngine.registerDiagnostics(manager);
        manager.registerAll(Diagnostics.class, this);
    }

    public StoreReadLayer getStoreLayer() {
        return this.storageEngine.storeReadLayer();
    }

    public DependencyResolver getDependencyResolver() {
        return this.dependencies;
    }

    private StatementOperationParts buildStatementOperations(StoreReadLayer storeReadLayer, AutoIndexing autoIndexing, ConstraintIndexCreator constraintIndexCreator, DatabaseSchemaState databaseSchemaState, Guard guard, ExplicitIndexStore explicitIndexStore) {
        StateHandlingStatementOperations stateHandlingContext = new StateHandlingStatementOperations(storeReadLayer, autoIndexing, constraintIndexCreator, explicitIndexStore);
        CpuClock cpuClock = CpuClock.NOT_AVAILABLE;
        if (this.config.get(GraphDatabaseSettings.track_query_cpu_time).booleanValue()) {
            cpuClock = CpuClock.CPU_CLOCK;
        }
        HeapAllocation heapAllocation = HeapAllocation.NOT_AVAILABLE;
        if (this.config.get(GraphDatabaseSettings.track_query_allocation).booleanValue()) {
            heapAllocation = HeapAllocation.HEAP_ALLOCATION;
        }
        StackingQueryRegistrationOperations queryRegistrationOperations = new StackingQueryRegistrationOperations(this.clock, cpuClock, heapAllocation);
        StatementOperationParts parts = new StatementOperationParts(stateHandlingContext, stateHandlingContext, stateHandlingContext, stateHandlingContext, stateHandlingContext, stateHandlingContext, new SchemaStateConcern(databaseSchemaState), null, stateHandlingContext, stateHandlingContext, stateHandlingContext, queryRegistrationOperations);
        ConstraintEnforcingEntityOperations constraintEnforcingEntityOperations = new ConstraintEnforcingEntityOperations(this.constraintSemantics, parts.entityWriteOperations(), parts.entityReadOperations(), parts.schemaWriteOperations(), parts.schemaReadOperations());
        DataIntegrityValidatingStatementOperations dataIntegrityContext = new DataIntegrityValidatingStatementOperations(parts.keyWriteOperations(), parts.schemaReadOperations(), constraintEnforcingEntityOperations);
        parts = parts.override(null, dataIntegrityContext, constraintEnforcingEntityOperations, constraintEnforcingEntityOperations, null, dataIntegrityContext, null, null, null, null, null, null);
        LockingStatementOperations lockingContext = new LockingStatementOperations(parts.entityReadOperations(), parts.entityWriteOperations(), parts.schemaReadOperations(), parts.schemaWriteOperations(), parts.schemaStateOperations());
        parts = parts.override(null, null, null, lockingContext, lockingContext, lockingContext, lockingContext, lockingContext, null, null, null, null);
        return parts;
    }

    @Override
    public void registerIndexProvider(String name, IndexImplementation index) {
        assert (!this.indexProviders.containsKey(name)) : "Index provider '" + name + "' already registered";
        this.indexProviders.put(name, index);
    }

    @Override
    public boolean unregisterIndexProvider(String name) {
        IndexImplementation removed = this.indexProviders.remove(name);
        return removed != null;
    }

    public void beforeModeSwitch() {
        this.clearTransactions();
    }

    private void clearTransactions() {
        this.storageEngine.clearBufferedIds();
        this.kernelModule.kernelTransactions().disposeAll();
    }

    public void afterModeSwitch() {
        this.storageEngine.loadSchemaCache();
        this.clearTransactions();
    }

    public LifeSupport getLife() {
        return this.life;
    }

    public static abstract class Configuration {
        public static final Setting<String> keep_logical_logs = GraphDatabaseSettings.keep_logical_logs;
        public static final Setting<Boolean> read_only = GraphDatabaseSettings.read_only;
    }

    static enum Diagnostics implements DiagnosticsExtractor<NeoStoreDataSource>
    {
        TRANSACTION_RANGE("Transaction log:"){

            @Override
            void dump(NeoStoreDataSource source, Logger log) {
                PhysicalLogFiles logFiles = (PhysicalLogFiles)source.getDependencyResolver().resolveDependency(PhysicalLogFiles.class);
                try {
                    long logVersion = logFiles.getLowestLogVersion();
                    while (logFiles.versionExists(logVersion)) {
                        if (logFiles.hasAnyEntries(logVersion)) {
                            LogHeader header = logFiles.extractHeader(logVersion);
                            long firstTransactionIdInThisLog = header.lastCommittedTxId + 1L;
                            log.log("Oldest transaction " + firstTransactionIdInThisLog + " found in log with version " + logVersion);
                            return;
                        }
                        ++logVersion;
                    }
                    log.log("No transactions found in any log");
                }
                catch (IOException e) {
                    log.log("Error trying to figure out oldest transaction in log");
                }
            }
        };

        private final String message;

        private Diagnostics(String message) {
            this.message = message;
        }

        @Override
        public void dumpDiagnostics(NeoStoreDataSource source, DiagnosticsPhase phase, Logger logger) {
            if (this.applicable(phase)) {
                logger.log(this.message);
                this.dump(source, logger);
            }
        }

        boolean applicable(DiagnosticsPhase phase) {
            return phase.isInitialization() || phase.isExplicitlyRequested();
        }

        abstract void dump(NeoStoreDataSource var1, Logger var2);
    }
}

