/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.StringJoiner;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.neo4j.helpers.Format;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.logging.Log;

public class LoggingMonitor
implements SchemaIndexProvider.Monitor {
    private final Log log;

    public LoggingMonitor(Log log) {
        this.log = log;
    }

    @Override
    public void failedToOpenIndex(long indexId, IndexDescriptor indexDescriptor, String action, Exception cause) {
        this.log.error("Failed to open index:" + indexId + ". " + action, (Throwable)cause);
    }

    @Override
    public void recoveryCleanupRegistered(long indexId, IndexDescriptor indexDescriptor) {
        this.log.info("Schema index cleanup job registered: " + this.indexDescription(indexId, indexDescriptor));
    }

    @Override
    public void recoveryCleanupStarted(long indexId, IndexDescriptor indexDescriptor) {
        this.log.info("Schema index cleanup job started: " + this.indexDescription(indexId, indexDescriptor));
    }

    @Override
    public void recoveryCleanupFinished(long indexId, IndexDescriptor indexDescriptor, long numberOfPagesVisited, long numberOfCleanedCrashPointers, long durationMillis) {
        StringJoiner joiner = new StringJoiner(", ", "Schema index cleanup job finished: " + this.indexDescription(indexId, indexDescriptor) + " ", "");
        joiner.add("Number of pages visited: " + numberOfPagesVisited);
        joiner.add("Number of cleaned crashed pointers: " + numberOfCleanedCrashPointers);
        joiner.add("Time spent: " + Format.duration(durationMillis));
        this.log.info(joiner.toString());
    }

    @Override
    public void recoveryCleanupClosed(long indexId, IndexDescriptor descriptor) {
        this.log.info("Schema index cleanup job closed: " + this.indexDescription(indexId, descriptor));
    }

    @Override
    public void recoveryCleanupFailed(long indexId, IndexDescriptor descriptor, Throwable throwable) {
        this.log.info("Schema index cleanup job failed: " + this.indexDescription(indexId, descriptor) + ".\nCaused by: " + ExceptionUtils.getStackTrace((Throwable)throwable));
    }

    private String indexDescription(long indexId, IndexDescriptor indexDescriptor) {
        return "indexId: " + indexId + " descriptor: " + indexDescriptor.toString();
    }
}

