/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Future;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.FutureAdapter;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexCountsRemover;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.updater.UpdateCountingIndexUpdater;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.PopulationProgress;

public class OnlineIndexProxy
implements IndexProxy {
    private final long indexId;
    private final IndexDescriptor descriptor;
    final IndexAccessor accessor;
    private final IndexStoreView storeView;
    private final SchemaIndexProvider.Descriptor providerDescriptor;
    private final IndexCountsRemover indexCountsRemover;
    private boolean started;
    private final boolean forcedIdempotentMode;

    public OnlineIndexProxy(long indexId, IndexDescriptor descriptor, IndexAccessor accessor, IndexStoreView storeView, SchemaIndexProvider.Descriptor providerDescriptor, boolean forcedIdempotentMode) {
        assert (accessor != null);
        this.indexId = indexId;
        this.descriptor = descriptor;
        this.storeView = storeView;
        this.providerDescriptor = providerDescriptor;
        this.accessor = accessor;
        this.forcedIdempotentMode = forcedIdempotentMode;
        this.indexCountsRemover = new IndexCountsRemover(storeView, indexId);
    }

    @Override
    public void start() {
        this.started = true;
    }

    @Override
    public IndexUpdater newUpdater(IndexUpdateMode mode) {
        IndexUpdater actual = this.accessor.newUpdater(this.escalateModeIfNecessary(mode));
        return this.started ? this.updateCountingUpdater(actual) : actual;
    }

    private IndexUpdateMode escalateModeIfNecessary(IndexUpdateMode mode) {
        if (this.forcedIdempotentMode) {
            if (mode != IndexUpdateMode.ONLINE) {
                throw new IllegalArgumentException("Unexpected mode " + (Object)((Object)mode) + " given that " + this + " has been marked with forced idempotent mode. Expected mode " + (Object)((Object)IndexUpdateMode.ONLINE));
            }
            return IndexUpdateMode.ONLINE_IDEMPOTENT;
        }
        return mode;
    }

    private IndexUpdater updateCountingUpdater(IndexUpdater indexUpdater) {
        return new UpdateCountingIndexUpdater(this.storeView, this.indexId, indexUpdater);
    }

    @Override
    public Future<Void> drop() throws IOException {
        this.indexCountsRemover.remove();
        this.accessor.drop();
        return FutureAdapter.VOID;
    }

    @Override
    public IndexDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public LabelSchemaDescriptor schema() {
        return this.descriptor.schema();
    }

    @Override
    public SchemaIndexProvider.Descriptor getProviderDescriptor() {
        return this.providerDescriptor;
    }

    @Override
    public InternalIndexState getState() {
        return InternalIndexState.ONLINE;
    }

    @Override
    public void force(IOLimiter ioLimiter) throws IOException {
        this.accessor.force(ioLimiter);
    }

    @Override
    public void refresh() throws IOException {
        this.accessor.refresh();
    }

    @Override
    public Future<Void> close() throws IOException {
        this.accessor.close();
        return FutureAdapter.VOID;
    }

    @Override
    public IndexReader newReader() {
        return this.accessor.newReader();
    }

    @Override
    public boolean awaitStoreScanCompleted() throws IndexPopulationFailedKernelException, InterruptedException {
        return false;
    }

    @Override
    public void activate() {
    }

    @Override
    public void validate() {
    }

    @Override
    public IndexPopulationFailure getPopulationFailure() throws IllegalStateException {
        throw new IllegalStateException(this + " is ONLINE");
    }

    @Override
    public PopulationProgress getIndexPopulationProgress() {
        return PopulationProgress.DONE;
    }

    @Override
    public ResourceIterator<File> snapshotFiles() throws IOException {
        return this.accessor.snapshotFiles();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[accessor:" + this.accessor + ", descriptor:" + this.descriptor + "]";
    }

    @Override
    public void verifyDeferredConstraints(PropertyAccessor propertyAccessor) throws IndexEntryConflictException, IOException {
        this.accessor.verifyDeferredConstraints(propertyAccessor);
    }
}

