/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import java.util.function.Supplier;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.explicitindex.ExplicitIndexNotFoundKernelException;
import org.neo4j.kernel.impl.coreapi.ExplicitIndexProxy;

public class RelationshipExplicitIndexProxy
extends ExplicitIndexProxy<Relationship>
implements RelationshipIndex {
    public RelationshipExplicitIndexProxy(String name, GraphDatabaseService gds, Supplier<Statement> statementContextBridge) {
        super(name, ExplicitIndexProxy.Type.RELATIONSHIP, gds, statementContextBridge);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IndexHits<Relationship> get(String key, Object valueOrNull, Node startNodeOrNull, Node endNodeOrNull) {
        try (Statement statement = (Statement)this.statementContextBridge.get();){
            IndexHits indexHits = this.wrapIndexHits(statement.readOperations().relationshipExplicitIndexGet(this.name, key, valueOrNull, this.entityId(startNodeOrNull), this.entityId(endNodeOrNull)));
            return indexHits;
        }
        catch (ExplicitIndexNotFoundKernelException e) {
            throw new NotFoundException((Object)((Object)this.type) + " index '" + this.name + "' doesn't exist");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IndexHits<Relationship> query(String key, Object queryOrQueryObjectOrNull, Node startNodeOrNull, Node endNodeOrNull) {
        try (Statement statement = (Statement)this.statementContextBridge.get();){
            IndexHits indexHits = this.wrapIndexHits(statement.readOperations().relationshipExplicitIndexQuery(this.name, key, queryOrQueryObjectOrNull, this.entityId(startNodeOrNull), this.entityId(endNodeOrNull)));
            return indexHits;
        }
        catch (ExplicitIndexNotFoundKernelException e) {
            throw new NotFoundException((Object)((Object)this.type) + " index '" + this.name + "' doesn't exist");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IndexHits<Relationship> query(Object queryOrQueryObjectOrNull, Node startNodeOrNull, Node endNodeOrNull) {
        try (Statement statement = (Statement)this.statementContextBridge.get();){
            IndexHits indexHits = this.wrapIndexHits(statement.readOperations().relationshipExplicitIndexQuery(this.name, queryOrQueryObjectOrNull, this.entityId(startNodeOrNull), this.entityId(endNodeOrNull)));
            return indexHits;
        }
        catch (ExplicitIndexNotFoundKernelException e) {
            throw new NotFoundException((Object)((Object)this.type) + " index '" + this.name + "' doesn't exist");
        }
    }

    private long entityId(Node nodeOrNull) {
        return nodeOrNull == null ? -1L : nodeOrNull.getId();
    }
}

