/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.function.Consumer;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.index.GBPTreeFileUtil;
import org.neo4j.kernel.impl.index.schema.GBPTreeFileSystemFileUtil;
import org.neo4j.kernel.impl.index.schema.SchemaNumberKey;
import org.neo4j.kernel.impl.index.schema.SchemaNumberValue;

class NativeSchemaNumberIndex<KEY extends SchemaNumberKey, VALUE extends SchemaNumberValue> {
    final PageCache pageCache;
    final File storeFile;
    final Layout<KEY, VALUE> layout;
    final GBPTreeFileUtil gbpTreeFileUtil;
    final IndexDescriptor descriptor;
    private final long indexId;
    private final SchemaIndexProvider.Monitor monitor;
    GBPTree<KEY, VALUE> tree;

    NativeSchemaNumberIndex(PageCache pageCache, FileSystemAbstraction fs, File storeFile, Layout<KEY, VALUE> layout, SchemaIndexProvider.Monitor monitor, IndexDescriptor descriptor, long indexId) {
        this.pageCache = pageCache;
        this.storeFile = storeFile;
        this.layout = layout;
        this.gbpTreeFileUtil = new GBPTreeFileSystemFileUtil(fs);
        this.descriptor = descriptor;
        this.indexId = indexId;
        this.monitor = monitor;
    }

    void instantiateTree(RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, Consumer<PageCursor> headerWriter) throws IOException {
        this.ensureDirectoryExist();
        GBPTree.Monitor monitor = this.treeMonitor();
        this.tree = new GBPTree(this.pageCache, this.storeFile, this.layout, 0, monitor, GBPTree.NO_HEADER_READER, headerWriter, recoveryCleanupWorkCollector);
    }

    private GBPTree.Monitor treeMonitor() {
        return new NativeIndexTreeMonitor();
    }

    private void ensureDirectoryExist() throws IOException {
        this.gbpTreeFileUtil.mkdirs(this.storeFile.getParentFile());
    }

    void closeTree() throws IOException {
        this.tree = this.closeIfPresent((Closeable)this.tree);
    }

    <T extends Closeable> T closeIfPresent(T closeable) throws IOException {
        if (closeable != null) {
            closeable.close();
        }
        return null;
    }

    void assertOpen() {
        if (this.tree == null) {
            throw new IllegalStateException("Index has been closed");
        }
    }

    private class NativeIndexTreeMonitor
    extends GBPTree.Monitor.Adaptor {
        private NativeIndexTreeMonitor() {
        }

        public void cleanupRegistered() {
            NativeSchemaNumberIndex.this.monitor.recoveryCleanupRegistered(NativeSchemaNumberIndex.this.indexId, NativeSchemaNumberIndex.this.descriptor);
        }

        public void cleanupStarted() {
            NativeSchemaNumberIndex.this.monitor.recoveryCleanupStarted(NativeSchemaNumberIndex.this.indexId, NativeSchemaNumberIndex.this.descriptor);
        }

        public void cleanupFinished(long numberOfPagesVisited, long numberOfCleanedCrashPointers, long durationMillis) {
            NativeSchemaNumberIndex.this.monitor.recoveryCleanupFinished(NativeSchemaNumberIndex.this.indexId, NativeSchemaNumberIndex.this.descriptor, numberOfPagesVisited, numberOfCleanedCrashPointers, durationMillis);
        }

        public void cleanupClosed() {
            NativeSchemaNumberIndex.this.monitor.recoveryCleanupClosed(NativeSchemaNumberIndex.this.indexId, NativeSchemaNumberIndex.this.descriptor);
        }

        public void cleanupFailed(Throwable throwable) {
            NativeSchemaNumberIndex.this.monitor.recoveryCleanupFailed(NativeSchemaNumberIndex.this.indexId, NativeSchemaNumberIndex.this.descriptor, throwable);
        }
    }
}

