/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.kernel.impl.index.schema.RawBits;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;

class SchemaNumberKey
extends ValueWriter.Adapter<RuntimeException> {
    static final int SIZE = 17;
    byte type;
    long rawValueBits;
    long entityId;
    boolean entityIdIsSpecialTieBreaker = true;

    SchemaNumberKey() {
    }

    void from(long entityId, Value ... values) {
        this.extractRawBitsAndType(SchemaNumberKey.assertValidSingleNumber(values));
        this.entityId = entityId;
        this.entityIdIsSpecialTieBreaker = true;
    }

    private static NumberValue assertValidSingleNumber(Value ... values) {
        if (values.length > 1) {
            throw new IllegalArgumentException("Tried to create composite key with non-composite schema key layout");
        }
        if (values.length < 1) {
            throw new IllegalArgumentException("Tried to create key without value");
        }
        if (!Values.isNumberValue((Object)values[0])) {
            throw new IllegalArgumentException("Key layout does only support numbers, tried to create key from " + values[0]);
        }
        return (NumberValue)values[0];
    }

    String propertiesAsString() {
        return RawBits.asNumberValue(this.rawValueBits, this.type).toString();
    }

    void initAsLowest() {
        this.writeFloatingPoint(Double.NEGATIVE_INFINITY);
        this.entityId = Long.MIN_VALUE;
        this.entityIdIsSpecialTieBreaker = true;
    }

    void initAsHighest() {
        this.writeFloatingPoint(Double.POSITIVE_INFINITY);
        this.entityId = Long.MAX_VALUE;
        this.entityIdIsSpecialTieBreaker = true;
    }

    int compareValueTo(SchemaNumberKey other) {
        return RawBits.compare(this.rawValueBits, this.type, other.rawValueBits, other.type);
    }

    private void extractRawBitsAndType(NumberValue value) {
        value.writeTo((ValueWriter)this);
    }

    public String toString() {
        return String.format("type=%d,rawValue=%d,value=%s,entityId=%d", this.type, this.rawValueBits, RawBits.asNumberValue(this.rawValueBits, this.type), this.entityId);
    }

    public void writeInteger(byte value) {
        this.type = 0;
        this.rawValueBits = value;
    }

    public void writeInteger(short value) {
        this.type = 1;
        this.rawValueBits = value;
    }

    public void writeInteger(int value) {
        this.type = (byte)2;
        this.rawValueBits = value;
    }

    public void writeInteger(long value) {
        this.type = (byte)3;
        this.rawValueBits = value;
    }

    public void writeFloatingPoint(float value) {
        this.type = (byte)4;
        this.rawValueBits = Float.floatToIntBits(value);
    }

    public void writeFloatingPoint(double value) {
        this.type = (byte)5;
        this.rawValueBits = Double.doubleToLongBits(value);
    }
}

