/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import java.io.File;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruneStrategy;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruning;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class LogPruningImpl
implements LogPruning {
    private final Lock pruneLock = new ReentrantLock();
    private final FileSystemAbstraction fs;
    private final LogPruneStrategy pruneStrategy;
    private final PhysicalLogFiles logFiles;
    private final Log msgLog;

    public LogPruningImpl(FileSystemAbstraction fs, LogPruneStrategy pruneStrategy, PhysicalLogFiles logFiles, LogProvider logProvider) {
        this.fs = fs;
        this.pruneStrategy = pruneStrategy;
        this.logFiles = logFiles;
        this.msgLog = logProvider.getLog(this.getClass());
    }

    private void deleteLogVersion(long version) {
        File logFile = this.logFiles.getLogFileForVersion(version);
        this.fs.deleteFile(logFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pruneLogs(long upToVersion) {
        if (this.pruneLock.tryLock()) {
            String prefix = "Log Rotation [" + upToVersion + "]: ";
            this.msgLog.info(prefix + " Starting log pruning.");
            try {
                this.pruneStrategy.findLogVersionsToDelete(upToVersion).forEachOrdered(this::deleteLogVersion);
            }
            finally {
                this.pruneLock.unlock();
                this.msgLog.info(prefix + " Log pruning complete.");
            }
        }
    }

    @Override
    public boolean mightHaveLogsToPrune() {
        return this.pruneStrategy.findLogVersionsToDelete(this.logFiles.getHighestLogVersion()).count() > 0L;
    }
}

