/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.storemigration.monitoring.MigrationProgressMonitor;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.ProcessRelationshipCountsDataStep;
import org.neo4j.unsafe.impl.batchimport.RecordIdIterator;
import org.neo4j.unsafe.impl.batchimport.cache.NodeLabelsCache;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.staging.BatchFeedStep;
import org.neo4j.unsafe.impl.batchimport.staging.ReadRecordsStep;
import org.neo4j.unsafe.impl.batchimport.staging.Stage;

public class RelationshipCountsStage
extends Stage {
    public RelationshipCountsStage(Configuration config, NodeLabelsCache cache, RelationshipStore relationshipStore, int highLabelId, int highRelationshipTypeId, CountsAccessor.Updater countsUpdater, NumberArrayFactory cacheFactory, MigrationProgressMonitor.Section progressMonitor) {
        super("Relationship counts", config);
        this.add(new BatchFeedStep(this.control(), config, RecordIdIterator.allIn(relationshipStore, config), relationshipStore.getRecordSize()));
        this.add(new ReadRecordsStep<RelationshipRecord>(this.control(), config, false, relationshipStore, null));
        this.add(new ProcessRelationshipCountsDataStep(this.control(), cache, config, highLabelId, highRelationshipTypeId, countsUpdater, cacheFactory, progressMonitor));
    }
}

