/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.StringSearchMode;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.test.rule.ImpermanentDatabaseRule;

public abstract class IndexingStringQueryAcceptanceTestBase {
    @ClassRule
    public static ImpermanentDatabaseRule dbRule = new ImpermanentDatabaseRule();
    @Rule
    public final TestName testName = new TestName();
    private final String template;
    private final String[] matching;
    private final String[] nonMatching;
    private final StringSearchMode searchMode;
    private final boolean withIndex;
    private Label LABEL;
    private String KEY = "name";
    private GraphDatabaseService db;

    IndexingStringQueryAcceptanceTestBase(String template, String[] matching, String[] nonMatching, StringSearchMode searchMode, boolean withIndex) {
        this.template = template;
        this.matching = matching;
        this.nonMatching = nonMatching;
        this.searchMode = searchMode;
        this.withIndex = withIndex;
    }

    @Before
    public void setup() {
        this.LABEL = Label.label((String)("LABEL1-" + this.testName.getMethodName()));
        this.db = dbRule.getGraphDatabaseAPI();
        if (this.withIndex) {
            try (Transaction tx = this.db.beginTx();){
                this.db.schema().indexFor(this.LABEL).on(this.KEY).create();
                tx.success();
            }
            tx = this.db.beginTx();
            var2_2 = null;
            try {
                this.db.schema().awaitIndexesOnline(5L, TimeUnit.MINUTES);
                tx.success();
            }
            catch (Throwable throwable) {
                var2_2 = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (var2_2 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var2_2.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
    }

    @Test
    public void shouldSupportIndexSeek() {
        this.createNodes(this.db, this.LABEL, this.nonMatching);
        PrimitiveLongSet expected = this.createNodes(this.db, this.LABEL, this.matching);
        PrimitiveLongSet found = Primitive.longSet();
        try (Transaction tx = this.db.beginTx();){
            this.collectNodes(found, (ResourceIterator<Node>)this.db.findNodes(this.LABEL, this.KEY, this.template, this.searchMode));
        }
        Assert.assertThat((Object)found, (Matcher)IsEqual.equalTo((Object)expected));
    }

    @Test
    public void shouldIncludeNodesCreatedInSameTxInIndexSeek() {
        this.createNodes(this.db, this.LABEL, this.nonMatching[0], this.nonMatching[1]);
        PrimitiveLongSet expected = this.createNodes(this.db, this.LABEL, this.matching[0], this.matching[1]);
        PrimitiveLongSet found = Primitive.longSet();
        try (Transaction tx = this.db.beginTx();){
            expected.add(this.createNode(this.db, MapUtil.map((Object[])new Object[]{this.KEY, this.matching[2]}), this.LABEL).getId());
            this.createNode(this.db, MapUtil.map((Object[])new Object[]{this.KEY, this.nonMatching[2]}), this.LABEL);
            this.collectNodes(found, (ResourceIterator<Node>)this.db.findNodes(this.LABEL, this.KEY, this.template, this.searchMode));
        }
        Assert.assertThat((Object)found, (Matcher)IsEqual.equalTo((Object)expected));
    }

    @Test
    public void shouldNotIncludeNodesDeletedInSameTxInIndexSeek() {
        this.createNodes(this.db, this.LABEL, this.nonMatching[0]);
        PrimitiveLongSet toDelete = this.createNodes(this.db, this.LABEL, this.matching[0], this.nonMatching[1], this.matching[1], this.nonMatching[2]);
        PrimitiveLongSet expected = this.createNodes(this.db, this.LABEL, this.matching[2]);
        PrimitiveLongSet found = Primitive.longSet();
        try (Transaction tx = this.db.beginTx();){
            for (long id : toDelete) {
                this.db.getNodeById(id).delete();
                expected.remove(id);
            }
            this.collectNodes(found, (ResourceIterator<Node>)this.db.findNodes(this.LABEL, this.KEY, this.template, this.searchMode));
        }
        Assert.assertThat((Object)found, (Matcher)IsEqual.equalTo((Object)expected));
    }

    @Test
    public void shouldConsiderNodesChangedInSameTxInIndexSeek() {
        this.createNodes(this.db, this.LABEL, this.nonMatching[0]);
        PrimitiveLongSet toChangeToMatch = this.createNodes(this.db, this.LABEL, this.nonMatching[1]);
        PrimitiveLongSet toChangeToNotMatch = this.createNodes(this.db, this.LABEL, this.matching[0]);
        PrimitiveLongSet expected = this.createNodes(this.db, this.LABEL, this.matching[1]);
        PrimitiveLongSet found = Primitive.longSet();
        try (Transaction tx = this.db.beginTx();){
            for (long id : toChangeToMatch) {
                this.db.getNodeById(id).setProperty(this.KEY, (Object)this.matching[2]);
                expected.add(id);
            }
            for (long id : toChangeToNotMatch) {
                this.db.getNodeById(id).setProperty(this.KEY, (Object)this.nonMatching[2]);
                expected.remove(id);
            }
            this.collectNodes(found, (ResourceIterator<Node>)this.db.findNodes(this.LABEL, this.KEY, this.template, this.searchMode));
        }
        Assert.assertThat((Object)found, (Matcher)IsEqual.equalTo((Object)expected));
    }

    private PrimitiveLongSet createNodes(GraphDatabaseService db, Label label, String ... propertyValues) {
        PrimitiveLongSet expected = Primitive.longSet();
        try (Transaction tx = db.beginTx();){
            for (String value : propertyValues) {
                expected.add(this.createNode(db, MapUtil.map((Object[])new Object[]{this.KEY, value}), label).getId());
            }
            tx.success();
        }
        return expected;
    }

    private void collectNodes(PrimitiveLongSet bucket, ResourceIterator<Node> toCollect) {
        while (toCollect.hasNext()) {
            bucket.add(((Node)toCollect.next()).getId());
        }
    }

    private Node createNode(GraphDatabaseService beansAPI, Map<String, Object> properties, Label ... labels) {
        try (Transaction tx = beansAPI.beginTx();){
            Node node = beansAPI.createNode(labels);
            for (Map.Entry<String, Object> property : properties.entrySet()) {
                node.setProperty(property.getKey(), property.getValue());
            }
            tx.success();
            Node node2 = node;
            return node2;
        }
    }

    public static class CONTAINS_WITHOUT_INDEX
    extends CONTAINS {
        public CONTAINS_WITHOUT_INDEX() {
            super(false);
        }
    }

    public static class CONTAINS_WITH_INDEX
    extends CONTAINS {
        public CONTAINS_WITH_INDEX() {
            super(true);
        }
    }

    public static abstract class CONTAINS
    extends IndexingStringQueryAcceptanceTestBase {
        static String[] matching = new String[]{"good", "fool", "fooooood"};
        static String[] nonMatching = new String[]{"evil", "genius", "hungry"};

        public CONTAINS(boolean withIndex) {
            super("oo", matching, nonMatching, StringSearchMode.CONTAINS, withIndex);
        }
    }

    public static class SUFFIX_WITHOUT_INDEX
    extends SUFFIX {
        public SUFFIX_WITHOUT_INDEX() {
            super(false);
        }
    }

    public static class SUFFIX_WITH_INDEX
    extends SUFFIX {
        public SUFFIX_WITH_INDEX() {
            super(true);
        }
    }

    public static abstract class SUFFIX
    extends IndexingStringQueryAcceptanceTestBase {
        static String[] matching = new String[]{"Jansson", "Hansson", "Svensson"};
        static String[] nonMatching = new String[]{"Taverner", "Svensson-Averbuch", "Taylor"};

        SUFFIX(boolean withIndex) {
            super("sson", matching, nonMatching, StringSearchMode.SUFFIX, withIndex);
        }
    }

    public static class PREFIX_WITHOUT_INDEX
    extends PREFIX {
        public PREFIX_WITHOUT_INDEX() {
            super(false);
        }
    }

    public static class PREFIX_WITH_INDEX
    extends PREFIX {
        public PREFIX_WITH_INDEX() {
            super(true);
        }
    }

    public static abstract class PREFIX
    extends IndexingStringQueryAcceptanceTestBase {
        static String[] matching = new String[]{"Olivia", "Olivia2", "OliviaYtterbrink"};
        static String[] nonMatching = new String[]{"Johan", "olivia", "InteOlivia"};

        PREFIX(boolean withIndex) {
            super("Olivia", matching, nonMatching, StringSearchMode.PREFIX, withIndex);
        }
    }

    public static class EXACT_WITHOUT_INDEX
    extends EXACT {
        public EXACT_WITHOUT_INDEX() {
            super(false);
        }
    }

    public static class EXACT_WITH_INDEX
    extends EXACT {
        public EXACT_WITH_INDEX() {
            super(true);
        }
    }

    public static abstract class EXACT
    extends IndexingStringQueryAcceptanceTestBase {
        static String[] matching = new String[]{"Johan", "Johan", "Johan"};
        static String[] nonMatching = new String[]{"Johanna", "Olivia", "InteJohan"};

        EXACT(boolean withIndex) {
            super("Johan", matching, nonMatching, StringSearchMode.EXACT, withIndex);
        }
    }
}

