/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.impl.notification;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.TreeSet;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.impl.notification.NotificationDetail;

public class NotificationDetailTest {
    @Test
    public void shouldConstructIndexDetails() {
        NotificationDetail detail = NotificationDetail.Factory.index((String)"Person", (String[])new String[]{"name"});
        Assert.assertThat((Object)detail.name(), (Matcher)CoreMatchers.equalTo((Object)"hinted index"));
        Assert.assertThat((Object)detail.value(), (Matcher)CoreMatchers.equalTo((Object)"index on :Person(name)"));
        Assert.assertThat((Object)detail.toString(), (Matcher)CoreMatchers.equalTo((Object)"hinted index is: index on :Person(name)"));
    }

    @Test
    public void shouldConstructCartesianProductDetailsSingular() {
        HashSet<String> idents = new HashSet<String>();
        idents.add("n");
        NotificationDetail detail = NotificationDetail.Factory.cartesianProduct(idents);
        Assert.assertThat((Object)detail.name(), (Matcher)CoreMatchers.equalTo((Object)"identifier"));
        Assert.assertThat((Object)detail.value(), (Matcher)CoreMatchers.equalTo((Object)"(n)"));
        Assert.assertThat((Object)detail.toString(), (Matcher)CoreMatchers.equalTo((Object)"identifier is: (n)"));
    }

    @Test
    public void shouldConstructCartesianProductDetails() {
        TreeSet<String> idents = new TreeSet<String>();
        idents.add("n");
        idents.add("node2");
        NotificationDetail detail = NotificationDetail.Factory.cartesianProduct(idents);
        Assert.assertThat((Object)detail.name(), (Matcher)CoreMatchers.equalTo((Object)"identifiers"));
        Assert.assertThat((Object)detail.value(), (Matcher)CoreMatchers.equalTo((Object)"(n, node2)"));
        Assert.assertThat((Object)detail.toString(), (Matcher)CoreMatchers.equalTo((Object)"identifiers are: (n, node2)"));
    }

    @Test
    public void shouldConstructJoinHintDetailsSingular() {
        ArrayList<String> idents = new ArrayList<String>();
        idents.add("n");
        NotificationDetail detail = NotificationDetail.Factory.joinKey(idents);
        Assert.assertThat((Object)detail.name(), (Matcher)CoreMatchers.equalTo((Object)"hinted join key identifier"));
        Assert.assertThat((Object)detail.value(), (Matcher)CoreMatchers.equalTo((Object)"n"));
        Assert.assertThat((Object)detail.toString(), (Matcher)CoreMatchers.equalTo((Object)"hinted join key identifier is: n"));
    }

    @Test
    public void shouldConstructJoinHintDetails() {
        ArrayList<String> idents = new ArrayList<String>();
        idents.add("n");
        idents.add("node2");
        NotificationDetail detail = NotificationDetail.Factory.joinKey(idents);
        Assert.assertThat((Object)detail.name(), (Matcher)CoreMatchers.equalTo((Object)"hinted join key identifiers"));
        Assert.assertThat((Object)detail.value(), (Matcher)CoreMatchers.equalTo((Object)"n, node2"));
        Assert.assertThat((Object)detail.toString(), (Matcher)CoreMatchers.equalTo((Object)"hinted join key identifiers are: n, node2"));
    }
}

