/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.schema;

import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.ConstraintRule;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.storageengine.api.schema.SchemaRule;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.EmbeddedDatabaseRule;

public class DropBrokenUniquenessConstraintIT {
    private final Label label = Label.label((String)"Label");
    private final String key = "key";
    @Rule
    public final DatabaseRule db = new EmbeddedDatabaseRule();

    @Test
    public void shouldDropUniquenessConstraintWithBackingIndexNotInUse() {
        try (Transaction tx = this.db.beginTx();){
            this.db.schema().constraintFor(this.label).assertPropertyIsUnique("key").create();
            tx.success();
        }
        RecordStorageEngine storageEngine = (RecordStorageEngine)this.db.getDependencyResolver().resolveDependency(RecordStorageEngine.class);
        SchemaStore schemaStore = storageEngine.testAccessNeoStores().getSchemaStore();
        SchemaRule indexRule = (SchemaRule)Iterators.single((Iterator)Iterators.filter(rule -> rule instanceof IndexRule, (Iterator)schemaStore.loadAllSchemaRules()));
        this.setSchemaRecordNotInUse(schemaStore, indexRule.getId());
        storageEngine.loadSchemaCache();
        try (Transaction tx = this.db.beginTx();){
            ((ConstraintDefinition)Iterators.single(this.db.schema().getConstraints(this.label).iterator())).drop();
            tx.success();
        }
        var5_9 = null;
        try (Transaction ignore = this.db.beginTx();){
            Assert.assertFalse((boolean)this.db.schema().getConstraints().iterator().hasNext());
            Assert.assertFalse((boolean)this.db.schema().getIndexes().iterator().hasNext());
        }
        catch (Throwable throwable) {
            var5_9 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldDropUniquenessConstraintWithBackingIndexHavingNoOwner() throws Exception {
        try (Transaction tx = this.db.beginTx();){
            this.db.schema().constraintFor(this.label).assertPropertyIsUnique("key").create();
            tx.success();
        }
        RecordStorageEngine storageEngine = (RecordStorageEngine)this.db.getDependencyResolver().resolveDependency(RecordStorageEngine.class);
        SchemaStore schemaStore = storageEngine.testAccessNeoStores().getSchemaStore();
        SchemaRule indexRule = (SchemaRule)Iterators.single((Iterator)Iterators.filter(rule -> rule instanceof IndexRule, (Iterator)schemaStore.loadAllSchemaRules()));
        this.setOwnerNull(schemaStore, (IndexRule)indexRule);
        storageEngine.loadSchemaCache();
        try (Transaction tx = this.db.beginTx();){
            ((ConstraintDefinition)Iterators.single(this.db.schema().getConstraints(this.label).iterator())).drop();
            tx.success();
        }
        var5_9 = null;
        try (Transaction ignore = this.db.beginTx();){
            Assert.assertFalse((boolean)this.db.schema().getConstraints().iterator().hasNext());
            Assert.assertFalse((boolean)this.db.schema().getIndexes().iterator().hasNext());
        }
        catch (Throwable throwable) {
            var5_9 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldDropUniquenessConstraintWhereConstraintRecordIsMissing() throws Exception {
        try (Transaction tx = this.db.beginTx();){
            this.db.schema().constraintFor(this.label).assertPropertyIsUnique("key").create();
            tx.success();
        }
        RecordStorageEngine storageEngine = (RecordStorageEngine)this.db.getDependencyResolver().resolveDependency(RecordStorageEngine.class);
        SchemaStore schemaStore = storageEngine.testAccessNeoStores().getSchemaStore();
        SchemaRule indexRule = (SchemaRule)Iterators.single((Iterator)Iterators.filter(rule -> rule instanceof ConstraintRule, (Iterator)schemaStore.loadAllSchemaRules()));
        this.setSchemaRecordNotInUse(schemaStore, indexRule.getId());
        storageEngine.loadSchemaCache();
        try (Transaction tx = this.db.beginTx();){
            this.db.schema().getConstraints(this.label).forEach(ConstraintDefinition::drop);
            this.db.schema().getIndexes(this.label).forEach(IndexDefinition::drop);
            tx.success();
        }
        var5_9 = null;
        try (Transaction ignore = this.db.beginTx();){
            Assert.assertFalse((boolean)this.db.schema().getConstraints().iterator().hasNext());
            Assert.assertFalse((boolean)this.db.schema().getIndexes().iterator().hasNext());
        }
        catch (Throwable throwable) {
            var5_9 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldDropUniquenessConstraintWhereConstraintRecordIsMissingAndIndexHasNoOwner() throws Exception {
        try (Transaction tx = this.db.beginTx();){
            this.db.schema().constraintFor(this.label).assertPropertyIsUnique("key").create();
            tx.success();
        }
        RecordStorageEngine storageEngine = (RecordStorageEngine)this.db.getDependencyResolver().resolveDependency(RecordStorageEngine.class);
        SchemaStore schemaStore = storageEngine.testAccessNeoStores().getSchemaStore();
        SchemaRule constraintRule = (SchemaRule)Iterators.single((Iterator)Iterators.filter(rule -> rule instanceof ConstraintRule, (Iterator)schemaStore.loadAllSchemaRules()));
        this.setSchemaRecordNotInUse(schemaStore, constraintRule.getId());
        SchemaRule indexRule = (SchemaRule)Iterators.single((Iterator)Iterators.filter(rule -> rule instanceof IndexRule, (Iterator)schemaStore.loadAllSchemaRules()));
        this.setOwnerNull(schemaStore, (IndexRule)indexRule);
        storageEngine.loadSchemaCache();
        try (Transaction tx = this.db.beginTx();){
            this.db.schema().getConstraints(this.label).forEach(ConstraintDefinition::drop);
            this.db.schema().getIndexes(this.label).forEach(IndexDefinition::drop);
            tx.success();
        }
        var6_10 = null;
        try (Transaction ignore = this.db.beginTx();){
            Assert.assertFalse((boolean)this.db.schema().getConstraints().iterator().hasNext());
            Assert.assertFalse((boolean)this.db.schema().getIndexes().iterator().hasNext());
        }
        catch (Throwable throwable) {
            var6_10 = throwable;
            throw throwable;
        }
    }

    private void setOwnerNull(SchemaStore schemaStore, IndexRule rule) {
        rule = IndexRule.constraintIndexRule((long)rule.getId(), (SchemaIndexDescriptor)rule.getIndexDescriptor(), (IndexProvider.Descriptor)rule.getProviderDescriptor(), null);
        List dynamicRecords = schemaStore.allocateFrom((SchemaRule)rule);
        for (DynamicRecord record : dynamicRecords) {
            schemaStore.updateRecord((AbstractBaseRecord)record);
        }
    }

    private void setSchemaRecordNotInUse(SchemaStore schemaStore, long id) {
        DynamicRecord record = (DynamicRecord)schemaStore.newRecord();
        record.setId(id);
        record.setInUse(false);
        schemaStore.updateRecord((AbstractBaseRecord)record);
    }
}

