/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.Listeners;
import org.neo4j.helpers.NamedThreadFactory;
import org.neo4j.helpers.collection.Iterables;

public class ListenersTest {
    @Test(expected=NullPointerException.class)
    public void copyConstructorWithNull() {
        new Listeners(null);
    }

    @Test
    public void copyConstructor() {
        Listeners<Listener> original = ListenersTest.newListeners(new Listener(), new Listener(), new Listener());
        Listeners copy = new Listeners(original);
        Assert.assertEquals((Object)Iterables.asList(original), (Object)Iterables.asList((Iterable)copy));
    }

    @Test(expected=NullPointerException.class)
    public void addNull() {
        new Listeners().add(null);
    }

    @Test
    public void add() {
        Object[] listenersArray = new Listener[]{new Listener(), new Listener(), new Listener()};
        Listeners<Listener> listeners = ListenersTest.newListeners(listenersArray);
        Assert.assertArrayEquals((Object[])listenersArray, (Object[])Iterables.asArray(Listener.class, listeners));
    }

    @Test(expected=NullPointerException.class)
    public void removeNull() {
        new Listeners().remove(null);
    }

    @Test
    public void remove() {
        Listener listener1 = new Listener();
        Listener listener2 = new Listener();
        Listener listener3 = new Listener();
        Listeners<Listener> listeners = ListenersTest.newListeners(listener1, listener2, listener3);
        Assert.assertEquals(Arrays.asList(listener1, listener2, listener3), (Object)Iterables.asList(listeners));
        listeners.remove((Object)listener1);
        Assert.assertEquals(Arrays.asList(listener2, listener3), (Object)Iterables.asList(listeners));
        listeners.remove((Object)listener3);
        Assert.assertEquals(Collections.singletonList(listener2), (Object)Iterables.asList(listeners));
    }

    @Test(expected=NullPointerException.class)
    public void notifyWithNullNotification() {
        new Listeners().notify(null);
    }

    @Test
    public void notifyWithNotification() {
        String message = "foo";
        Listener listener1 = new Listener();
        Listener listener2 = new Listener();
        Listeners<Listener> listeners = ListenersTest.newListeners(listener1, listener2);
        listeners.notify(listener -> listener.process(message));
        Assert.assertEquals((Object)message, (Object)listener1.message);
        Assert.assertEquals((Object)Thread.currentThread().getName(), (Object)listener1.threadName);
        Assert.assertEquals((Object)message, (Object)listener2.message);
        Assert.assertEquals((Object)Thread.currentThread().getName(), (Object)listener2.threadName);
    }

    @Test(expected=NullPointerException.class)
    public void notifyWithNullExecutorAndNullNotification() {
        new Listeners().notify(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void notifyWithNullExecutorAndNotification() {
        new Listeners().notify(null, listener -> listener.process("foo"));
    }

    @Test(expected=NullPointerException.class)
    public void notifyWithExecutorAndNullNotification() {
        new Listeners().notify((Executor)Executors.newSingleThreadExecutor(), null);
    }

    @Test
    public void notifyWithExecutorAndNotification() throws Exception {
        String message = "foo";
        String threadNamePrefix = "test-thread";
        Listener listener1 = new Listener();
        Listener listener2 = new Listener();
        Listeners<Listener> listeners = ListenersTest.newListeners(listener1, listener2);
        ExecutorService executor = Executors.newSingleThreadExecutor((ThreadFactory)NamedThreadFactory.named((String)threadNamePrefix));
        listeners.notify((Executor)executor, listener -> listener.process(message));
        executor.shutdown();
        executor.awaitTermination(1L, TimeUnit.MINUTES);
        Assert.assertEquals((Object)message, (Object)listener1.message);
        Assert.assertThat((Object)listener1.threadName, (Matcher)Matchers.startsWith((String)threadNamePrefix));
        Assert.assertEquals((Object)message, (Object)listener2.message);
        Assert.assertThat((Object)listener2.threadName, (Matcher)Matchers.startsWith((String)threadNamePrefix));
    }

    @Test
    public void listenersIterable() {
        Listener listener1 = new Listener();
        Listener listener2 = new Listener();
        Listener listener3 = new Listener();
        Listeners<Listener> listeners = ListenersTest.newListeners(listener1, listener2, listener3);
        Assert.assertEquals(Arrays.asList(listener1, listener2, listener3), (Object)Iterables.asList(listeners));
    }

    @SafeVarargs
    private static <T> Listeners<T> newListeners(T ... listeners) {
        Listeners result = new Listeners();
        for (T listener : listeners) {
            result.add(listener);
        }
        return result;
    }

    private static class Listener {
        volatile String message;
        volatile String threadName;

        private Listener() {
        }

        void process(String message) {
            this.message = message;
            this.threadName = Thread.currentThread().getName();
        }
    }
}

