/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.core.StartupStatisticsProvider;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.SimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.SimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.FlushableChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.PositionAwarePhysicalFlushableChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.entry.CheckPoint;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderWriter;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.util.monitoring.ProgressReporter;
import org.neo4j.kernel.impl.util.monitoring.SilentProgressReporter;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.kernel.recovery.CorruptedLogsTruncator;
import org.neo4j.kernel.recovery.DefaultRecoveryService;
import org.neo4j.kernel.recovery.LogTailScanner;
import org.neo4j.kernel.recovery.Recovery;
import org.neo4j.kernel.recovery.RecoveryApplier;
import org.neo4j.kernel.recovery.RecoveryMonitor;
import org.neo4j.kernel.recovery.RecoveryService;
import org.neo4j.kernel.recovery.RecoveryStartInformationProvider;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class RecoveryTest {
    @Rule
    public final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    @Rule
    public final TestDirectory directory = TestDirectory.testDirectory();
    private final LogVersionRepository logVersionRepository = new SimpleLogVersionRepository();
    private final TransactionIdStore transactionIdStore = new SimpleTransactionIdStore(5L, 0L, 0L, 0L, 0L);
    private final int logVersion = 0;
    private LogEntry lastCommittedTxStartEntry;
    private LogEntry lastCommittedTxCommitEntry;
    private LogEntry expectedStartEntry;
    private LogEntry expectedCommitEntry;
    private LogEntry expectedCheckPointEntry;
    private Monitors monitors = new Monitors();
    private final SimpleLogVersionRepository versionRepository = new SimpleLogVersionRepository();
    private LogFiles logFiles;
    private File storeDir;

    @Before
    public void setUp() throws Exception {
        this.storeDir = this.directory.directory();
        this.logFiles = LogFilesBuilder.builder((File)this.storeDir, (FileSystemAbstraction)this.fileSystemRule.get()).withLogVersionRepository(this.logVersionRepository).withTransactionIdStore(this.transactionIdStore).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldRecoverExistingData() throws Exception {
        File file = this.logFiles.getLogFileForVersion(0L);
        this.writeSomeData(file, (Visitor<Pair<LogEntryWriter, Consumer<LogPositionMarker>>, IOException>)((Visitor)pair -> {
            LogEntryWriter writer = (LogEntryWriter)pair.first();
            Consumer consumer = (Consumer)pair.other();
            LogPositionMarker marker = new LogPositionMarker();
            consumer.accept(marker);
            LogPosition lastCommittedTxPosition = marker.newPosition();
            writer.writeStartEntry(0, 1, 2L, 3L, new byte[0]);
            this.lastCommittedTxStartEntry = new LogEntryStart(0, 1, 2L, 3L, new byte[0], lastCommittedTxPosition);
            writer.writeCommitEntry(4L, 5L);
            this.lastCommittedTxCommitEntry = new LogEntryCommit(4L, 5L);
            writer.writeCheckPointEntry(lastCommittedTxPosition);
            this.expectedCheckPointEntry = new CheckPoint(lastCommittedTxPosition);
            consumer.accept(marker);
            writer.writeStartEntry(0, 1, 6L, 4L, new byte[0]);
            this.expectedStartEntry = new LogEntryStart(0, 1, 6L, 4L, new byte[0], marker.newPosition());
            writer.writeCommitEntry(5L, 7L);
            this.expectedCommitEntry = new LogEntryCommit(5L, 7L);
            return true;
        }));
        LifeSupport life = new LifeSupport();
        RecoveryMonitor monitor = (RecoveryMonitor)Mockito.mock(RecoveryMonitor.class);
        final AtomicBoolean recoveryRequired = new AtomicBoolean();
        try {
            StorageEngine storageEngine = (StorageEngine)Mockito.mock(StorageEngine.class);
            VersionAwareLogEntryReader reader = new VersionAwareLogEntryReader();
            LogTailScanner tailScanner = this.getTailScanner(this.logFiles, (LogEntryReader<ReadableClosablePositionAwareChannel>)reader);
            TransactionMetadataCache metadataCache = new TransactionMetadataCache(100);
            PhysicalLogicalTransactionStore txStore = new PhysicalLogicalTransactionStore(this.logFiles, metadataCache, (LogEntryReader)reader, this.monitors, false);
            CorruptedLogsTruncator logPruner = new CorruptedLogsTruncator(this.storeDir, this.logFiles, this.fileSystemRule.get());
            life.add((Lifecycle)new Recovery((RecoveryService)new DefaultRecoveryService(storageEngine, tailScanner, this.transactionIdStore, (LogicalTransactionStore)txStore, this.versionRepository, RecoveryStartInformationProvider.NO_MONITOR){
                private int nr;

                public void startRecovery() {
                    recoveryRequired.set(true);
                }

                public RecoveryApplier getRecoveryApplier(TransactionApplicationMode mode) throws Exception {
                    final RecoveryApplier actual = super.getRecoveryApplier(mode);
                    if (mode == TransactionApplicationMode.REVERSE_RECOVERY) {
                        return actual;
                    }
                    return new RecoveryApplier(){

                        public void close() throws Exception {
                            actual.close();
                        }

                        public boolean visit(CommittedTransactionRepresentation tx) throws Exception {
                            actual.visit((Object)tx);
                            switch (nr++) {
                                case 0: {
                                    Assert.assertEquals((Object)RecoveryTest.this.lastCommittedTxStartEntry, (Object)tx.getStartEntry());
                                    Assert.assertEquals((Object)RecoveryTest.this.lastCommittedTxCommitEntry, (Object)tx.getCommitEntry());
                                    break;
                                }
                                case 1: {
                                    Assert.assertEquals((Object)RecoveryTest.this.expectedStartEntry, (Object)tx.getStartEntry());
                                    Assert.assertEquals((Object)RecoveryTest.this.expectedCommitEntry, (Object)tx.getCommitEntry());
                                    break;
                                }
                                default: {
                                    Assert.fail((String)"Too many recovered transactions");
                                }
                            }
                            return false;
                        }
                    };
                }
            }, new StartupStatisticsProvider(), logPruner, monitor, (ProgressReporter)SilentProgressReporter.INSTANCE, false));
            life.start();
            InOrder order = Mockito.inOrder((Object[])new Object[]{monitor});
            ((RecoveryMonitor)order.verify((Object)monitor, Mockito.times((int)1))).recoveryRequired((LogPosition)ArgumentMatchers.any(LogPosition.class));
            ((RecoveryMonitor)order.verify((Object)monitor, Mockito.times((int)1))).recoveryCompleted(2);
            Assert.assertTrue((boolean)recoveryRequired.get());
        }
        finally {
            life.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldSeeThatACleanDatabaseShouldNotRequireRecovery() throws Exception {
        File file = this.logFiles.getLogFileForVersion(0L);
        this.writeSomeData(file, (Visitor<Pair<LogEntryWriter, Consumer<LogPositionMarker>>, IOException>)((Visitor)pair -> {
            LogEntryWriter writer = (LogEntryWriter)pair.first();
            Consumer consumer = (Consumer)pair.other();
            LogPositionMarker marker = new LogPositionMarker();
            consumer.accept(marker);
            writer.writeStartEntry(0, 1, 2L, 3L, new byte[0]);
            writer.writeCommitEntry(4L, 5L);
            consumer.accept(marker);
            writer.writeCheckPointEntry(marker.newPosition());
            return true;
        }));
        LifeSupport life = new LifeSupport();
        RecoveryMonitor monitor = (RecoveryMonitor)Mockito.mock(RecoveryMonitor.class);
        try {
            StorageEngine storageEngine = (StorageEngine)Mockito.mock(StorageEngine.class);
            VersionAwareLogEntryReader reader = new VersionAwareLogEntryReader();
            LogTailScanner tailScanner = this.getTailScanner(this.logFiles, (LogEntryReader<ReadableClosablePositionAwareChannel>)reader);
            TransactionMetadataCache metadataCache = new TransactionMetadataCache(100);
            PhysicalLogicalTransactionStore txStore = new PhysicalLogicalTransactionStore(this.logFiles, metadataCache, (LogEntryReader)reader, this.monitors, false);
            CorruptedLogsTruncator logPruner = new CorruptedLogsTruncator(this.storeDir, this.logFiles, this.fileSystemRule.get());
            life.add((Lifecycle)new Recovery((RecoveryService)new DefaultRecoveryService(storageEngine, tailScanner, this.transactionIdStore, (LogicalTransactionStore)txStore, this.versionRepository, RecoveryStartInformationProvider.NO_MONITOR){

                public void startRecovery() {
                    Assert.fail((String)"Recovery should not be required");
                }
            }, new StartupStatisticsProvider(), logPruner, monitor, (ProgressReporter)SilentProgressReporter.INSTANCE, false));
            life.start();
            Mockito.verifyZeroInteractions((Object[])new Object[]{monitor});
        }
        finally {
            life.shutdown();
        }
    }

    @Test
    public void shouldTruncateLogAfterSinglePartialTransaction() throws Exception {
        File file = this.logFiles.getLogFileForVersion(0L);
        LogPositionMarker marker = new LogPositionMarker();
        this.writeSomeData(file, (Visitor<Pair<LogEntryWriter, Consumer<LogPositionMarker>>, IOException>)((Visitor)pair -> {
            LogEntryWriter writer = (LogEntryWriter)pair.first();
            Consumer consumer = (Consumer)pair.other();
            consumer.accept(marker);
            writer.writeStartEntry(0, 1, 5L, 4L, new byte[0]);
            return true;
        }));
        boolean recoveryRequired = this.recover(this.storeDir, this.logFiles);
        Assert.assertTrue((boolean)recoveryRequired);
        Assert.assertEquals((long)marker.getByteOffset(), (long)file.length());
    }

    @Test
    public void doNotTruncateCheckpointsAfterLastTransaction() throws IOException {
        File file = this.logFiles.getLogFileForVersion(0L);
        LogPositionMarker marker = new LogPositionMarker();
        this.writeSomeData(file, (Visitor<Pair<LogEntryWriter, Consumer<LogPositionMarker>>, IOException>)((Visitor)pair -> {
            LogEntryWriter writer = (LogEntryWriter)pair.first();
            writer.writeStartEntry(1, 1, 1L, 1L, ArrayUtils.EMPTY_BYTE_ARRAY);
            writer.writeCommitEntry(1L, 2L);
            writer.writeCheckPointEntry(new LogPosition(0L, 16L));
            writer.writeCheckPointEntry(new LogPosition(0L, 16L));
            writer.writeCheckPointEntry(new LogPosition(0L, 16L));
            writer.writeCheckPointEntry(new LogPosition(0L, 16L));
            Consumer other = (Consumer)pair.other();
            other.accept(marker);
            return true;
        }));
        Assert.assertTrue((boolean)this.recover(this.storeDir, this.logFiles));
        Assert.assertEquals((long)marker.getByteOffset(), (long)file.length());
    }

    @Test
    public void shouldTruncateLogAfterLastCompleteTransactionAfterSuccessfullRecovery() throws Exception {
        File file = this.logFiles.getLogFileForVersion(0L);
        LogPositionMarker marker = new LogPositionMarker();
        this.writeSomeData(file, (Visitor<Pair<LogEntryWriter, Consumer<LogPositionMarker>>, IOException>)((Visitor)pair -> {
            LogEntryWriter writer = (LogEntryWriter)pair.first();
            Consumer consumer = (Consumer)pair.other();
            writer.writeStartEntry(0, 1, 2L, 3L, new byte[0]);
            writer.writeCommitEntry(4L, 5L);
            consumer.accept(marker);
            writer.writeStartEntry(0, 1, 5L, 4L, new byte[0]);
            return true;
        }));
        boolean recoveryRequired = this.recover(this.storeDir, this.logFiles);
        Assert.assertTrue((boolean)recoveryRequired);
        Assert.assertEquals((long)marker.getByteOffset(), (long)file.length());
    }

    @Test
    public void shouldTellTransactionIdStoreAfterSuccessfullRecovery() throws Exception {
        File file = this.logFiles.getLogFileForVersion(0L);
        LogPositionMarker marker = new LogPositionMarker();
        byte[] additionalHeaderData = new byte[]{};
        boolean masterId = false;
        boolean authorId = true;
        long transactionId = 4L;
        long commitTimestamp = 5L;
        this.writeSomeData(file, (Visitor<Pair<LogEntryWriter, Consumer<LogPositionMarker>>, IOException>)((Visitor)pair -> {
            LogEntryWriter writer = (LogEntryWriter)pair.first();
            Consumer consumer = (Consumer)pair.other();
            writer.writeStartEntry(0, 1, 2L, 3L, additionalHeaderData);
            writer.writeCommitEntry(4L, 5L);
            consumer.accept(marker);
            return true;
        }));
        boolean recoveryRequired = this.recover(this.storeDir, this.logFiles);
        Assert.assertTrue((boolean)recoveryRequired);
        long[] lastClosedTransaction = this.transactionIdStore.getLastClosedTransaction();
        Assert.assertEquals((long)4L, (long)lastClosedTransaction[0]);
        Assert.assertEquals((long)LogEntryStart.checksum((byte[])additionalHeaderData, (int)0, (int)1), (long)this.transactionIdStore.getLastCommittedTransaction().checksum());
        Assert.assertEquals((long)5L, (long)this.transactionIdStore.getLastCommittedTransaction().commitTimestamp());
        Assert.assertEquals((long)0L, (long)lastClosedTransaction[1]);
        Assert.assertEquals((long)marker.getByteOffset(), (long)lastClosedTransaction[2]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean recover(File storeDir, LogFiles logFiles) {
        LifeSupport life = new LifeSupport();
        RecoveryMonitor monitor = (RecoveryMonitor)Mockito.mock(RecoveryMonitor.class);
        final AtomicBoolean recoveryRequired = new AtomicBoolean();
        try {
            StorageEngine storageEngine = (StorageEngine)Mockito.mock(StorageEngine.class);
            VersionAwareLogEntryReader reader = new VersionAwareLogEntryReader();
            LogTailScanner tailScanner = this.getTailScanner(logFiles, (LogEntryReader<ReadableClosablePositionAwareChannel>)reader);
            TransactionMetadataCache metadataCache = new TransactionMetadataCache(100);
            PhysicalLogicalTransactionStore txStore = new PhysicalLogicalTransactionStore(logFiles, metadataCache, (LogEntryReader)reader, this.monitors, false);
            CorruptedLogsTruncator logPruner = new CorruptedLogsTruncator(storeDir, logFiles, this.fileSystemRule.get());
            life.add((Lifecycle)new Recovery((RecoveryService)new DefaultRecoveryService(storageEngine, tailScanner, this.transactionIdStore, (LogicalTransactionStore)txStore, this.versionRepository, RecoveryStartInformationProvider.NO_MONITOR){

                public void startRecovery() {
                    recoveryRequired.set(true);
                }
            }, new StartupStatisticsProvider(), logPruner, monitor, (ProgressReporter)SilentProgressReporter.INSTANCE, false));
            life.start();
        }
        finally {
            life.shutdown();
        }
        return recoveryRequired.get();
    }

    private LogTailScanner getTailScanner(LogFiles logFiles, LogEntryReader<ReadableClosablePositionAwareChannel> reader) {
        return new LogTailScanner(logFiles, reader, this.monitors, false);
    }

    private void writeSomeData(File file, Visitor<Pair<LogEntryWriter, Consumer<LogPositionMarker>>, IOException> visitor) throws IOException {
        try (PhysicalLogVersionedStoreChannel versionedStoreChannel = new PhysicalLogVersionedStoreChannel((StoreChannel)((DefaultFileSystemAbstraction)this.fileSystemRule.get()).open(file, OpenMode.READ_WRITE), 0L, 6);
             PositionAwarePhysicalFlushableChannel writableLogChannel = new PositionAwarePhysicalFlushableChannel((LogVersionedStoreChannel)versionedStoreChannel);){
            LogHeaderWriter.writeLogHeader((FlushableChannel)writableLogChannel, (long)0L, (long)2L);
            Consumer<LogPositionMarker> consumer = marker -> {
                try {
                    writableLogChannel.getCurrentPosition(marker);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            };
            LogEntryWriter first = new LogEntryWriter((FlushableChannel)writableLogChannel);
            visitor.visit((Object)Pair.of((Object)first, consumer));
        }
    }
}

