/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.Locks;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.coreapi.PlaceboTransaction;

public class TestPlaceboTransaction {
    private Transaction placeboTx;
    private Node resource;
    private KernelTransaction kernelTransaction;
    private Locks locks;

    @Before
    public void before() {
        ThreadToStatementContextBridge bridge = (ThreadToStatementContextBridge)Mockito.mock(ThreadToStatementContextBridge.class);
        Statement statement = (Statement)Mockito.mock(Statement.class);
        Mockito.when((Object)bridge.get()).thenReturn((Object)statement);
        this.kernelTransaction = (KernelTransaction)Mockito.spy(KernelTransaction.class);
        this.locks = (Locks)Mockito.mock(Locks.class);
        Mockito.when((Object)this.kernelTransaction.locks()).thenReturn((Object)this.locks);
        this.placeboTx = new PlaceboTransaction(this.kernelTransaction);
        this.resource = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)this.resource.getId()).thenReturn((Object)1L);
    }

    @Test
    public void shouldRollbackParentByDefault() {
        this.placeboTx.close();
        ((KernelTransaction)Mockito.verify((Object)this.kernelTransaction)).failure();
    }

    @Test
    public void shouldRollbackParentIfFailureCalled() {
        this.placeboTx.failure();
        this.placeboTx.close();
        ((KernelTransaction)Mockito.verify((Object)this.kernelTransaction, (VerificationMode)Mockito.times((int)2))).failure();
    }

    @Test
    public void shouldNotRollbackParentIfSuccessCalled() {
        this.placeboTx.success();
        this.placeboTx.close();
        ((KernelTransaction)Mockito.verify((Object)this.kernelTransaction, (VerificationMode)Mockito.never())).failure();
    }

    @Test
    public void successCannotOverrideFailure() {
        this.placeboTx.failure();
        this.placeboTx.success();
        this.placeboTx.close();
        ((KernelTransaction)Mockito.verify((Object)this.kernelTransaction)).failure();
        ((KernelTransaction)Mockito.verify((Object)this.kernelTransaction, (VerificationMode)Mockito.never())).success();
    }

    @Test
    public void canAcquireReadLock() {
        this.placeboTx.acquireReadLock((PropertyContainer)this.resource);
        ((Locks)Mockito.verify((Object)this.locks)).acquireSharedNodeLock(new long[]{this.resource.getId()});
    }

    @Test
    public void canAcquireWriteLock() {
        this.placeboTx.acquireWriteLock((PropertyContainer)this.resource);
        ((Locks)Mockito.verify((Object)this.locks)).acquireExclusiveNodeLock(new long[]{this.resource.getId()});
    }

    @Test
    public void shouldReturnTerminationReason() {
        KernelTransaction kernelTransaction = (KernelTransaction)Mockito.mock(KernelTransaction.class);
        Mockito.when((Object)kernelTransaction.getReasonIfTerminated()).thenReturn(Optional.empty()).thenReturn(Optional.of(Status.Transaction.Interrupted));
        PlaceboTransaction tx = new PlaceboTransaction(kernelTransaction);
        Optional terminationReason1 = tx.terminationReason();
        Optional terminationReason2 = tx.terminationReason();
        Assert.assertFalse((boolean)terminationReason1.isPresent());
        Assert.assertTrue((boolean)terminationReason2.isPresent());
        Assert.assertEquals((Object)Status.Transaction.Interrupted, terminationReason2.get());
    }
}

