/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.query;

import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorCounters;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.api.query.SimpleState;
import org.neo4j.kernel.api.query.WaitingOnLock;
import org.neo4j.kernel.api.query.WaitingOnQuery;
import org.neo4j.resources.HeapAllocation;
import org.neo4j.storageengine.api.lock.ResourceType;
import org.neo4j.storageengine.api.lock.WaitStrategy;
import org.neo4j.test.FakeCpuClock;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;
import org.neo4j.time.SystemNanoClock;

public class ExecutingQueryStatusTest {
    private final FakeClock clock = Clocks.fakeClock((TemporalAccessor)ZonedDateTime.parse("2016-12-16T16:14:12+01:00"));

    @Test
    public void shouldProduceSensibleMapRepresentationInRunningState() {
        String status = SimpleState.running().name();
        Assert.assertEquals((Object)"running", (Object)status);
    }

    @Test
    public void shouldProduceSensibleMapRepresentationInPlanningState() {
        String status = SimpleState.planning().name();
        Assert.assertEquals((Object)"planning", (Object)status);
    }

    @Test
    public void shouldProduceSensibleMapRepresentationInWaitingOnLockState() {
        long[] resourceIds = new long[]{17L};
        WaitingOnLock status = new WaitingOnLock("EXCLUSIVE", ExecutingQueryStatusTest.resourceType("NODE"), resourceIds, this.clock.nanos());
        this.clock.forward(17L, TimeUnit.MILLISECONDS);
        Map statusMap = status.toMap(this.clock.nanos());
        Assert.assertEquals((Object)"waiting", (Object)status.name());
        HashMap<String, Object> expected = new HashMap<String, Object>();
        expected.put("waitTimeMillis", 17L);
        expected.put("lockMode", "EXCLUSIVE");
        expected.put("resourceType", "NODE");
        expected.put("resourceIds", resourceIds);
        Assert.assertEquals(expected, (Object)statusMap);
    }

    @Test
    public void shouldProduceSensibleMapRepresentationInWaitingOnQueryState() {
        WaitingOnQuery status = new WaitingOnQuery(new ExecutingQuery(12L, null, null, null, null, null, () -> 0L, (PageCursorCounters)PageCursorTracer.NULL, Thread.currentThread().getId(), Thread.currentThread().getName(), (SystemNanoClock)this.clock, FakeCpuClock.NOT_AVAILABLE, HeapAllocation.NOT_AVAILABLE), this.clock.nanos());
        this.clock.forward(1025L, TimeUnit.MILLISECONDS);
        Map statusMap = status.toMap(this.clock.nanos());
        Assert.assertEquals((Object)"waiting", (Object)status.name());
        HashMap<String, Object> expected = new HashMap<String, Object>();
        expected.put("waitTimeMillis", 1025L);
        expected.put("queryId", "query-12");
        Assert.assertEquals(expected, (Object)statusMap);
    }

    static ResourceType resourceType(final String name) {
        return new ResourceType(){

            public String toString() {
                return this.name();
            }

            public int typeId() {
                throw new UnsupportedOperationException("not used");
            }

            public WaitStrategy waitStrategy() {
                throw new UnsupportedOperationException("not used");
            }

            public String name() {
                return name;
            }
        };
    }
}

