/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.configuration.LoadableConfig;
import org.neo4j.kernel.configuration.AnnotationBasedConfigurationMigrator;
import org.neo4j.kernel.configuration.ConfigurationMigrator;
import org.neo4j.kernel.configuration.Migrator;
import org.neo4j.logging.Log;

public class AnnotationBasedConfigurationMigratorTest {
    private static final AtomicBoolean wasCalled = new AtomicBoolean(false);

    @Test
    public void migratorShouldGetPickedUp() {
        AnnotationBasedConfigurationMigrator migrator = new AnnotationBasedConfigurationMigrator(Collections.singleton(new SomeSettings()));
        migrator.apply(new HashMap(), (Log)Mockito.mock(Log.class));
        Assert.assertThat((Object)wasCalled.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    static class SomeSettings
    implements LoadableConfig {
        @Migrator
        private static ConfigurationMigrator migrator = (rawConfiguration, log) -> {
            wasCalled.set(true);
            return rawConfiguration;
        };

        SomeSettings() {
        }
    }
}

