/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.Kernel;
import org.neo4j.internal.kernel.api.Session;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.impl.api.index.SchemaIndexTestHelper;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.rule.ImpermanentDatabaseRule;

public class KernelSchemaStateFlushingTest {
    @Rule
    public ImpermanentDatabaseRule dbRule = new ImpermanentDatabaseRule();
    private GraphDatabaseAPI db;
    private Kernel kernel;
    private Session session;

    @Test
    public void shouldKeepSchemaStateIfSchemaIsNotModified() throws TransactionFailureException {
        String before = this.commitToSchemaState("test", "before");
        Assert.assertEquals((Object)"before", (Object)before);
        String after = this.commitToSchemaState("test", "after");
        Assert.assertEquals((Object)"before", (Object)after);
    }

    @Test
    public void shouldInvalidateSchemaStateOnCreateIndex() throws Exception {
        this.commitToSchemaState("test", "before");
        this.awaitIndexOnline(this.createIndex(), "test");
        String after = this.commitToSchemaState("test", "after");
        Assert.assertEquals((Object)"after", (Object)after);
    }

    @Test
    public void shouldInvalidateSchemaStateOnDropIndex() throws Exception {
        IndexReference ref = this.createIndex();
        this.awaitIndexOnline(ref, "test");
        this.commitToSchemaState("test", "before");
        this.dropIndex(ref);
        String after = this.commitToSchemaState("test", "after");
        Assert.assertEquals((Object)"after", (Object)after);
    }

    @Test
    public void shouldInvalidateSchemaStateOnCreateConstraint() throws Exception {
        this.commitToSchemaState("test", "before");
        this.createConstraint();
        String after = this.commitToSchemaState("test", "after");
        Assert.assertEquals((Object)"after", (Object)after);
    }

    @Test
    public void shouldInvalidateSchemaStateOnDropConstraint() throws Exception {
        ConstraintDescriptor descriptor = this.createConstraint();
        this.commitToSchemaState("test", "before");
        this.dropConstraint(descriptor);
        String after = this.commitToSchemaState("test", "after");
        Assert.assertEquals((Object)"after", (Object)after);
    }

    private ConstraintDescriptor createConstraint() throws KernelException {
        try (Transaction transaction = this.session.beginTransaction(Transaction.Type.implicit);){
            ConstraintDescriptor descriptor = transaction.schemaWrite().uniquePropertyConstraintCreate((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)1, (int[])new int[]{1}));
            transaction.success();
            ConstraintDescriptor constraintDescriptor = descriptor;
            return constraintDescriptor;
        }
    }

    private void dropConstraint(ConstraintDescriptor descriptor) throws KernelException {
        try (Transaction transaction = this.session.beginTransaction(Transaction.Type.implicit);){
            transaction.schemaWrite().constraintDrop(descriptor);
            transaction.success();
        }
    }

    private IndexReference createIndex() throws KernelException {
        try (Transaction transaction = this.session.beginTransaction(Transaction.Type.implicit);){
            IndexReference reference = transaction.schemaWrite().indexCreate((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)1, (int[])new int[]{1}));
            transaction.success();
            IndexReference indexReference = reference;
            return indexReference;
        }
    }

    private void dropIndex(IndexReference reference) throws KernelException {
        try (Transaction transaction = this.session.beginTransaction(Transaction.Type.implicit);){
            transaction.schemaWrite().indexDrop(reference);
            transaction.success();
        }
    }

    private void awaitIndexOnline(IndexReference descriptor, String keyForProbing) throws IndexNotFoundKernelException, TransactionFailureException {
        try (Transaction transaction = this.session.beginTransaction(Transaction.Type.implicit);){
            SchemaIndexTestHelper.awaitIndexOnline(transaction.schemaRead(), descriptor);
            transaction.success();
        }
        this.awaitSchemaStateCleared(keyForProbing);
    }

    private void awaitSchemaStateCleared(String keyForProbing) throws TransactionFailureException {
        try (Transaction transaction = this.session.beginTransaction(Transaction.Type.implicit);){
            while (transaction.schemaRead().schemaStateGetOrCreate((Object)keyForProbing, ignored -> null) != null) {
                LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
            }
            transaction.success();
        }
    }

    private String commitToSchemaState(String key, String value) throws TransactionFailureException {
        try (Transaction transaction = this.session.beginTransaction(Transaction.Type.implicit);){
            String result = this.getOrCreateFromState(transaction, key, value);
            transaction.success();
            String string = result;
            return string;
        }
    }

    private String getOrCreateFromState(Transaction tx, String key, String value) {
        return (String)tx.schemaRead().schemaStateGetOrCreate((Object)key, from -> value);
    }

    @Before
    public void setup() {
        this.db = this.dbRule.getGraphDatabaseAPI();
        this.kernel = (Kernel)this.db.getDependencyResolver().resolveDependency(Kernel.class);
        this.session = this.kernel.beginSession(LoginContext.AUTH_DISABLED);
    }

    @After
    public void after() {
        this.session.close();
        this.db.shutdown();
    }
}

