/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptorFactory;
import org.neo4j.kernel.impl.api.index.IndexMeta;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.OnlineIndexProxy;

public class OnlineIndexProxyTest {
    private final long indexId = 1L;
    private final SchemaIndexDescriptor descriptor = SchemaIndexDescriptorFactory.forLabel((int)1, (int[])new int[]{2});
    private final IndexProvider.Descriptor providerDescriptor = (IndexProvider.Descriptor)Mockito.mock(IndexProvider.Descriptor.class);
    private final IndexAccessor accessor = (IndexAccessor)Mockito.mock(IndexAccessor.class);
    private final IndexStoreView storeView = (IndexStoreView)Mockito.mock(IndexStoreView.class);

    @Test
    public void shouldRemoveIndexCountsWhenTheIndexItselfIsDropped() throws IOException {
        IndexMeta indexMeta = new IndexMeta(1L, this.descriptor, this.providerDescriptor, IndexCapability.NO_CAPABILITY);
        OnlineIndexProxy index = new OnlineIndexProxy(1L, indexMeta, this.accessor, this.storeView, false);
        index.drop();
        ((IndexAccessor)Mockito.verify((Object)this.accessor)).drop();
        ((IndexStoreView)Mockito.verify((Object)this.storeView)).replaceIndexCounts(1L, 0L, 0L, 0L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.accessor, this.storeView});
    }
}

