/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.File;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.NodeUpdates;
import org.neo4j.kernel.impl.api.index.PropertyPhysicalToLogicalConverter;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.transaction.state.PropertyRecordChange;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class PropertyPhysicalToLogicalConverterTest {
    private NeoStores neoStores;
    @ClassRule
    public static PageCacheRule pageCacheRule = new PageCacheRule();
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    private PropertyStore store;
    private final Value longString = Values.of((Object)"my super looooooooooooooooooooooooooooooooooooooong striiiiiiiiiiiiiiiiiiiiiiing");
    private final Value longerString = Values.of((Object)"my super looooooooooooooooooooooooooooooooooooooong striiiiiiiiiiiiiiiiiiiiiiingdd");
    private PropertyPhysicalToLogicalConverter converter;
    private final long[] none = new long[0];
    private final long[] labels = new long[]{11L};

    @Test
    public void shouldConvertInlinedAddedProperty() {
        int key = 10;
        Value value = Values.of((Object)12345);
        PropertyRecord before = this.propertyRecord(new PropertyBlock[0]);
        PropertyRecord after = this.propertyRecord(this.property(key, value));
        MatcherAssert.assertThat((Object)this.convert(this.none, this.none, this.change(before, after)), (Matcher)Matchers.equalTo((Object)NodeUpdates.forNode((long)0L).added(key, value).build()));
    }

    @Test
    public void shouldConvertInlinedChangedProperty() {
        int key = 10;
        Value valueBefore = Values.of((Object)12341);
        Value valueAfter = Values.of((Object)738);
        PropertyRecord before = this.propertyRecord(this.property(key, valueBefore));
        PropertyRecord after = this.propertyRecord(this.property(key, valueAfter));
        NodeUpdates update = this.convert(this.none, this.none, this.change(before, after));
        NodeUpdates expected = NodeUpdates.forNode((long)0L).changed(key, valueBefore, valueAfter).build();
        Assert.assertEquals((Object)expected, (Object)update);
    }

    @Test
    public void shouldIgnoreInlinedUnchangedProperty() {
        int key = 10;
        Value value = Values.of((Object)12341);
        PropertyRecord before = this.propertyRecord(this.property(key, value));
        PropertyRecord after = this.propertyRecord(this.property(key, value));
        MatcherAssert.assertThat((Object)this.convert(this.none, this.none, this.change(before, after)), (Matcher)Matchers.equalTo((Object)NodeUpdates.forNode((long)0L).build()));
    }

    @Test
    public void shouldConvertInlinedRemovedProperty() {
        int key = 10;
        Value value = Values.of((Object)12341);
        PropertyRecord before = this.propertyRecord(this.property(key, value));
        PropertyRecord after = this.propertyRecord(new PropertyBlock[0]);
        NodeUpdates update = this.convert(this.none, this.none, this.change(before, after));
        NodeUpdates expected = NodeUpdates.forNode((long)0L).removed(key, value).build();
        Assert.assertEquals((Object)expected, (Object)update);
    }

    @Test
    public void shouldConvertDynamicAddedProperty() {
        int key = 10;
        PropertyRecord before = this.propertyRecord(new PropertyBlock[0]);
        PropertyRecord after = this.propertyRecord(this.property(key, this.longString));
        MatcherAssert.assertThat((Object)this.convert(this.none, this.none, this.change(before, after)), (Matcher)Matchers.equalTo((Object)NodeUpdates.forNode((long)0L).added(key, this.longString).build()));
    }

    @Test
    public void shouldConvertDynamicChangedProperty() {
        int key = 10;
        PropertyRecord before = this.propertyRecord(this.property(key, this.longString));
        PropertyRecord after = this.propertyRecord(this.property(key, this.longerString));
        NodeUpdates update = this.convert(this.none, this.none, this.change(before, after));
        NodeUpdates expected = NodeUpdates.forNode((long)0L).changed(key, this.longString, this.longerString).build();
        Assert.assertEquals((Object)expected, (Object)update);
    }

    @Test
    public void shouldConvertDynamicInlinedRemovedProperty() {
        int key = 10;
        PropertyRecord before = this.propertyRecord(this.property(key, this.longString));
        PropertyRecord after = this.propertyRecord(new PropertyBlock[0]);
        NodeUpdates update = this.convert(this.none, this.none, this.change(before, after));
        NodeUpdates expected = NodeUpdates.forNode((long)0L).removed(key, this.longString).build();
        Assert.assertEquals((Object)expected, (Object)update);
    }

    @Test
    public void shouldTreatPropertyThatMovedToAnotherRecordAsChange() {
        int key = 12;
        Value oldValue = Values.of((Object)"value1");
        Value newValue = Values.of((Object)"value two");
        PropertyRecordChange movedFrom = this.change(this.propertyRecord(this.property(key, oldValue)), this.propertyRecord(new PropertyBlock[0]));
        PropertyRecordChange movedTo = this.change(this.propertyRecord(new PropertyBlock[0]), this.propertyRecord(this.property(key, newValue)));
        NodeUpdates update = this.convert(this.none, this.none, movedFrom, movedTo);
        NodeUpdates expected = NodeUpdates.forNode((long)0L).changed(key, oldValue, newValue).build();
        Assert.assertEquals((Object)expected, (Object)update);
    }

    private PropertyRecord propertyRecord(PropertyBlock ... propertyBlocks) {
        PropertyRecord record = new PropertyRecord(0L);
        if (propertyBlocks != null) {
            record.setInUse(true);
            for (PropertyBlock propertyBlock : propertyBlocks) {
                record.addPropertyBlock(propertyBlock);
            }
        }
        record.setNodeId(0L);
        return record;
    }

    private PropertyBlock property(long key, Value value) {
        PropertyBlock block = new PropertyBlock();
        this.store.encodeValue(block, (int)key, value);
        return block;
    }

    @Before
    public void before() {
        File storeDir = new File("dir");
        ((EphemeralFileSystemAbstraction)this.fs.get()).mkdirs(storeDir);
        StoreFactory storeFactory = new StoreFactory(storeDir, Config.defaults(), (IdGeneratorFactory)new DefaultIdGeneratorFactory(this.fs.get()), pageCacheRule.getPageCache(this.fs.get()), this.fs.get(), (LogProvider)NullLogProvider.getInstance(), EmptyVersionContextSupplier.EMPTY);
        this.neoStores = storeFactory.openAllNeoStores(true);
        this.store = this.neoStores.getPropertyStore();
        this.converter = new PropertyPhysicalToLogicalConverter(this.store);
    }

    @After
    public void after() {
        this.neoStores.close();
    }

    private NodeUpdates convert(long[] labelsBefore, long[] labelsAfter, PropertyRecordChange change) {
        return this.convert(labelsBefore, labelsAfter, new PropertyRecordChange[]{change});
    }

    private NodeUpdates convert(long[] labelsBefore, long[] labelsAfter, PropertyRecordChange ... changes) {
        NodeUpdates.Builder updates = NodeUpdates.forNode((long)0L, (long[])labelsBefore, (long[])labelsAfter);
        this.converter.convertPropertyRecord(0L, Iterables.iterable((Object[])changes), updates);
        return updates.build();
    }

    private PropertyRecordChange change(final PropertyRecord before, final PropertyRecord after) {
        return new PropertyRecordChange(){

            public PropertyRecord getBefore() {
                return before;
            }

            public PropertyRecord getAfter() {
                return after;
            }
        };
    }
}

