/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.inmemory;

import java.util.Map;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.api.index.inmemory.InMemoryIndex;
import org.neo4j.kernel.impl.api.index.inmemory.InMemoryIndexProviderFactory;
import org.neo4j.kernel.impl.api.index.inmemory.UniqueInMemoryIndex;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.kernel.impl.util.CopyOnWriteHashMap;

public class InMemoryIndexProvider
extends IndexProvider {
    private final Map<Long, InMemoryIndex> indexes;

    public InMemoryIndexProvider() {
        this(0);
    }

    public InMemoryIndexProvider(int prio) {
        this(prio, (Map<Long, InMemoryIndex>)new CopyOnWriteHashMap());
    }

    private InMemoryIndexProvider(int prio, Map<Long, InMemoryIndex> indexes) {
        super(InMemoryIndexProviderFactory.PROVIDER_DESCRIPTOR, prio, IndexDirectoryStructure.NONE);
        this.indexes = indexes;
    }

    public InternalIndexState getInitialState(long indexId, SchemaIndexDescriptor descriptor) {
        InMemoryIndex index = this.indexes.get(indexId);
        return index != null ? index.getState() : InternalIndexState.POPULATING;
    }

    public IndexCapability getCapability(SchemaIndexDescriptor schemaIndexDescriptor) {
        return IndexCapability.NO_CAPABILITY;
    }

    public StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction fs, PageCache pageCache) {
        return StoreMigrationParticipant.NOT_PARTICIPATING;
    }

    public IndexPopulator getPopulator(long indexId, SchemaIndexDescriptor descriptor, IndexSamplingConfig samplingConfig) {
        InMemoryIndex index = descriptor.type() == SchemaIndexDescriptor.Type.UNIQUE ? new UniqueInMemoryIndex(descriptor) : new InMemoryIndex(descriptor);
        this.indexes.put(indexId, index);
        return index.getPopulator();
    }

    public IndexAccessor getOnlineAccessor(long indexId, SchemaIndexDescriptor descriptor, IndexSamplingConfig samplingConfig) {
        InMemoryIndex index = this.indexes.get(indexId);
        if (index == null || index.getState() != InternalIndexState.ONLINE) {
            throw new IllegalStateException("Index " + indexId + " not online yet");
        }
        if (descriptor.type() == SchemaIndexDescriptor.Type.UNIQUE && !(index instanceof UniqueInMemoryIndex)) {
            throw new IllegalStateException(String.format("The index [%s] was not created as a unique index.", indexId));
        }
        return index.getOnlineAccessor();
    }

    public String getPopulationFailure(long indexId, SchemaIndexDescriptor descriptor) throws IllegalStateException {
        String failure = this.indexes.get((Object)Long.valueOf((long)indexId)).failure;
        if (failure == null) {
            throw new IllegalStateException();
        }
        return failure;
    }

    public InMemoryIndexProvider snapshot() {
        CopyOnWriteHashMap copy = new CopyOnWriteHashMap();
        for (Map.Entry<Long, InMemoryIndex> entry : this.indexes.entrySet()) {
            copy.put(entry.getKey(), entry.getValue().snapshot());
        }
        return new InMemoryIndexProvider(this.priority, (Map<Long, InMemoryIndex>)copy);
    }

    public boolean dataEquals(InMemoryIndexProvider other) {
        for (Map.Entry<Long, InMemoryIndex> entry : this.indexes.entrySet()) {
            InMemoryIndex otherIndex = other.indexes.get(entry.getKey());
            if (otherIndex != null && entry.getValue().hasSameContentsAs(otherIndex)) continue;
            return false;
        }
        return true;
    }
}

