/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class KernelIT
extends KernelIntegrationTest {
    @Test
    public void mixingBeansApiWithKernelAPI() throws Exception {
        org.neo4j.graphdb.Transaction transaction = this.db.beginTx();
        KernelTransaction ktx = this.statementContextSupplier.getKernelTransactionBoundToThisThread(true);
        Node node = this.db.createNode();
        int labelId = ktx.tokenWrite().labelGetOrCreateForName("labello");
        ktx.dataWrite().nodeAddLabel(node.getId(), labelId);
        transaction.success();
        transaction.close();
    }

    @Test
    public void schemaStateShouldBeEvictedOnIndexComingOnline() throws Exception {
        this.schemaWriteInNewTransaction();
        this.getOrCreateSchemaState("my key", "my state");
        this.commit();
        this.createIndex(this.newTransaction(LoginContext.AUTH_DISABLED));
        this.commit();
        try (org.neo4j.graphdb.Transaction tx = this.db.beginTx();){
            this.db.schema().awaitIndexesOnline(20L, TimeUnit.SECONDS);
            tx.success();
        }
        org.neo4j.test.assertion.Assert.assertEventually("Schema state should have been updated", () -> this.schemaStateContains("my key"), Matchers.is((Object)false), 1L, TimeUnit.SECONDS);
    }

    @Test
    public void schemaStateShouldBeEvictedOnIndexDropped() throws Exception {
        IndexReference idx = this.createIndex(this.newTransaction(LoginContext.AUTH_DISABLED));
        this.commit();
        try (org.neo4j.graphdb.Transaction tx = this.db.beginTx();){
            this.db.schema().awaitIndexesOnline(20L, TimeUnit.SECONDS);
            this.getOrCreateSchemaState("my key", "some state");
            tx.success();
        }
        this.schemaWriteInNewTransaction().indexDrop(idx);
        this.commit();
        Assert.assertFalse((boolean)this.schemaStateContains("my key"));
    }

    @Test
    public void txReturnsCorrectIdWhenCommitted() throws Exception {
        KernelIT.executeDummyTxs((GraphDatabaseService)this.db, 42);
        Transaction tx = this.newTransaction(LoginContext.AUTH_DISABLED);
        tx.dataWrite().nodeCreate();
        tx.success();
        long previousCommittedTxId = KernelIT.lastCommittedTxId(this.db);
        Assert.assertEquals((long)(previousCommittedTxId + 1L), (long)tx.closeTransaction());
        Assert.assertFalse((boolean)tx.isOpen());
    }

    @Test
    public void txReturnsCorrectIdWhenRolledBack() throws Exception {
        KernelIT.executeDummyTxs((GraphDatabaseService)this.db, 42);
        Transaction tx = this.newTransaction(LoginContext.AUTH_DISABLED);
        tx.dataWrite().nodeCreate();
        tx.failure();
        Assert.assertEquals((long)-1L, (long)tx.closeTransaction());
        Assert.assertFalse((boolean)tx.isOpen());
    }

    @Test
    public void txReturnsCorrectIdWhenMarkedForTermination() throws Exception {
        KernelIT.executeDummyTxs((GraphDatabaseService)this.db, 42);
        Transaction tx = this.newTransaction(LoginContext.AUTH_DISABLED);
        tx.dataWrite().nodeCreate();
        tx.markForTermination((Status)Status.Transaction.Terminated);
        Assert.assertEquals((long)-1L, (long)tx.closeTransaction());
        Assert.assertFalse((boolean)tx.isOpen());
    }

    @Test
    public void txReturnsCorrectIdWhenFailedlAndMarkedForTermination() throws Exception {
        KernelIT.executeDummyTxs((GraphDatabaseService)this.db, 42);
        Transaction tx = this.newTransaction(LoginContext.AUTH_DISABLED);
        tx.dataWrite().nodeCreate();
        tx.failure();
        tx.markForTermination((Status)Status.Transaction.Terminated);
        Assert.assertEquals((long)-1L, (long)tx.closeTransaction());
        Assert.assertFalse((boolean)tx.isOpen());
    }

    @Test
    public void txReturnsCorrectIdWhenReadOnly() throws Exception {
        KernelIT.executeDummyTxs((GraphDatabaseService)this.db, 42);
        Transaction tx = this.newTransaction();
        try (NodeCursor node = tx.cursors().allocateNodeCursor();){
            tx.dataRead().singleNode(1L, node);
            node.next();
        }
        tx.success();
        Assert.assertEquals((long)0L, (long)tx.closeTransaction());
        Assert.assertFalse((boolean)tx.isOpen());
    }

    private static void executeDummyTxs(GraphDatabaseService db, int count) {
        for (int i = 0; i < count; ++i) {
            try (org.neo4j.graphdb.Transaction tx = db.beginTx();){
                db.createNode();
                tx.success();
                continue;
            }
        }
    }

    private static long lastCommittedTxId(GraphDatabaseAPI db) {
        TransactionIdStore txIdStore = (TransactionIdStore)db.getDependencyResolver().resolveDependency(TransactionIdStore.class);
        return txIdStore.getLastCommittedTransactionId();
    }

    private IndexReference createIndex(Transaction transaction) throws SchemaKernelException, InvalidTransactionTypeKernelException {
        TokenWrite tokenWrite = transaction.tokenWrite();
        SchemaWrite schemaWrite = transaction.schemaWrite();
        LabelSchemaDescriptor schemaDescriptor = SchemaDescriptorFactory.forLabel((int)tokenWrite.labelGetOrCreateForName("hello"), (int[])new int[]{tokenWrite.propertyKeyGetOrCreateForName("hepp")});
        return schemaWrite.indexCreate((SchemaDescriptor)schemaDescriptor);
    }

    private String getOrCreateSchemaState(String key, String maybeSetThisState) {
        try (org.neo4j.graphdb.Transaction tx = this.db.beginTx();){
            KernelTransaction ktx = this.statementContextSupplier.getKernelTransactionBoundToThisThread(true);
            String state = (String)ktx.schemaRead().schemaStateGetOrCreate((Object)key, s -> maybeSetThisState);
            tx.success();
            String string = state;
            return string;
        }
    }

    private boolean schemaStateContains(String key) {
        try (org.neo4j.graphdb.Transaction tx = this.db.beginTx();){
            KernelTransaction ktx = this.statementContextSupplier.getKernelTransactionBoundToThisThread(true);
            AtomicBoolean result = new AtomicBoolean(true);
            ktx.schemaRead().schemaStateGetOrCreate((Object)key, s -> {
                result.set(false);
                return null;
            });
            tx.success();
            boolean bl = result.get();
            return bl;
        }
    }
}

