/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.TransactionHook;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.storageengine.api.StoreReadLayer;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;

public class TransactionHookIT
extends KernelIntegrationTest {
    @Test
    public void shouldRecieveTxStateOnCommit() throws Exception {
        TransactionHook hook = (TransactionHook)Mockito.mock(TransactionHook.class);
        this.internalKernel().registerTransactionHook(hook);
        Write ops = this.dataWriteInNewTransaction();
        ops.nodeCreate();
        this.commit();
        ((TransactionHook)Mockito.verify((Object)hook)).beforeCommit((ReadableTransactionState)ArgumentMatchers.any(ReadableTransactionState.class), (KernelTransaction)ArgumentMatchers.any(KernelTransaction.class), (StoreReadLayer)ArgumentMatchers.any(StoreReadLayer.class), (StorageStatement)ArgumentMatchers.any(StorageStatement.class));
        ((TransactionHook)Mockito.verify((Object)hook)).afterCommit((ReadableTransactionState)ArgumentMatchers.any(ReadableTransactionState.class), (KernelTransaction)ArgumentMatchers.any(KernelTransaction.class), (TransactionHook.Outcome)ArgumentMatchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{hook});
    }

    @Test
    public void shouldRollbackOnFailureInBeforeCommit() throws Exception {
        TransactionHook hook = (TransactionHook)Mockito.mock(TransactionHook.class);
        String message = "Original";
        Mockito.when((Object)hook.beforeCommit((ReadableTransactionState)ArgumentMatchers.any(ReadableTransactionState.class), (KernelTransaction)ArgumentMatchers.any(KernelTransaction.class), (StoreReadLayer)ArgumentMatchers.any(StoreReadLayer.class), (StorageStatement)ArgumentMatchers.any(StorageStatement.class))).thenReturn((Object)new TransactionHook.Outcome(){

            public boolean isSuccessful() {
                return false;
            }

            public Throwable failure() {
                return new Throwable("Original");
            }
        });
        this.internalKernel().registerTransactionHook(hook);
        Write ops = this.dataWriteInNewTransaction();
        ops.nodeCreate();
        try {
            this.commit();
            Assert.fail((String)"Expected this to fail.");
        }
        catch (TransactionFailureException e) {
            Assert.assertThat((Object)e.status(), (Matcher)Matchers.equalTo((Object)Status.Transaction.TransactionHookFailed));
            Assert.assertThat((Object)e.getCause().getMessage(), (Matcher)Matchers.equalTo((Object)"Original"));
        }
        ((TransactionHook)Mockito.verify((Object)hook)).beforeCommit((ReadableTransactionState)ArgumentMatchers.any(ReadableTransactionState.class), (KernelTransaction)ArgumentMatchers.any(KernelTransaction.class), (StoreReadLayer)ArgumentMatchers.any(StoreReadLayer.class), (StorageStatement)ArgumentMatchers.any(StorageStatement.class));
        ((TransactionHook)Mockito.verify((Object)hook)).afterRollback((ReadableTransactionState)ArgumentMatchers.any(ReadableTransactionState.class), (KernelTransaction)ArgumentMatchers.any(KernelTransaction.class), (TransactionHook.Outcome)ArgumentMatchers.any(TransactionHook.Outcome.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{hook});
    }
}

