/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorSupplier;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptorFactory;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.test.Race;
import org.neo4j.test.rule.PageCacheAndDependenciesRule;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.values.storable.Value;

public abstract class IndexPopulationStressTest {
    @Rule
    public PageCacheAndDependenciesRule rules = new PageCacheAndDependenciesRule(DefaultFileSystemRule::new, this.getClass());
    protected final SchemaIndexDescriptor descriptor = SchemaIndexDescriptorFactory.forLabel((int)0, (int[])new int[]{0});
    private IndexPopulator populator;

    abstract IndexProvider newProvider(IndexDirectoryStructure.Factory var1);

    abstract Value randomValue(Random var1);

    @Before
    public void setup() throws IOException {
        File storeDir = this.rules.directory().graphDbDir();
        IndexDirectoryStructure.Factory directory = IndexDirectoryStructure.directoriesBySubProvider((IndexDirectoryStructure)IndexDirectoryStructure.directoriesByProvider((File)storeDir).forProvider(new IndexProvider.Descriptor("provider", "1.0")));
        IndexProvider indexProvider = this.newProvider(directory);
        this.rules.fileSystem().mkdirs(indexProvider.directoryStructure().rootDirectory());
        this.populator = indexProvider.getPopulator(0L, this.descriptor, new IndexSamplingConfig(1000, 0.2, true));
    }

    @After
    public void teardown() throws IOException {
        this.populator.close(true);
    }

    @Test
    public void stressIt() throws Throwable {
        Race race = new Race();
        int threads = 50;
        AtomicBoolean end = new AtomicBoolean();
        this.populator.create();
        for (int i = 0; i < 50; ++i) {
            race.addContestant(Race.throwing(() -> {
                ThreadLocalRandom random = ThreadLocalRandom.current();
                while (!end.get()) {
                    this.populator.add(this.randomAdds(random));
                }
            }));
        }
        try {
            race.go(5L, TimeUnit.SECONDS);
            Assert.fail((String)"Race should have timed out.");
        }
        catch (TimeoutException t) {
            end.set(true);
        }
    }

    private Collection<? extends IndexEntryUpdate<?>> randomAdds(Random random) {
        int n = random.nextInt(100) + 1;
        ArrayList<IndexEntryUpdate> updates = new ArrayList<IndexEntryUpdate>(n);
        for (int i = 0; i < n; ++i) {
            Value value = this.randomValue(random);
            updates.add(IndexEntryUpdate.add((long)i, (SchemaDescriptorSupplier)this.descriptor, (Value[])new Value[]{value}));
        }
        return updates;
    }
}

