/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.cursor.RawCursor;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Hit;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.index.schema.LayoutTestUtil;
import org.neo4j.kernel.impl.index.schema.NativeSchemaKey;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.kernel.impl.index.schema.SimpleHit;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public abstract class NativeSchemaIndexTestUtil<KEY extends NativeSchemaKey<KEY>, VALUE extends NativeSchemaValue> {
    static final long NON_EXISTENT_ENTITY_ID = 1000000000L;
    final DefaultFileSystemRule fs = new DefaultFileSystemRule();
    private final TestDirectory directory = TestDirectory.testDirectory(this.getClass(), (FileSystemAbstraction)this.fs.get());
    private final PageCacheRule pageCacheRule = new PageCacheRule(PageCacheRule.config().withAccessChecks(true));
    protected final RandomRule random = new RandomRule();
    @Rule
    public final RuleChain rules = RuleChain.outerRule((TestRule)this.fs).around((TestRule)this.directory).around((TestRule)this.pageCacheRule).around((TestRule)this.random);
    SchemaIndexDescriptor schemaIndexDescriptor;
    LayoutTestUtil<KEY, VALUE> layoutUtil;
    Layout<KEY, VALUE> layout;
    private File indexFile;
    PageCache pageCache;
    IndexProvider.Monitor monitor = IndexProvider.Monitor.EMPTY;
    long indexId = 1L;

    @Before
    public void setup() {
        this.layoutUtil = this.createLayoutTestUtil();
        this.schemaIndexDescriptor = this.layoutUtil.indexDescriptor();
        this.layout = this.layoutUtil.createLayout();
        this.indexFile = this.directory.file("index");
        this.pageCache = this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fs);
    }

    public File getIndexFile() {
        return this.indexFile;
    }

    abstract LayoutTestUtil<KEY, VALUE> createLayoutTestUtil();

    private void copyValue(VALUE value, VALUE intoValue) {
        this.layoutUtil.copyValue(value, intoValue);
    }

    void verifyUpdates(IndexEntryUpdate<SchemaIndexDescriptor>[] updates) throws IOException {
        Hit<KEY, VALUE>[] expectedHits = this.convertToHits(updates, this.layout);
        ArrayList<Hit<KEY, VALUE>> actualHits = new ArrayList<Hit<KEY, VALUE>>();
        try (GBPTree<KEY, VALUE> tree = this.getTree();
             RawCursor<Hit<KEY, VALUE>, IOException> scan = this.scan(tree);){
            while (scan.next()) {
                actualHits.add(this.deepCopy((Hit)scan.get()));
            }
        }
        Comparator hitComparator = (h1, h2) -> {
            int keyCompare = this.layout.compare(h1.key(), h2.key());
            if (keyCompare == 0) {
                return this.layoutUtil.compareIndexedPropertyValue((NativeSchemaKey)h1.key(), (NativeSchemaKey)h2.key());
            }
            return keyCompare;
        };
        this.assertSameHits(expectedHits, actualHits.toArray(new Hit[0]), hitComparator);
    }

    GBPTree<KEY, VALUE> getTree() throws IOException {
        return new GBPTree(this.pageCache, this.getIndexFile(), this.layout, 0, GBPTree.NO_MONITOR, GBPTree.NO_HEADER_READER, GBPTree.NO_HEADER_WRITER, RecoveryCleanupWorkCollector.IMMEDIATE);
    }

    private RawCursor<Hit<KEY, VALUE>, IOException> scan(GBPTree<KEY, VALUE> tree) throws IOException {
        NativeSchemaKey lowest = (NativeSchemaKey)this.layout.newKey();
        lowest.initAsLowest();
        NativeSchemaKey highest = (NativeSchemaKey)this.layout.newKey();
        highest.initAsHighest();
        return tree.seek((Object)lowest, (Object)highest);
    }

    private void assertSameHits(Hit<KEY, VALUE>[] expectedHits, Hit<KEY, VALUE>[] actualHits, Comparator<Hit<KEY, VALUE>> comparator) {
        Arrays.sort(expectedHits, comparator);
        Arrays.sort(actualHits, comparator);
        Assert.assertEquals((String)String.format("Array length differ%nExpected:%s%nActual:%s", Arrays.toString(expectedHits), Arrays.toString(actualHits)), (long)expectedHits.length, (long)actualHits.length);
        for (int i = 0; i < expectedHits.length; ++i) {
            Hit<KEY, VALUE> expected = expectedHits[i];
            Hit<KEY, VALUE> actual = actualHits[i];
            Assert.assertTrue((String)("Hits differ on item number " + i + ". Expected " + expected + " but was " + actual), (comparator.compare(expected, actual) == 0 ? 1 : 0) != 0);
        }
    }

    private Hit<KEY, VALUE> deepCopy(Hit<KEY, VALUE> from) {
        NativeSchemaKey intoKey = (NativeSchemaKey)this.layout.newKey();
        NativeSchemaValue intoValue = (NativeSchemaValue)this.layout.newValue();
        this.layout.copyKey(from.key(), (Object)intoKey);
        this.copyValue((NativeSchemaValue)from.value(), intoValue);
        return new SimpleHit<NativeSchemaKey, NativeSchemaValue>(intoKey, intoValue);
    }

    private Hit<KEY, VALUE>[] convertToHits(IndexEntryUpdate<SchemaIndexDescriptor>[] updates, Layout<KEY, VALUE> layout) {
        ArrayList<Hit<NativeSchemaKey, NativeSchemaValue>> hits = new ArrayList<Hit<NativeSchemaKey, NativeSchemaValue>>(updates.length);
        for (IndexEntryUpdate<SchemaIndexDescriptor> u : updates) {
            NativeSchemaKey key = (NativeSchemaKey)layout.newKey();
            key.from(u.getEntityId(), u.values());
            NativeSchemaValue value = (NativeSchemaValue)layout.newValue();
            value.from(u.values());
            hits.add(this.hit(key, value));
        }
        return hits.toArray(new Hit[0]);
    }

    private Hit<KEY, VALUE> hit(KEY key, VALUE value) {
        return new SimpleHit<KEY, VALUE>(key, value);
    }

    void assertFilePresent() {
        Assert.assertTrue((boolean)this.fs.fileExists(this.getIndexFile()));
    }

    void assertFileNotPresent() {
        Assert.assertFalse((boolean)this.fs.fileExists(this.getIndexFile()));
    }
}

