/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.gis.spatial.index.curves.StandardConfiguration;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndexAccessor;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndexAccessorTest;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.kernel.impl.index.schema.SpatialIndexAccessor;
import org.neo4j.kernel.impl.index.schema.SpatialIndexFiles;
import org.neo4j.kernel.impl.index.schema.SpatialSchemaKey;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettings;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettingsFactory;
import org.neo4j.values.storable.CoordinateReferenceSystem;

abstract class SpatialSchemaIndexAccessorTest
extends NativeSchemaIndexAccessorTest<SpatialSchemaKey, NativeSchemaValue> {
    static final CoordinateReferenceSystem crs = CoordinateReferenceSystem.WGS84;
    static final SpaceFillingCurveSettings settings = new SpaceFillingCurveSettingsFactory(Config.defaults()).settingsFor(crs);
    SpatialIndexFiles.SpatialFileLayout fileLayout;

    SpatialSchemaIndexAccessorTest() {
    }

    @Override
    NativeSchemaIndexAccessor<SpatialSchemaKey, NativeSchemaValue> makeAccessorWithSamplingConfig(IndexSamplingConfig samplingConfig) throws IOException {
        this.fileLayout = new SpatialIndexFiles.SpatialFileLayout(CoordinateReferenceSystem.WGS84, settings, super.getIndexFile());
        SpatialIndexFiles.SpatialFileLayout fileLayout = new SpatialIndexFiles.SpatialFileLayout(CoordinateReferenceSystem.WGS84, settings, super.getIndexFile());
        return new SpatialIndexAccessor.PartAccessor(this.pageCache, (FileSystemAbstraction)this.fs, fileLayout, RecoveryCleanupWorkCollector.IMMEDIATE, this.monitor, this.schemaIndexDescriptor, this.indexId, samplingConfig, (SpaceFillingCurveConfiguration)new StandardConfiguration());
    }

    @Override
    public File getIndexFile() {
        return this.fileLayout.indexFile;
    }

    @Override
    public void shouldNotSeeFilteredEntries() {
    }

    @Override
    public void shouldReturnMatchingEntriesForRangePredicateWithExclusiveStartAndExclusiveEnd() {
    }

    @Override
    public void shouldReturnMatchingEntriesForRangePredicateWithExclusiveStartAndInclusiveEnd() {
    }

    @Override
    public void shouldReturnMatchingEntriesForRangePredicateWithInclusiveStartAndExclusiveEnd() {
    }
}

