/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.verification.VerificationMode;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.helpers.collection.BoundedIterable;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexAccessor;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexProvider;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexTestHelp;
import org.neo4j.kernel.impl.index.schema.fusion.FusionVersion;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@RunWith(value=Parameterized.class)
public class FusionIndexAccessorTest {
    private FusionIndexAccessor fusionIndexAccessor;
    private final long indexId = 10L;
    private final FusionIndexProvider.DropAction dropAction = (FusionIndexProvider.DropAction)Mockito.mock(FusionIndexProvider.DropAction.class);
    private IndexAccessor[] accessors;
    private IndexAccessor[] aliveAccessors;
    @Rule
    public RandomRule random = new RandomRule();
    @Parameterized.Parameter
    public static FusionVersion fusionVersion;

    @Parameterized.Parameters(name="{0}")
    public static FusionVersion[] versions() {
        return new FusionVersion[]{FusionVersion.v00, FusionVersion.v10, FusionVersion.v20};
    }

    @Before
    public void setup() {
        this.initiateMocks();
    }

    private void initiateMocks() {
        int[] activeSlots = fusionVersion.aliveSlots();
        this.accessors = new IndexAccessor[5];
        Arrays.fill(this.accessors, IndexAccessor.EMPTY);
        this.aliveAccessors = new IndexAccessor[activeSlots.length];
        block7: for (int i = 0; i < activeSlots.length; ++i) {
            IndexAccessor mock;
            this.aliveAccessors[i] = mock = (IndexAccessor)Mockito.mock(IndexAccessor.class);
            switch (activeSlots[i]) {
                case 0: {
                    this.accessors[0] = mock;
                    continue block7;
                }
                case 1: {
                    this.accessors[1] = mock;
                    continue block7;
                }
                case 2: {
                    this.accessors[2] = mock;
                    continue block7;
                }
                case 3: {
                    this.accessors[3] = mock;
                    continue block7;
                }
                case 4: {
                    this.accessors[4] = mock;
                    continue block7;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
        this.fusionIndexAccessor = new FusionIndexAccessor(this.accessors, fusionVersion.selector(), 10L, (SchemaIndexDescriptor)Mockito.mock(SchemaIndexDescriptor.class), this.dropAction);
    }

    private void resetMocks() {
        for (IndexAccessor accessor : this.aliveAccessors) {
            Mockito.reset((Object[])new IndexAccessor[]{accessor});
        }
    }

    @Test
    public void dropMustDropAll() throws Exception {
        this.fusionIndexAccessor.drop();
        for (IndexAccessor accessor : this.aliveAccessors) {
            ((IndexAccessor)Mockito.verify((Object)accessor, (VerificationMode)VerificationModeFactory.times((int)1))).drop();
        }
        ((FusionIndexProvider.DropAction)Mockito.verify((Object)this.dropAction)).drop(10L);
    }

    @Test
    public void dropMustThrowIfDropAnyFail() throws Exception {
        for (IndexAccessor accessor : this.aliveAccessors) {
            this.verifyFailOnSingleDropFailure(accessor, this.fusionIndexAccessor);
        }
    }

    @Test
    public void fusionIndexIsDirtyWhenAnyIsDirty() {
        for (IndexAccessor dirtyAccessor : this.aliveAccessors) {
            for (IndexAccessor aliveAccessor : this.aliveAccessors) {
                Mockito.when((Object)aliveAccessor.isDirty()).thenReturn((Object)(aliveAccessor == dirtyAccessor ? 1 : 0));
            }
            Assert.assertTrue((boolean)this.fusionIndexAccessor.isDirty());
        }
    }

    private void verifyFailOnSingleDropFailure(IndexAccessor failingAccessor, FusionIndexAccessor fusionIndexAccessor) throws IOException {
        IOException expectedFailure = new IOException("fail");
        ((IndexAccessor)Mockito.doThrow((Throwable[])new Throwable[]{expectedFailure}).when((Object)failingAccessor)).drop();
        try {
            fusionIndexAccessor.drop();
            Assert.fail((String)"Should have failed");
        }
        catch (IOException e) {
            Assert.assertSame((Object)expectedFailure, (Object)e);
        }
        ((IndexAccessor)Mockito.doAnswer(invocation -> null).when((Object)failingAccessor)).drop();
    }

    @Test
    public void dropMustThrowIfAllFail() throws Exception {
        ArrayList<IOException> exceptions = new ArrayList<IOException>();
        for (IndexAccessor indexAccessor : this.aliveAccessors) {
            IOException exception = new IOException(indexAccessor.getClass().getSimpleName() + " fail");
            exceptions.add(exception);
            ((IndexAccessor)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)indexAccessor)).drop();
        }
        try {
            this.fusionIndexAccessor.drop();
            Assert.fail((String)"Should have failed");
        }
        catch (IOException e) {
            Assert.assertThat(exceptions, (Matcher)CoreMatchers.hasItem((Object)e));
        }
    }

    @Test
    public void closeMustCloseAll() throws Exception {
        this.fusionIndexAccessor.close();
        for (IndexAccessor accessor : this.aliveAccessors) {
            ((IndexAccessor)Mockito.verify((Object)accessor, (VerificationMode)VerificationModeFactory.times((int)1))).close();
        }
    }

    @Test
    public void closeMustThrowIfOneThrow() throws Exception {
        for (IndexAccessor accessor : this.aliveAccessors) {
            FusionIndexTestHelp.verifyFusionCloseThrowOnSingleCloseThrow((AutoCloseable)accessor, (AutoCloseable)this.fusionIndexAccessor);
            this.resetMocks();
        }
    }

    @Test
    public void closeMustCloseOthersIfOneThrow() throws Exception {
        for (IndexAccessor accessor : this.aliveAccessors) {
            FusionIndexTestHelp.verifyOtherIsClosedOnSingleThrow((AutoCloseable)accessor, (AutoCloseable)this.fusionIndexAccessor, (AutoCloseable[])ArrayUtil.without((Object[])this.aliveAccessors, (Object[])new IndexAccessor[]{accessor}));
            this.resetMocks();
        }
    }

    @Test
    public void closeMustThrowIfAllFail() throws Exception {
        FusionIndexTestHelp.verifyFusionCloseThrowIfAllThrow((AutoCloseable)this.fusionIndexAccessor, (AutoCloseable[])this.aliveAccessors);
    }

    @Test
    public void allEntriesReaderMustCombineResultFromAll() {
        List[] ids = new List[this.aliveAccessors.length];
        long lastId = 0L;
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = Arrays.asList(lastId++, lastId++);
        }
        this.mockAllEntriesReaders(ids);
        Set result = Iterables.asSet((Iterable)this.fusionIndexAccessor.newAllEntriesReader());
        for (List part : ids) {
            FusionIndexAccessorTest.assertResultContainsAll(result, part);
        }
    }

    @Test
    public void allEntriesReaderMustCombineResultFromAllWithOneEmpty() {
        for (int i = 0; i < this.accessors.length; ++i) {
            List[] ids = new List[this.aliveAccessors.length];
            long lastId = 0L;
            for (int j = 0; j < ids.length; ++j) {
                ids[j] = j == i ? Collections.emptyList() : Arrays.asList(lastId++, lastId++);
            }
            this.mockAllEntriesReaders(ids);
            Set result = Iterables.asSet((Iterable)this.fusionIndexAccessor.newAllEntriesReader());
            for (List part : ids) {
                FusionIndexAccessorTest.assertResultContainsAll(result, part);
            }
        }
    }

    @Test
    public void allEntriesReaderMustCombineResultFromAllEmpty() {
        List[] ids = new List[this.aliveAccessors.length];
        for (int j = 0; j < ids.length; ++j) {
            ids[j] = Collections.emptyList();
        }
        this.mockAllEntriesReaders(ids);
        Set result = Iterables.asSet((Iterable)this.fusionIndexAccessor.newAllEntriesReader());
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void allEntriesReaderMustCombineResultFromAllAccessors() {
        Object[] parts = new List[this.aliveAccessors.length];
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = new ArrayList();
        }
        for (long i = 0L; i < 10L; ++i) {
            ((List)this.random.among(parts)).add(i);
        }
        this.mockAllEntriesReaders((List<Long>[])parts);
        Set result = Iterables.asSet((Iterable)this.fusionIndexAccessor.newAllEntriesReader());
        for (Object part : parts) {
            FusionIndexAccessorTest.assertResultContainsAll(result, (List<Long>)part);
        }
    }

    @Test
    public void allEntriesReaderMustCloseAll() throws Exception {
        BoundedIterable[] allEntriesReaders = (BoundedIterable[])Arrays.stream(this.aliveAccessors).map(accessor -> FusionIndexAccessorTest.mockSingleAllEntriesReader(accessor, Arrays.asList(new Long[0]))).toArray(BoundedIterable[]::new);
        this.fusionIndexAccessor.newAllEntriesReader().close();
        for (BoundedIterable allEntriesReader : allEntriesReaders) {
            ((BoundedIterable)Mockito.verify((Object)allEntriesReader, (VerificationMode)VerificationModeFactory.times((int)1))).close();
        }
    }

    @Test
    public void allEntriesReaderMustCloseOthersIfOneThrow() throws Exception {
        for (int i = 0; i < this.aliveAccessors.length; ++i) {
            Object[] allEntriesReaders = (BoundedIterable[])Arrays.stream(this.aliveAccessors).map(accessor -> FusionIndexAccessorTest.mockSingleAllEntriesReader(accessor, Arrays.asList(new Long[0]))).toArray(BoundedIterable[]::new);
            BoundedIterable fusionAllEntriesReader = this.fusionIndexAccessor.newAllEntriesReader();
            FusionIndexTestHelp.verifyOtherIsClosedOnSingleThrow((AutoCloseable)allEntriesReaders[i], (AutoCloseable)fusionAllEntriesReader, (AutoCloseable[])ArrayUtil.without((Object[])allEntriesReaders, (Object[])new BoundedIterable[]{allEntriesReaders[i]}));
            this.resetMocks();
        }
    }

    @Test
    public void allEntriesReaderMustThrowIfOneThrow() throws Exception {
        for (IndexAccessor failingAccessor : this.aliveAccessors) {
            BoundedIterable<Long> failingReader = null;
            for (IndexAccessor aliveAccessor : this.aliveAccessors) {
                BoundedIterable<Long> reader = FusionIndexAccessorTest.mockSingleAllEntriesReader(aliveAccessor, Collections.emptyList());
                if (aliveAccessor != failingAccessor) continue;
                failingReader = reader;
            }
            BoundedIterable fusionAllEntriesReader = this.fusionIndexAccessor.newAllEntriesReader();
            FusionIndexTestHelp.verifyFusionCloseThrowOnSingleCloseThrow(failingReader, (AutoCloseable)fusionAllEntriesReader);
        }
    }

    @Test
    public void allEntriesReaderMustReportUnknownMaxCountIfAnyReportUnknownMaxCount() {
        for (int i = 0; i < this.aliveAccessors.length; ++i) {
            for (int j = 0; j < this.aliveAccessors.length; ++j) {
                if (j == i) {
                    FusionIndexAccessorTest.mockSingleAllEntriesReaderWithUnknownMaxCount(this.aliveAccessors[j], Collections.emptyList());
                    continue;
                }
                FusionIndexAccessorTest.mockSingleAllEntriesReader(this.aliveAccessors[j], Collections.emptyList());
            }
            BoundedIterable fusionAllEntriesReader = this.fusionIndexAccessor.newAllEntriesReader();
            Assert.assertThat((Object)fusionAllEntriesReader.maxCount(), (Matcher)CoreMatchers.is((Object)-1L));
        }
    }

    @Test
    public void allEntriesReaderMustReportFusionMaxCountOfAll() {
        long lastId = 0L;
        for (IndexAccessor accessor : this.aliveAccessors) {
            FusionIndexAccessorTest.mockSingleAllEntriesReader(accessor, Arrays.asList(lastId++, lastId++));
        }
        BoundedIterable fusionAllEntriesReader = this.fusionIndexAccessor.newAllEntriesReader();
        Assert.assertThat((Object)fusionAllEntriesReader.maxCount(), (Matcher)CoreMatchers.is((Object)lastId));
    }

    @Test
    public void shouldFailValueValidationIfAnyPartFail() {
        IllegalArgumentException failure = new IllegalArgumentException("failing");
        for (int i = 0; i < this.aliveAccessors.length; ++i) {
            for (int j = 0; j < this.aliveAccessors.length; ++j) {
                if (i == j) {
                    ((IndexAccessor)Mockito.doThrow((Throwable[])new Throwable[]{failure}).when((Object)this.aliveAccessors[i])).validateBeforeCommit((Value[])ArgumentMatchers.any(Value[].class));
                    continue;
                }
                ((IndexAccessor)Mockito.doAnswer(invocation -> null).when((Object)this.aliveAccessors[i])).validateBeforeCommit((Value[])ArgumentMatchers.any(Value[].class));
            }
            try {
                this.fusionIndexAccessor.validateBeforeCommit(new Value[]{Values.stringValue((String)"something")});
                continue;
            }
            catch (IllegalArgumentException e) {
                Assert.assertSame((Object)failure, (Object)e);
            }
        }
    }

    @Test
    public void shouldSucceedValueValidationIfAllSucceed() {
        this.fusionIndexAccessor.validateBeforeCommit(new Value[]{Values.stringValue((String)"test value")});
    }

    static void assertResultContainsAll(Set<Long> result, List<Long> expectedEntries) {
        for (long expectedEntry : expectedEntries) {
            Assert.assertTrue((String)("Expected to contain " + expectedEntry + ", but was " + result), (boolean)result.contains(expectedEntry));
        }
    }

    private static BoundedIterable<Long> mockSingleAllEntriesReader(IndexAccessor targetAccessor, List<Long> entries) {
        BoundedIterable<Long> allEntriesReader = FusionIndexAccessorTest.mockedAllEntriesReader(entries);
        Mockito.when((Object)targetAccessor.newAllEntriesReader()).thenReturn(allEntriesReader);
        return allEntriesReader;
    }

    static BoundedIterable<Long> mockedAllEntriesReader(List<Long> entries) {
        return FusionIndexAccessorTest.mockedAllEntriesReader(true, entries);
    }

    private static BoundedIterable<Long> mockSingleAllEntriesReaderWithUnknownMaxCount(IndexAccessor targetAccessor, List<Long> entries) {
        BoundedIterable<Long> allEntriesReader = FusionIndexAccessorTest.mockedAllEntriesReaderUnknownMaxCount(entries);
        Mockito.when((Object)targetAccessor.newAllEntriesReader()).thenReturn(allEntriesReader);
        return allEntriesReader;
    }

    static BoundedIterable<Long> mockedAllEntriesReaderUnknownMaxCount(List<Long> entries) {
        return FusionIndexAccessorTest.mockedAllEntriesReader(false, entries);
    }

    static BoundedIterable<Long> mockedAllEntriesReader(boolean knownMaxCount, List<Long> entries) {
        BoundedIterable mockedAllEntriesReader = (BoundedIterable)Mockito.mock(BoundedIterable.class);
        Mockito.when((Object)mockedAllEntriesReader.maxCount()).thenReturn((Object)(knownMaxCount ? (long)entries.size() : -1L));
        Mockito.when((Object)mockedAllEntriesReader.iterator()).thenReturn(entries.iterator());
        return mockedAllEntriesReader;
    }

    private void mockAllEntriesReaders(List<Long> ... entries) {
        for (int i = 0; i < entries.length; ++i) {
            FusionIndexAccessorTest.mockSingleAllEntriesReader(this.aliveAccessors[i], entries[i]);
        }
    }
}

