/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexPopulator;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexProvider;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexTestHelp;
import org.neo4j.kernel.impl.index.schema.fusion.FusionVersion;
import org.neo4j.values.storable.Value;

@RunWith(value=Parameterized.class)
public class FusionIndexPopulatorTest {
    private IndexPopulator[] alivePopulators;
    private IndexPopulator[] populators;
    private FusionIndexPopulator fusionIndexPopulator;
    private final long indexId = 8L;
    private final FusionIndexProvider.DropAction dropAction = (FusionIndexProvider.DropAction)Mockito.mock(FusionIndexProvider.DropAction.class);
    @Parameterized.Parameter
    public static FusionVersion fusionVersion;

    @Parameterized.Parameters(name="{0}")
    public static FusionVersion[] versions() {
        return new FusionVersion[]{FusionVersion.v00, FusionVersion.v10, FusionVersion.v20};
    }

    @Before
    public void setup() {
        this.initiateMocks();
    }

    private void initiateMocks() {
        int[] aliveSlots = fusionVersion.aliveSlots();
        this.populators = new IndexPopulator[5];
        Arrays.fill(this.populators, IndexPopulator.EMPTY);
        this.alivePopulators = new IndexPopulator[aliveSlots.length];
        block7: for (int i = 0; i < aliveSlots.length; ++i) {
            IndexPopulator mock;
            this.alivePopulators[i] = mock = (IndexPopulator)Mockito.mock(IndexPopulator.class);
            switch (aliveSlots[i]) {
                case 0: {
                    this.populators[0] = mock;
                    continue block7;
                }
                case 1: {
                    this.populators[1] = mock;
                    continue block7;
                }
                case 2: {
                    this.populators[2] = mock;
                    continue block7;
                }
                case 3: {
                    this.populators[3] = mock;
                    continue block7;
                }
                case 4: {
                    this.populators[4] = mock;
                    continue block7;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
        this.fusionIndexPopulator = new FusionIndexPopulator(this.populators, fusionVersion.selector(), 8L, this.dropAction, false);
    }

    private void resetMocks() {
        for (IndexPopulator alivePopulator : this.alivePopulators) {
            Mockito.reset((Object[])new IndexPopulator[]{alivePopulator});
        }
    }

    @Test
    public void createMustCreateAll() throws Exception {
        this.fusionIndexPopulator.create();
        for (IndexPopulator alivePopulator : this.alivePopulators) {
            ((IndexPopulator)Mockito.verify((Object)alivePopulator, (VerificationMode)Mockito.times((int)1))).create();
        }
    }

    @Test
    public void createRemoveAnyLeftOversThatWasThereInIndexDirectoryBeforePopulation() throws IOException {
        this.fusionIndexPopulator.create();
        ((FusionIndexProvider.DropAction)Mockito.verify((Object)this.dropAction)).drop(8L, false);
    }

    @Test
    public void createMustThrowIfAnyThrow() throws Exception {
        for (IndexPopulator alivePopulator : this.alivePopulators) {
            IOException failure = new IOException("fail");
            ((IndexPopulator)Mockito.doThrow((Throwable[])new Throwable[]{failure}).when((Object)alivePopulator)).create();
            FusionIndexTestHelp.verifyCallFail(failure, () -> {
                this.fusionIndexPopulator.create();
                return null;
            });
            ((IndexPopulator)Mockito.doAnswer(invocation -> null).when((Object)alivePopulator)).create();
        }
    }

    @Test
    public void dropMustDropAll() throws Exception {
        this.fusionIndexPopulator.drop();
        for (IndexPopulator alivePopulator : this.alivePopulators) {
            ((IndexPopulator)Mockito.verify((Object)alivePopulator, (VerificationMode)Mockito.times((int)1))).drop();
        }
        ((FusionIndexProvider.DropAction)Mockito.verify((Object)this.dropAction)).drop(8L);
    }

    @Test
    public void dropMustThrowIfAnyDropThrow() throws Exception {
        for (IndexPopulator alivePopulator : this.alivePopulators) {
            IOException failure = new IOException("fail");
            ((IndexPopulator)Mockito.doThrow((Throwable[])new Throwable[]{failure}).when((Object)alivePopulator)).drop();
            FusionIndexTestHelp.verifyCallFail(failure, () -> {
                this.fusionIndexPopulator.drop();
                return null;
            });
            ((IndexPopulator)Mockito.doAnswer(invocation -> null).when((Object)alivePopulator)).drop();
        }
    }

    @Test
    public void addMustSelectCorrectPopulator() throws Exception {
        Value[][] values = FusionIndexTestHelp.valuesByGroup();
        Value[] allValues = FusionIndexTestHelp.allValues();
        for (int i = 0; i < this.populators.length; ++i) {
            Value[] valueArray = values[i];
            int n = valueArray.length;
            for (int j = 0; j < n; ++j) {
                Value value = valueArray[j];
                this.verifyAddWithCorrectPopulator(this.orLucene(this.populators[i]), value);
            }
        }
        for (Value firstValue : allValues) {
            for (Value secondValue : allValues) {
                this.verifyAddWithCorrectPopulator(this.populators[4], firstValue, secondValue);
            }
        }
    }

    private void verifyAddWithCorrectPopulator(IndexPopulator correctPopulator, Value ... numberValues) throws IndexEntryConflictException, IOException {
        List<IndexEntryUpdate<LabelSchemaDescriptor>> update = Collections.singletonList(FusionIndexTestHelp.add(numberValues));
        this.fusionIndexPopulator.add(update);
        ((IndexPopulator)Mockito.verify((Object)correctPopulator, (VerificationMode)Mockito.times((int)1))).add(update);
        for (IndexPopulator alivePopulator : this.alivePopulators) {
            if (alivePopulator == correctPopulator) continue;
            ((IndexPopulator)Mockito.verify((Object)alivePopulator, (VerificationMode)Mockito.never())).add(update);
        }
    }

    @Test
    public void verifyDeferredConstraintsMustThrowIfAnyThrow() throws Exception {
        for (IndexPopulator alivePopulator : this.alivePopulators) {
            IndexEntryConflictException failure = (IndexEntryConflictException)((Object)Mockito.mock(IndexEntryConflictException.class));
            ((IndexPopulator)Mockito.doThrow((Throwable[])new Throwable[]{failure}).when((Object)alivePopulator)).verifyDeferredConstraints((PropertyAccessor)ArgumentMatchers.any());
            FusionIndexTestHelp.verifyCallFail((Exception)((Object)failure), () -> {
                this.fusionIndexPopulator.verifyDeferredConstraints(null);
                return null;
            });
            ((IndexPopulator)Mockito.doAnswer(invocation -> null).when((Object)alivePopulator)).verifyDeferredConstraints((PropertyAccessor)ArgumentMatchers.any());
        }
    }

    @Test
    public void successfulCloseMustCloseAll() throws Exception {
        this.closeAndVerifyPropagation(true);
    }

    @Test
    public void unsuccessfulCloseMustCloseAll() throws Exception {
        this.closeAndVerifyPropagation(false);
    }

    private void closeAndVerifyPropagation(boolean populationCompletedSuccessfully) throws IOException {
        this.fusionIndexPopulator.close(populationCompletedSuccessfully);
        for (IndexPopulator alivePopulator : this.alivePopulators) {
            ((IndexPopulator)Mockito.verify((Object)alivePopulator, (VerificationMode)Mockito.times((int)1))).close(populationCompletedSuccessfully);
        }
    }

    @Test
    public void closeMustThrowIfCloseAnyThrow() throws Exception {
        for (IndexPopulator alivePopulator : this.alivePopulators) {
            IOException failure = new IOException("fail");
            ((IndexPopulator)Mockito.doThrow((Throwable[])new Throwable[]{failure}).when((Object)alivePopulator)).close(ArgumentMatchers.anyBoolean());
            FusionIndexTestHelp.verifyCallFail(failure, () -> {
                this.fusionIndexPopulator.close(ArgumentMatchers.anyBoolean());
                return null;
            });
            ((IndexPopulator)Mockito.doAnswer(invocation -> null).when((Object)alivePopulator)).close(ArgumentMatchers.anyBoolean());
        }
    }

    private void verifyOtherCloseOnThrow(IndexPopulator throwingPopulator) throws Exception {
        IOException failure = new IOException("fail");
        ((IndexPopulator)Mockito.doThrow((Throwable[])new Throwable[]{failure}).when((Object)throwingPopulator)).close(ArgumentMatchers.anyBoolean());
        try {
            this.fusionIndexPopulator.close(true);
            Assert.fail((String)"Should have failed");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (IndexPopulator alivePopulator : this.alivePopulators) {
            ((IndexPopulator)Mockito.verify((Object)alivePopulator, (VerificationMode)Mockito.times((int)1))).close(true);
        }
    }

    @Test
    public void closeMustCloseOthersIfAnyThrow() throws Exception {
        for (IndexPopulator throwingPopulator : this.alivePopulators) {
            this.verifyOtherCloseOnThrow(throwingPopulator);
            this.resetMocks();
        }
    }

    @Test
    public void closeMustThrowIfAllThrow() throws Exception {
        block3: {
            ArrayList<IOException> failures = new ArrayList<IOException>();
            for (IndexPopulator alivePopulator : this.alivePopulators) {
                IOException failure = new IOException("FAILURE[" + alivePopulator + "]");
                failures.add(failure);
                ((IndexPopulator)Mockito.doThrow((Throwable[])new Throwable[]{failure}).when((Object)alivePopulator)).close(ArgumentMatchers.anyBoolean());
            }
            try {
                this.fusionIndexPopulator.close(ArgumentMatchers.anyBoolean());
                Assert.fail((String)"Should have failed");
            }
            catch (IOException e) {
                if (failures.contains(e)) break block3;
                Assert.fail((String)("Thrown exception didn't match any of the expected failures: " + failures));
            }
        }
    }

    @Test
    public void markAsFailedMustMarkAll() throws Exception {
        String failureMessage = "failure";
        this.fusionIndexPopulator.markAsFailed(failureMessage);
        for (IndexPopulator alivePopulator : this.alivePopulators) {
            ((IndexPopulator)Mockito.verify((Object)alivePopulator, (VerificationMode)Mockito.times((int)1))).markAsFailed(failureMessage);
        }
    }

    @Test
    public void markAsFailedMustThrowIfAnyThrow() throws Exception {
        for (IndexPopulator alivePopulator : this.alivePopulators) {
            IOException failure = new IOException("fail");
            ((IndexPopulator)Mockito.doThrow((Throwable[])new Throwable[]{failure}).when((Object)alivePopulator)).markAsFailed(ArgumentMatchers.anyString());
            FusionIndexTestHelp.verifyCallFail(failure, () -> {
                this.fusionIndexPopulator.markAsFailed(ArgumentMatchers.anyString());
                return null;
            });
            ((IndexPopulator)Mockito.doAnswer(invocation -> null).when((Object)alivePopulator)).markAsFailed(ArgumentMatchers.anyString());
        }
    }

    @Test
    public void shouldIncludeSampleOnCorrectPopulator() {
        Value[][] values = FusionIndexTestHelp.valuesByGroup();
        for (int activeSlot : fusionVersion.aliveSlots()) {
            this.verifySampleToCorrectPopulator(values[activeSlot], this.populators[activeSlot]);
        }
    }

    private void verifySampleToCorrectPopulator(Value[] values, IndexPopulator populator) {
        for (Value value : values) {
            IndexEntryUpdate<LabelSchemaDescriptor> update = FusionIndexTestHelp.add(value);
            this.fusionIndexPopulator.includeSample(update);
            ((IndexPopulator)Mockito.verify((Object)populator)).includeSample(update);
            Mockito.reset((Object[])new IndexPopulator[]{populator});
        }
    }

    private IndexPopulator orLucene(IndexPopulator populator) {
        return populator != IndexPopulator.EMPTY ? populator : this.populators[4];
    }
}

