/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.util.ArrayList;
import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptorFactory;
import org.neo4j.kernel.impl.index.schema.NumberIndexProvider;
import org.neo4j.kernel.impl.index.schema.SpatialIndexProvider;
import org.neo4j.kernel.impl.index.schema.StringIndexProvider;
import org.neo4j.kernel.impl.index.schema.TemporalIndexProvider;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexProvider;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexSampler;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexTestHelp;
import org.neo4j.kernel.impl.index.schema.fusion.FusionVersion;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.storable.Value;

@RunWith(value=Parameterized.class)
public class FusionIndexProviderTest {
    private static final IndexProvider.Descriptor DESCRIPTOR = new IndexProvider.Descriptor("test-fusion", "1");
    private IndexProvider[] providers;
    private IndexProvider[] aliveProviders;
    private IndexProvider fusionIndexProvider;
    private FusionIndexProvider.Selector selector;
    @Parameterized.Parameter
    public static FusionVersion fusionVersion;
    @Rule
    public RandomRule random = new RandomRule();

    @Parameterized.Parameters(name="{0}")
    public static FusionVersion[] versions() {
        return new FusionVersion[]{FusionVersion.v00, FusionVersion.v10, FusionVersion.v20};
    }

    @Before
    public void setup() {
        this.selector = fusionVersion.selector();
        this.setupMocks();
    }

    @Test
    public void mustSelectCorrectTargetForAllGivenValueCombinations() {
        Value[][] values = FusionIndexTestHelp.valuesByGroup();
        Value[] allValues = FusionIndexTestHelp.allValues();
        for (int i = 0; i < values.length; ++i) {
            Value[] group;
            for (Value value : group = values[i]) {
                IndexProvider selected = (IndexProvider)this.selector.select((Object[])this.providers, new Value[]{value});
                Assert.assertSame((Object)this.orLucene(this.providers[i]), (Object)selected);
            }
        }
        for (Value firstValue : allValues) {
            for (Value secondValue : allValues) {
                IndexProvider selected = (IndexProvider)this.selector.select((Object[])this.providers, new Value[]{firstValue, secondValue});
                Assert.assertSame((Object)this.providers[4], (Object)selected);
            }
        }
    }

    @Test
    public void mustCombineSamples() {
        int sumIndexSize = 0;
        int sumUniqueValues = 0;
        int sumSampleSize = 0;
        IndexSample[] samples = new IndexSample[this.providers.length];
        for (int i = 0; i < samples.length; ++i) {
            int indexSize = this.random.nextInt(0, 1000000);
            int uniqueValues = this.random.nextInt(0, 1000000);
            int sampleSize = this.random.nextInt(0, 1000000);
            samples[i] = new IndexSample((long)indexSize, (long)uniqueValues, (long)sampleSize);
            sumIndexSize += indexSize;
            sumUniqueValues += uniqueValues;
            sumSampleSize += sampleSize;
        }
        IndexSample fusionSample = FusionIndexSampler.combineSamples((IndexSample[])samples);
        Assert.assertEquals((long)sumIndexSize, (long)fusionSample.indexSize());
        Assert.assertEquals((long)sumUniqueValues, (long)fusionSample.uniqueValues());
        Assert.assertEquals((long)sumSampleSize, (long)fusionSample.sampleSize());
    }

    @Test
    public void getPopulationFailureMustThrowIfNoFailure() {
        IllegalStateException failure = new IllegalStateException("not failed");
        for (IndexProvider provider : this.aliveProviders) {
            Mockito.when((Object)provider.getPopulationFailure(ArgumentMatchers.anyLong(), (SchemaIndexDescriptor)ArgumentMatchers.any(SchemaIndexDescriptor.class))).thenThrow(new Throwable[]{failure});
        }
        try {
            this.fusionIndexProvider.getPopulationFailure(0L, SchemaIndexDescriptorFactory.forLabel((int)0, (int[])new int[]{0}));
            Assert.fail((String)"Should have failed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void getPopulationFailureMustReportFailureWhenAnyFailed() {
        for (IndexProvider failingProvider : this.aliveProviders) {
            String failure = "failure";
            IllegalStateException exception = new IllegalStateException("not failed");
            for (IndexProvider provider : this.aliveProviders) {
                if (provider == failingProvider) {
                    Mockito.when((Object)provider.getPopulationFailure(ArgumentMatchers.anyLong(), (SchemaIndexDescriptor)ArgumentMatchers.any(SchemaIndexDescriptor.class))).thenReturn((Object)failure);
                    continue;
                }
                Mockito.when((Object)provider.getPopulationFailure(ArgumentMatchers.anyLong(), (SchemaIndexDescriptor)ArgumentMatchers.any(SchemaIndexDescriptor.class))).thenThrow(new Throwable[]{exception});
            }
            Assert.assertThat((Object)this.fusionIndexProvider.getPopulationFailure(0L, SchemaIndexDescriptorFactory.forLabel((int)0, (int[])new int[]{0})), (Matcher)CoreMatchers.containsString((String)failure));
        }
    }

    @Test
    public void getPopulationFailureMustReportFailureWhenMultipleFail() {
        ArrayList<String> failureMessages = new ArrayList<String>();
        for (IndexProvider aliveProvider : this.aliveProviders) {
            String failureMessage = "FAILURE[" + aliveProvider + "]";
            failureMessages.add(failureMessage);
            Mockito.when((Object)aliveProvider.getPopulationFailure(ArgumentMatchers.anyLong(), (SchemaIndexDescriptor)ArgumentMatchers.any(SchemaIndexDescriptor.class))).thenReturn((Object)failureMessage);
        }
        String populationFailure = this.fusionIndexProvider.getPopulationFailure(0L, SchemaIndexDescriptorFactory.forLabel((int)0, (int[])new int[]{0}));
        for (String failureMessage : failureMessages) {
            Assert.assertThat((Object)populationFailure, (Matcher)CoreMatchers.containsString((String)failureMessage));
        }
    }

    @Test
    public void shouldReportFailedIfAnyIsFailed() {
        IndexProvider provider = this.fusionIndexProvider;
        SchemaIndexDescriptor schemaIndexDescriptor = SchemaIndexDescriptorFactory.forLabel((int)1, (int[])new int[]{1});
        for (InternalIndexState state : InternalIndexState.values()) {
            for (IndexProvider failedProvider : this.aliveProviders) {
                for (IndexProvider aliveProvider : this.aliveProviders) {
                    this.setInitialState(aliveProvider, failedProvider == aliveProvider ? InternalIndexState.FAILED : state);
                }
                InternalIndexState initialState = provider.getInitialState(0L, schemaIndexDescriptor);
                Assert.assertEquals((Object)InternalIndexState.FAILED, (Object)initialState);
            }
        }
    }

    @Test
    public void shouldReportPopulatingIfAnyIsPopulating() {
        SchemaIndexDescriptor schemaIndexDescriptor = SchemaIndexDescriptorFactory.forLabel((int)1, (int[])new int[]{1});
        for (InternalIndexState state : (InternalIndexState[])ArrayUtil.array((Object[])new InternalIndexState[]{InternalIndexState.ONLINE, InternalIndexState.POPULATING})) {
            for (IndexProvider populatingProvider : this.aliveProviders) {
                for (IndexProvider aliveProvider : this.aliveProviders) {
                    this.setInitialState(aliveProvider, populatingProvider == aliveProvider ? InternalIndexState.POPULATING : state);
                }
                InternalIndexState initialState = this.fusionIndexProvider.getInitialState(0L, schemaIndexDescriptor);
                Assert.assertEquals((Object)InternalIndexState.POPULATING, (Object)initialState);
            }
        }
    }

    private void setupMocks() {
        int[] aliveSlots = fusionVersion.aliveSlots();
        this.aliveProviders = new IndexProvider[aliveSlots.length];
        this.providers = new IndexProvider[5];
        Arrays.fill(this.providers, IndexProvider.EMPTY);
        block7: for (int i = 0; i < aliveSlots.length; ++i) {
            switch (aliveSlots[i]) {
                case 0: {
                    IndexProvider string;
                    this.providers[0] = string = this.mockProvider(StringIndexProvider.class, "string");
                    this.aliveProviders[i] = string;
                    continue block7;
                }
                case 1: {
                    IndexProvider number;
                    this.providers[1] = number = this.mockProvider(NumberIndexProvider.class, "number");
                    this.aliveProviders[i] = number;
                    continue block7;
                }
                case 2: {
                    IndexProvider spatial;
                    this.providers[2] = spatial = this.mockProvider(SpatialIndexProvider.class, "spatial");
                    this.aliveProviders[i] = spatial;
                    continue block7;
                }
                case 3: {
                    IndexProvider temporal;
                    this.providers[3] = temporal = this.mockProvider(TemporalIndexProvider.class, "temporal");
                    this.aliveProviders[i] = temporal;
                    continue block7;
                }
                case 4: {
                    IndexProvider lucene;
                    this.providers[4] = lucene = this.mockProvider(IndexProvider.class, "lucene");
                    this.aliveProviders[i] = lucene;
                    continue block7;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
        this.fusionIndexProvider = new FusionIndexProvider(this.providers[0], this.providers[1], this.providers[2], this.providers[3], this.providers[4], fusionVersion.selector(), DESCRIPTOR, 10, IndexDirectoryStructure.NONE, (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class), false);
    }

    private IndexProvider mockProvider(Class<? extends IndexProvider> providerClass, String name) {
        IndexProvider mock = (IndexProvider)Mockito.mock(providerClass);
        Mockito.when((Object)mock.getProviderDescriptor()).thenReturn((Object)new IndexProvider.Descriptor(name, "1"));
        return mock;
    }

    private void setInitialState(IndexProvider mockedProvider, InternalIndexState state) {
        Mockito.when((Object)mockedProvider.getInitialState(ArgumentMatchers.anyLong(), (SchemaIndexDescriptor)ArgumentMatchers.any(SchemaIndexDescriptor.class))).thenReturn((Object)state);
    }

    private IndexProvider orLucene(IndexProvider provider) {
        return provider != IndexProvider.EMPTY ? provider : this.providers[4];
    }
}

