/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.util.ArrayQueueOutOfOrderSequence;
import org.neo4j.kernel.impl.util.OutOfOrderSequence;

public class ArrayQueueOutOfOrderSequenceTest {
    private final long[] EMPTY_META = new long[]{42L};

    @Test
    public void shouldExposeGapFreeSequenceSingleThreaded() {
        ArrayQueueOutOfOrderSequence sequence = new ArrayQueueOutOfOrderSequence(0L, 10, new long[1]);
        this.offer((OutOfOrderSequence)sequence, 1L, new long[]{1L});
        this.assertGet((OutOfOrderSequence)sequence, 1L, new long[]{1L});
        this.offer((OutOfOrderSequence)sequence, 2L, new long[]{2L});
        this.assertGet((OutOfOrderSequence)sequence, 2L, new long[]{2L});
        Assert.assertFalse((boolean)sequence.seen(4L, new long[]{3L}));
        sequence.offer(4L, new long[]{3L});
        this.assertGet((OutOfOrderSequence)sequence, 2L, new long[]{2L});
        this.offer((OutOfOrderSequence)sequence, 3L, new long[]{4L});
        this.assertGet((OutOfOrderSequence)sequence, 4L, new long[]{3L});
        this.offer((OutOfOrderSequence)sequence, 5L, new long[]{5L});
        this.assertGet((OutOfOrderSequence)sequence, 5L, new long[]{5L});
        this.offer((OutOfOrderSequence)sequence, 10L, new long[]{6L});
        this.offer((OutOfOrderSequence)sequence, 11L, new long[]{7L});
        this.offer((OutOfOrderSequence)sequence, 8L, new long[]{8L});
        this.offer((OutOfOrderSequence)sequence, 9L, new long[]{9L});
        this.offer((OutOfOrderSequence)sequence, 7L, new long[]{10L});
        this.assertGet((OutOfOrderSequence)sequence, 5L, new long[]{5L});
        this.offer((OutOfOrderSequence)sequence, 6L, new long[]{11L});
        this.assertGet((OutOfOrderSequence)sequence, 11L, new long[]{7L});
    }

    @Test
    public void shouldExtendArrayIfNeedBe() {
        ArrayQueueOutOfOrderSequence sequence = new ArrayQueueOutOfOrderSequence(0L, 5, new long[1]);
        this.offer((OutOfOrderSequence)sequence, 3L, new long[]{0L});
        this.offer((OutOfOrderSequence)sequence, 2L, new long[]{1L});
        this.offer((OutOfOrderSequence)sequence, 5L, new long[]{2L});
        this.offer((OutOfOrderSequence)sequence, 4L, new long[]{3L});
        this.offer((OutOfOrderSequence)sequence, 6L, new long[]{4L});
        this.offer((OutOfOrderSequence)sequence, 1L, new long[]{5L});
        this.assertGet((OutOfOrderSequence)sequence, 6L, new long[]{4L});
    }

    @Test
    public void shouldDealWithThisScenario() {
        ArrayQueueOutOfOrderSequence sequence = new ArrayQueueOutOfOrderSequence(0L, 5, new long[1]);
        Assert.assertTrue((boolean)this.offer((OutOfOrderSequence)sequence, 1L, new long[]{0L}));
        Assert.assertFalse((boolean)this.offer((OutOfOrderSequence)sequence, 3L, new long[]{0L}));
        Assert.assertFalse((boolean)this.offer((OutOfOrderSequence)sequence, 4L, new long[]{0L}));
        Assert.assertTrue((boolean)this.offer((OutOfOrderSequence)sequence, 2L, new long[]{0L}));
        Assert.assertFalse((boolean)this.offer((OutOfOrderSequence)sequence, 6L, new long[]{0L}));
        Assert.assertTrue((boolean)this.offer((OutOfOrderSequence)sequence, 5L, new long[]{0L}));
        Assert.assertFalse((boolean)this.offer((OutOfOrderSequence)sequence, 8L, new long[]{0L}));
        Assert.assertFalse((boolean)this.offer((OutOfOrderSequence)sequence, 9L, new long[]{0L}));
        Assert.assertFalse((boolean)this.offer((OutOfOrderSequence)sequence, 10L, new long[]{0L}));
        Assert.assertFalse((boolean)this.offer((OutOfOrderSequence)sequence, 11L, new long[]{0L}));
        Assert.assertFalse((boolean)this.offer((OutOfOrderSequence)sequence, 12L, new long[]{0L}));
        Assert.assertFalse((boolean)this.offer((OutOfOrderSequence)sequence, 13L, new long[]{0L}));
        Assert.assertFalse((boolean)this.offer((OutOfOrderSequence)sequence, 14L, new long[]{0L}));
        Assert.assertTrue((boolean)this.offer((OutOfOrderSequence)sequence, 7L, new long[]{0L}));
        this.assertGet((OutOfOrderSequence)sequence, 14L, new long[]{0L});
    }

    @Test
    public void shouldKeepItsCoolWhenMultipleThreadsAreHammeringIt() throws Exception {
        AtomicLong numberSource = new AtomicLong();
        ArrayQueueOutOfOrderSequence sequence = new ArrayQueueOutOfOrderSequence(numberSource.get(), 5, new long[1]);
        AtomicBoolean end = new AtomicBoolean();
        CountDownLatch startSignal = new CountDownLatch(1);
        Thread[] threads = new Thread[1];
        for (int i = 0; i < threads.length; ++i) {
            threads[i] = new Thread(() -> this.lambda$shouldKeepItsCoolWhenMultipleThreadsAreHammeringIt$0(startSignal, end, numberSource, (OutOfOrderSequence)sequence));
        }
        for (Thread thread : threads) {
            thread.start();
        }
        startSignal.countDown();
        while (numberSource.get() < 10000000L) {
            Thread.sleep(1L);
            Thread.yield();
        }
        end.set(true);
        for (Thread thread : threads) {
            thread.join();
        }
        long lastNumber = numberSource.get();
        this.assertGet((OutOfOrderSequence)sequence, lastNumber, new long[]{lastNumber + 2L});
    }

    @Test
    public void highestEverSeenTest() {
        ArrayQueueOutOfOrderSequence sequence = new ArrayQueueOutOfOrderSequence(0L, 5, this.EMPTY_META);
        Assert.assertEquals((long)0L, (long)sequence.highestEverSeen());
        sequence.offer(1L, this.EMPTY_META);
        Assert.assertEquals((long)1L, (long)sequence.highestEverSeen());
        sequence.offer(42L, this.EMPTY_META);
        Assert.assertEquals((long)42L, (long)sequence.highestEverSeen());
    }

    @Test
    public void shouldBeAbleToTimeoutWaitingForNumber() throws Exception {
        long timeout = 10L;
        ArrayQueueOutOfOrderSequence sequence = new ArrayQueueOutOfOrderSequence(3L, 5, this.EMPTY_META);
        long startTime = System.currentTimeMillis();
        try {
            sequence.await(4L, timeout);
            Assert.fail();
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        long endTime = System.currentTimeMillis();
        Assert.assertThat((Object)(endTime - startTime), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(timeout)));
    }

    @Test
    public void shouldBeAbleToReturnImmediatelyWhenNumberAvailable() throws Exception {
        ArrayQueueOutOfOrderSequence sequence = new ArrayQueueOutOfOrderSequence(4L, 5, this.EMPTY_META);
        sequence.await(4L, 0L);
    }

    @Test
    public void shouldBeNotifiedWhenNumberAvailable() throws Exception {
        Semaphore done = new Semaphore(0);
        ArrayQueueOutOfOrderSequence sequence = new ArrayQueueOutOfOrderSequence(3L, 5, this.EMPTY_META);
        Thread numberWaiter = new Thread(() -> ArrayQueueOutOfOrderSequenceTest.lambda$shouldBeNotifiedWhenNumberAvailable$1((OutOfOrderSequence)sequence, done));
        numberWaiter.start();
        Assert.assertFalse((boolean)done.tryAcquire(10L, TimeUnit.MILLISECONDS));
        sequence.offer(4L, this.EMPTY_META);
        Assert.assertFalse((boolean)done.tryAcquire(10L, TimeUnit.MILLISECONDS));
        sequence.offer(5L, this.EMPTY_META);
        Assert.assertTrue((boolean)done.tryAcquire(60000L, TimeUnit.MILLISECONDS));
        numberWaiter.join();
    }

    private boolean offer(OutOfOrderSequence sequence, long number, long[] meta) {
        Assert.assertFalse((boolean)sequence.seen(number, meta));
        boolean result = sequence.offer(number, meta);
        Assert.assertTrue((boolean)sequence.seen(number, meta));
        return result;
    }

    private void assertGet(OutOfOrderSequence sequence, long number, long[] meta) {
        long[] data = sequence.get();
        long[] expected = new long[meta.length + 1];
        expected[0] = number;
        System.arraycopy(meta, 0, expected, 1, meta.length);
        Assert.assertArrayEquals((long[])expected, (long[])data);
    }

    private void await(CountDownLatch latch) {
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void lambda$shouldBeNotifiedWhenNumberAvailable$1(OutOfOrderSequence sequence, Semaphore done) {
        try {
            sequence.await(5L, 60000L);
        }
        catch (InterruptedException | TimeoutException e) {
            Assert.fail((String)"Should not have thrown");
        }
        done.release();
    }

    private /* synthetic */ void lambda$shouldKeepItsCoolWhenMultipleThreadsAreHammeringIt$0(CountDownLatch startSignal, AtomicBoolean end, AtomicLong numberSource, OutOfOrderSequence sequence) {
        this.await(startSignal);
        while (!end.get()) {
            long number = numberSource.incrementAndGet();
            this.offer(sequence, number, new long[]{number + 2L});
        }
    }
}

