/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorPredicates;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.schema.DuplicateSchemaRuleException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.schema.constaints.IndexBackedConstraintDescriptor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptorFactory;
import org.neo4j.kernel.impl.api.index.inmemory.InMemoryIndexProviderFactory;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.SchemaStorage;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.record.ConstraintRule;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.storageengine.api.schema.SchemaRule;
import org.neo4j.test.GraphDatabaseServiceCleaner;
import org.neo4j.test.mockito.matcher.KernelExceptionUserMessageMatcher;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.ImpermanentDatabaseRule;

public class SchemaStorageTest {
    private static final String LABEL1 = "Label1";
    private static final String LABEL2 = "Label2";
    private static final String TYPE1 = "Type1";
    private static final String PROP1 = "prop1";
    private static final String PROP2 = "prop2";
    @ClassRule
    public static final DatabaseRule db = new ImpermanentDatabaseRule();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private static SchemaStorage storage;

    @BeforeClass
    public static void initStorage() throws Exception {
        try (Transaction transaction = db.beginTx();){
            TokenWrite tokenWrite = SchemaStorageTest.getTransaction().tokenWrite();
            tokenWrite.propertyKeyGetOrCreateForName(PROP1);
            tokenWrite.propertyKeyGetOrCreateForName(PROP2);
            tokenWrite.labelGetOrCreateForName(LABEL1);
            tokenWrite.labelGetOrCreateForName(LABEL2);
            tokenWrite.relationshipTypeGetOrCreateForName(TYPE1);
            transaction.success();
        }
        SchemaStore schemaStore = SchemaStorageTest.resolveDependency(RecordStorageEngine.class).testAccessNeoStores().getSchemaStore();
        storage = new SchemaStorage((RecordStore)schemaStore);
    }

    @Before
    public void clearSchema() {
        GraphDatabaseServiceCleaner.cleanupSchema((GraphDatabaseService)db);
    }

    @Test
    public void shouldReturnIndexRuleForLabelAndProperty() {
        SchemaStorageTest.createSchema(SchemaStorageTest.index(LABEL1, PROP1), SchemaStorageTest.index(LABEL1, PROP2), SchemaStorageTest.index(LABEL2, PROP1));
        IndexRule rule = storage.indexGetForSchema(this.indexDescriptor(LABEL1, PROP2));
        Assert.assertNotNull((Object)rule);
        this.assertRule(rule, LABEL1, PROP2, SchemaIndexDescriptor.Type.GENERAL);
    }

    @Test
    public void shouldReturnIndexRuleForLabelAndPropertyComposite() {
        String a = "a";
        String b = "b";
        String c = "c";
        String d = "d";
        String e = "e";
        String f = "f";
        SchemaStorageTest.createSchema(db -> db.schema().indexFor(Label.label((String)LABEL1)).on(a).on(b).on(c).on(d).on(e).on(f).create());
        IndexRule rule = storage.indexGetForSchema(SchemaIndexDescriptorFactory.forLabel((int)SchemaStorageTest.labelId(LABEL1), (int[])new int[]{this.propId(a), this.propId(b), this.propId(c), this.propId(d), this.propId(e), this.propId(f)}));
        Assert.assertNotNull((Object)rule);
        Assert.assertTrue((boolean)SchemaDescriptorPredicates.hasLabel((SchemaDescriptorSupplier)rule, (int)SchemaStorageTest.labelId(LABEL1)));
        Assert.assertTrue((boolean)SchemaDescriptorPredicates.hasProperty((SchemaDescriptorSupplier)rule, (int)this.propId(a)));
        Assert.assertTrue((boolean)SchemaDescriptorPredicates.hasProperty((SchemaDescriptorSupplier)rule, (int)this.propId(b)));
        Assert.assertTrue((boolean)SchemaDescriptorPredicates.hasProperty((SchemaDescriptorSupplier)rule, (int)this.propId(c)));
        Assert.assertTrue((boolean)SchemaDescriptorPredicates.hasProperty((SchemaDescriptorSupplier)rule, (int)this.propId(d)));
        Assert.assertTrue((boolean)SchemaDescriptorPredicates.hasProperty((SchemaDescriptorSupplier)rule, (int)this.propId(e)));
        Assert.assertTrue((boolean)SchemaDescriptorPredicates.hasProperty((SchemaDescriptorSupplier)rule, (int)this.propId(f)));
        Assert.assertEquals((Object)SchemaIndexDescriptor.Type.GENERAL, (Object)rule.getIndexDescriptor().type());
    }

    @Test
    public void shouldReturnIndexRuleForLabelAndVeryManyPropertiesComposite() {
        String[] props = "abcdefghijklmnopqrstuvwxyzABCDEFGHJILKMNOPQRSTUVWXYZ".split("\\B");
        SchemaStorageTest.createSchema(db -> {
            IndexCreator indexCreator = db.schema().indexFor(Label.label((String)LABEL1));
            for (String prop : props) {
                indexCreator = indexCreator.on(prop);
            }
            indexCreator.create();
        });
        IndexRule rule = storage.indexGetForSchema(SchemaIndexDescriptorFactory.forLabel((int)SchemaStorageTest.labelId(LABEL1), (int[])Arrays.stream(props).mapToInt(this::propId).toArray()));
        Assert.assertNotNull((Object)rule);
        Assert.assertTrue((boolean)SchemaDescriptorPredicates.hasLabel((SchemaDescriptorSupplier)rule, (int)SchemaStorageTest.labelId(LABEL1)));
        for (String prop : props) {
            Assert.assertTrue((boolean)SchemaDescriptorPredicates.hasProperty((SchemaDescriptorSupplier)rule, (int)this.propId(prop)));
        }
        Assert.assertEquals((Object)SchemaIndexDescriptor.Type.GENERAL, (Object)rule.getIndexDescriptor().type());
    }

    @Test
    public void shouldReturnNullIfIndexRuleForLabelAndPropertyDoesNotExist() {
        SchemaStorageTest.createSchema(SchemaStorageTest.index(LABEL1, PROP1));
        IndexRule rule = storage.indexGetForSchema(this.indexDescriptor(LABEL1, PROP2));
        Assert.assertNull((Object)rule);
    }

    @Test
    public void shouldListIndexRulesForLabelPropertyAndKind() {
        SchemaStorageTest.createSchema(SchemaStorageTest.uniquenessConstraint(LABEL1, PROP1), SchemaStorageTest.index(LABEL1, PROP2));
        IndexRule rule = storage.indexGetForSchema(this.uniqueIndexDescriptor(LABEL1, PROP1));
        Assert.assertNotNull((Object)rule);
        this.assertRule(rule, LABEL1, PROP1, SchemaIndexDescriptor.Type.UNIQUE);
    }

    @Test
    public void shouldListAllIndexRules() {
        SchemaStorageTest.createSchema(SchemaStorageTest.index(LABEL1, PROP1), SchemaStorageTest.index(LABEL1, PROP2), SchemaStorageTest.uniquenessConstraint(LABEL2, PROP1));
        Set listedRules = Iterators.asSet((Iterator)storage.indexesGetAll());
        HashSet<IndexRule> expectedRules = new HashSet<IndexRule>();
        expectedRules.add(this.makeIndexRule(0L, LABEL1, PROP1));
        expectedRules.add(this.makeIndexRule(1L, LABEL1, PROP2));
        expectedRules.add(this.makeIndexRuleForConstraint(2L, LABEL2, PROP1, 0L));
        Assert.assertEquals(expectedRules, (Object)listedRules);
    }

    @Test
    public void shouldReturnCorrectUniquenessRuleForLabelAndProperty() throws SchemaRuleNotFoundException, DuplicateSchemaRuleException {
        SchemaStorageTest.createSchema(SchemaStorageTest.uniquenessConstraint(LABEL1, PROP1), SchemaStorageTest.uniquenessConstraint(LABEL2, PROP1));
        ConstraintRule rule = storage.constraintsGetSingle((ConstraintDescriptor)ConstraintDescriptorFactory.uniqueForLabel((int)SchemaStorageTest.labelId(LABEL1), (int[])new int[]{this.propId(PROP1)}));
        Assert.assertNotNull((Object)rule);
        this.assertRule(rule, LABEL1, PROP1, ConstraintDescriptor.Type.UNIQUE);
    }

    @Test
    public void shouldThrowExceptionOnNodeRuleNotFound() throws DuplicateSchemaRuleException, SchemaRuleNotFoundException {
        TokenNameLookup tokenNameLookup = this.getDefaultTokenNameLookup();
        this.expectedException.expect(SchemaRuleNotFoundException.class);
        this.expectedException.expect(new KernelExceptionUserMessageMatcher(tokenNameLookup, "No node property existence constraint was found for :Label1(prop1)."));
        storage.constraintsGetSingle((ConstraintDescriptor)ConstraintDescriptorFactory.existsForLabel((int)SchemaStorageTest.labelId(LABEL1), (int[])new int[]{this.propId(PROP1)}));
    }

    @Test
    public void shouldThrowExceptionOnNodeDuplicateRuleFound() throws DuplicateSchemaRuleException, SchemaRuleNotFoundException {
        TokenNameLookup tokenNameLookup = this.getDefaultTokenNameLookup();
        SchemaStorage schemaStorageSpy = (SchemaStorage)Mockito.spy((Object)storage);
        Mockito.when((Object)schemaStorageSpy.loadAllSchemaRules((Predicate)ArgumentMatchers.any(), (Class)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)Iterators.iterator((Object[])new SchemaRule[]{this.getUniquePropertyConstraintRule(1L, LABEL1, PROP1), this.getUniquePropertyConstraintRule(2L, LABEL1, PROP1)}));
        this.expectedException.expect(DuplicateSchemaRuleException.class);
        this.expectedException.expect(new KernelExceptionUserMessageMatcher(tokenNameLookup, "Multiple uniqueness constraints found for :Label1(prop1)."));
        schemaStorageSpy.constraintsGetSingle((ConstraintDescriptor)ConstraintDescriptorFactory.uniqueForLabel((int)SchemaStorageTest.labelId(LABEL1), (int[])new int[]{this.propId(PROP1)}));
    }

    @Test
    public void shouldThrowExceptionOnRelationshipRuleNotFound() throws DuplicateSchemaRuleException, SchemaRuleNotFoundException {
        TokenNameLookup tokenNameLookup = this.getDefaultTokenNameLookup();
        this.expectedException.expect(SchemaRuleNotFoundException.class);
        this.expectedException.expect(new KernelExceptionUserMessageMatcher(tokenNameLookup, "No relationship property existence constraint was found for -[:Type1(prop1)]-."));
        storage.constraintsGetSingle((ConstraintDescriptor)ConstraintDescriptorFactory.existsForRelType((int)SchemaStorageTest.typeId(TYPE1), (int[])new int[]{this.propId(PROP1)}));
    }

    @Test
    public void shouldThrowExceptionOnRelationshipDuplicateRuleFound() throws DuplicateSchemaRuleException, SchemaRuleNotFoundException {
        TokenNameLookup tokenNameLookup = this.getDefaultTokenNameLookup();
        SchemaStorage schemaStorageSpy = (SchemaStorage)Mockito.spy((Object)storage);
        Mockito.when((Object)schemaStorageSpy.loadAllSchemaRules((Predicate)ArgumentMatchers.any(), (Class)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)Iterators.iterator((Object[])new SchemaRule[]{this.getRelationshipPropertyExistenceConstraintRule(1L, TYPE1, PROP1), this.getRelationshipPropertyExistenceConstraintRule(2L, TYPE1, PROP1)}));
        this.expectedException.expect(DuplicateSchemaRuleException.class);
        this.expectedException.expect(new KernelExceptionUserMessageMatcher(tokenNameLookup, "Multiple relationship property existence constraints found for -[:Type1(prop1)]-."));
        schemaStorageSpy.constraintsGetSingle((ConstraintDescriptor)ConstraintDescriptorFactory.existsForRelType((int)SchemaStorageTest.typeId(TYPE1), (int[])new int[]{this.propId(PROP1)}));
    }

    private TokenNameLookup getDefaultTokenNameLookup() {
        TokenNameLookup tokenNameLookup = (TokenNameLookup)Mockito.mock(TokenNameLookup.class);
        Mockito.when((Object)tokenNameLookup.labelGetName(SchemaStorageTest.labelId(LABEL1))).thenReturn((Object)LABEL1);
        Mockito.when((Object)tokenNameLookup.propertyKeyGetName(this.propId(PROP1))).thenReturn((Object)PROP1);
        Mockito.when((Object)tokenNameLookup.relationshipTypeGetName(SchemaStorageTest.typeId(TYPE1))).thenReturn((Object)TYPE1);
        return tokenNameLookup;
    }

    private void assertRule(IndexRule rule, String label, String propertyKey, SchemaIndexDescriptor.Type type) {
        Assert.assertTrue((boolean)SchemaDescriptorPredicates.hasLabel((SchemaDescriptorSupplier)rule, (int)SchemaStorageTest.labelId(label)));
        Assert.assertTrue((boolean)SchemaDescriptorPredicates.hasProperty((SchemaDescriptorSupplier)rule, (int)this.propId(propertyKey)));
        Assert.assertEquals((Object)type, (Object)rule.getIndexDescriptor().type());
    }

    private void assertRule(ConstraintRule rule, String label, String propertyKey, ConstraintDescriptor.Type type) {
        Assert.assertTrue((boolean)SchemaDescriptorPredicates.hasLabel((SchemaDescriptorSupplier)rule, (int)SchemaStorageTest.labelId(label)));
        Assert.assertTrue((boolean)SchemaDescriptorPredicates.hasProperty((SchemaDescriptorSupplier)rule, (int)this.propId(propertyKey)));
        Assert.assertEquals((Object)type, (Object)rule.getConstraintDescriptor().type());
    }

    private SchemaIndexDescriptor indexDescriptor(String label, String property) {
        return SchemaIndexDescriptorFactory.forLabel((int)SchemaStorageTest.labelId(label), (int[])new int[]{this.propId(property)});
    }

    private SchemaIndexDescriptor uniqueIndexDescriptor(String label, String property) {
        return SchemaIndexDescriptorFactory.uniqueForLabel((int)SchemaStorageTest.labelId(label), (int[])new int[]{this.propId(property)});
    }

    private IndexRule makeIndexRule(long ruleId, String label, String propertyKey) {
        return IndexRule.indexRule((long)ruleId, (SchemaIndexDescriptor)SchemaIndexDescriptorFactory.forLabel((int)SchemaStorageTest.labelId(label), (int[])new int[]{this.propId(propertyKey)}), (IndexProvider.Descriptor)InMemoryIndexProviderFactory.PROVIDER_DESCRIPTOR);
    }

    private IndexRule makeIndexRuleForConstraint(long ruleId, String label, String propertyKey, long constraintId) {
        return IndexRule.constraintIndexRule((long)ruleId, (SchemaIndexDescriptor)SchemaIndexDescriptorFactory.uniqueForLabel((int)SchemaStorageTest.labelId(label), (int[])new int[]{this.propId(propertyKey)}), (IndexProvider.Descriptor)InMemoryIndexProviderFactory.PROVIDER_DESCRIPTOR, (Long)constraintId);
    }

    private ConstraintRule getUniquePropertyConstraintRule(long id, String label, String property) {
        return ConstraintRule.constraintRule((long)id, (IndexBackedConstraintDescriptor)ConstraintDescriptorFactory.uniqueForLabel((int)SchemaStorageTest.labelId(label), (int[])new int[]{this.propId(property)}), (long)0L);
    }

    private ConstraintRule getRelationshipPropertyExistenceConstraintRule(long id, String type, String property) {
        return ConstraintRule.constraintRule((long)id, (ConstraintDescriptor)ConstraintDescriptorFactory.existsForRelType((int)SchemaStorageTest.typeId(type), (int[])new int[]{this.propId(property)}));
    }

    private static int labelId(String labelName) {
        try (Transaction ignore = db.beginTx();){
            int n = SchemaStorageTest.getTransaction().tokenRead().nodeLabel(labelName);
            return n;
        }
    }

    private int propId(String propName) {
        try (Transaction ignore = db.beginTx();){
            int n = SchemaStorageTest.getTransaction().tokenRead().propertyKey(propName);
            return n;
        }
    }

    private static int typeId(String typeName) {
        try (Transaction ignore = db.beginTx();){
            int n = SchemaStorageTest.getTransaction().tokenRead().relationshipType(typeName);
            return n;
        }
    }

    private static KernelTransaction getTransaction() {
        return SchemaStorageTest.resolveDependency(ThreadToStatementContextBridge.class).getKernelTransactionBoundToThisThread(true);
    }

    private static <T> T resolveDependency(Class<T> clazz) {
        return (T)db.getGraphDatabaseAPI().getDependencyResolver().resolveDependency(clazz);
    }

    private static Consumer<GraphDatabaseService> index(String label, String prop) {
        return db -> db.schema().indexFor(Label.label((String)label)).on(prop).create();
    }

    private static Consumer<GraphDatabaseService> uniquenessConstraint(String label, String prop) {
        return db -> db.schema().constraintFor(Label.label((String)label)).assertPropertyIsUnique(prop).create();
    }

    @SafeVarargs
    private static void createSchema(Consumer<GraphDatabaseService> ... creators) {
        try (Transaction tx = db.beginTx();){
            for (Consumer<GraphDatabaseService> rule : creators) {
                rule.accept((GraphDatabaseService)db);
            }
            tx.success();
        }
        SchemaStorageTest.awaitIndexes();
    }

    private static void awaitIndexes() {
        try (Transaction tx = db.beginTx();){
            db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.success();
        }
    }
}

