/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.participant;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.NullLogService;
import org.neo4j.kernel.impl.logging.SimpleLogService;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.TransactionId;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.standard.Standard;
import org.neo4j.kernel.impl.store.format.standard.StandardV2_3;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.storemigration.MigrationTestUtils;
import org.neo4j.kernel.impl.storemigration.StoreVersionCheck;
import org.neo4j.kernel.impl.storemigration.UpgradableDatabase;
import org.neo4j.kernel.impl.storemigration.monitoring.SilentMigrationProgressMonitor;
import org.neo4j.kernel.impl.storemigration.participant.CountsMigrator;
import org.neo4j.kernel.impl.storemigration.participant.StoreMigrator;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.kernel.recovery.LogTailScanner;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

@RunWith(value=Parameterized.class)
public class StoreMigratorIT {
    private final TestDirectory directory = TestDirectory.testDirectory();
    private final PageCacheRule pageCacheRule = new PageCacheRule();
    private final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    private static final Config CONFIG = Config.defaults((Setting)GraphDatabaseSettings.pagecache_memory, (String)"8m");
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.directory).around((TestRule)this.fileSystemRule).around((TestRule)this.pageCacheRule);
    private final AssertableLogProvider logProvider = new AssertableLogProvider(true);
    private final LogService logService = new SimpleLogService((LogProvider)this.logProvider);
    private final Monitors monitors = new Monitors();
    private final FileSystemAbstraction fs = this.fileSystemRule.get();
    @Parameterized.Parameter(value=0)
    public String version;
    @Parameterized.Parameter(value=1)
    public LogPosition expectedLogPosition;
    @Parameterized.Parameter(value=2)
    public Function<TransactionId, Boolean> txIdComparator;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> versions() {
        return Arrays.asList(new Object[][]{{StandardV2_3.STORE_VERSION, new LogPosition(3L, 169L), StoreMigratorIT.txInfoAcceptanceOnIdAndTimestamp(39L, 1L)}});
    }

    private static Function<TransactionId, Boolean> txInfoAcceptanceOnIdAndTimestamp(long id, long timestamp) {
        return txInfo -> txInfo.transactionId() == id && txInfo.commitTimestamp() == timestamp;
    }

    @Test
    public void shouldBeAbleToResumeMigrationOnMoving() throws Exception {
        File storeDirectory = this.directory.graphDbDir();
        File prepare = this.directory.directory("prepare");
        MigrationTestUtils.prepareSampleLegacyDatabase(this.version, this.fs, storeDirectory, prepare);
        NullLogService logService = NullLogService.getInstance();
        PageCache pageCache = this.pageCacheRule.getPageCache(this.fs);
        LogTailScanner tailScanner = this.getTailScanner(storeDirectory);
        UpgradableDatabase upgradableDatabase = this.getUpgradableDatabase(pageCache, tailScanner);
        String versionToMigrateFrom = upgradableDatabase.checkUpgradeable(storeDirectory).storeVersion();
        SilentMigrationProgressMonitor progressMonitor = new SilentMigrationProgressMonitor();
        StoreMigrator migrator = new StoreMigrator(this.fs, pageCache, CONFIG, (LogService)logService);
        CountsMigrator countsMigrator = new CountsMigrator(this.fs, pageCache, CONFIG);
        File migrationDir = new File(storeDirectory, "upgrade");
        this.fs.mkdirs(migrationDir);
        migrator.migrate(storeDirectory, migrationDir, progressMonitor.startSection("section"), versionToMigrateFrom, upgradableDatabase.currentVersion());
        countsMigrator.migrate(storeDirectory, migrationDir, progressMonitor.startSection("section"), versionToMigrateFrom, upgradableDatabase.currentVersion());
        migrator = new StoreMigrator(this.fs, pageCache, CONFIG, (LogService)logService);
        countsMigrator = new CountsMigrator(this.fs, pageCache, CONFIG);
        migrator.moveMigratedFiles(migrationDir, storeDirectory, versionToMigrateFrom, upgradableDatabase.currentVersion());
        countsMigrator.moveMigratedFiles(migrationDir, storeDirectory, versionToMigrateFrom, upgradableDatabase.currentVersion());
        StoreFactory storeFactory = new StoreFactory(storeDirectory, CONFIG, (IdGeneratorFactory)new DefaultIdGeneratorFactory(this.fs), pageCache, this.fs, logService.getInternalLogProvider(), EmptyVersionContextSupplier.EMPTY);
        storeFactory.openAllNeoStores().close();
    }

    @Test
    public void shouldBeAbleToMigrateWithoutErrors() throws Exception {
        File storeDirectory = this.directory.graphDbDir();
        File prepare = this.directory.directory("prepare");
        MigrationTestUtils.prepareSampleLegacyDatabase(this.version, this.fs, storeDirectory, prepare);
        AssertableLogProvider logProvider = new AssertableLogProvider(true);
        SimpleLogService logService = new SimpleLogService((LogProvider)logProvider, (LogProvider)logProvider);
        PageCache pageCache = this.pageCacheRule.getPageCache(this.fs);
        LogTailScanner tailScanner = this.getTailScanner(storeDirectory);
        UpgradableDatabase upgradableDatabase = this.getUpgradableDatabase(pageCache, tailScanner);
        String versionToMigrateFrom = upgradableDatabase.checkUpgradeable(storeDirectory).storeVersion();
        SilentMigrationProgressMonitor progressMonitor = new SilentMigrationProgressMonitor();
        StoreMigrator migrator = new StoreMigrator(this.fs, pageCache, CONFIG, (LogService)logService);
        CountsMigrator countsMigrator = new CountsMigrator(this.fs, pageCache, CONFIG);
        File migrationDir = new File(storeDirectory, "upgrade");
        this.fs.mkdirs(migrationDir);
        migrator.migrate(storeDirectory, migrationDir, progressMonitor.startSection("section"), versionToMigrateFrom, upgradableDatabase.currentVersion());
        countsMigrator.migrate(storeDirectory, migrationDir, progressMonitor.startSection("section"), versionToMigrateFrom, upgradableDatabase.currentVersion());
        migrator.moveMigratedFiles(migrationDir, storeDirectory, versionToMigrateFrom, upgradableDatabase.currentVersion());
        countsMigrator.moveMigratedFiles(migrationDir, storeDirectory, versionToMigrateFrom, upgradableDatabase.currentVersion());
        StoreFactory storeFactory = new StoreFactory(storeDirectory, CONFIG, (IdGeneratorFactory)new DefaultIdGeneratorFactory(this.fs), pageCache, this.fs, logService.getInternalLogProvider(), EmptyVersionContextSupplier.EMPTY);
        storeFactory.openAllNeoStores().close();
        logProvider.assertNoLogCallContaining("ERROR");
    }

    @Test
    public void shouldBeAbleToResumeMigrationOnRebuildingCounts() throws Exception {
        File storeDirectory = this.directory.graphDbDir();
        File prepare = this.directory.directory("prepare");
        MigrationTestUtils.prepareSampleLegacyDatabase(this.version, this.fs, storeDirectory, prepare);
        NullLogService logService = NullLogService.getInstance();
        PageCache pageCache = this.pageCacheRule.getPageCache(this.fs);
        LogTailScanner tailScanner = this.getTailScanner(storeDirectory);
        UpgradableDatabase upgradableDatabase = this.getUpgradableDatabase(pageCache, tailScanner);
        String versionToMigrateFrom = upgradableDatabase.checkUpgradeable(storeDirectory).storeVersion();
        SilentMigrationProgressMonitor progressMonitor = new SilentMigrationProgressMonitor();
        StoreMigrator migrator = new StoreMigrator(this.fs, pageCache, CONFIG, (LogService)logService);
        File migrationDir = new File(storeDirectory, "upgrade");
        this.fs.mkdirs(migrationDir);
        migrator.migrate(storeDirectory, migrationDir, progressMonitor.startSection("section"), versionToMigrateFrom, upgradableDatabase.currentVersion());
        progressMonitor = new SilentMigrationProgressMonitor();
        CountsMigrator countsMigrator = new CountsMigrator(this.fs, pageCache, CONFIG);
        countsMigrator.migrate(storeDirectory, migrationDir, progressMonitor.startSection("section"), versionToMigrateFrom, upgradableDatabase.currentVersion());
        migrator.moveMigratedFiles(migrationDir, storeDirectory, versionToMigrateFrom, upgradableDatabase.currentVersion());
        countsMigrator.moveMigratedFiles(migrationDir, storeDirectory, versionToMigrateFrom, upgradableDatabase.currentVersion());
        StoreFactory storeFactory = new StoreFactory(storeDirectory, CONFIG, (IdGeneratorFactory)new DefaultIdGeneratorFactory(this.fs), pageCache, this.fs, logService.getInternalLogProvider(), EmptyVersionContextSupplier.EMPTY);
        storeFactory.openAllNeoStores().close();
    }

    @Test
    public void shouldComputeTheLastTxLogPositionCorrectly() throws Throwable {
        File storeDirectory = this.directory.graphDbDir();
        File prepare = this.directory.directory("prepare");
        MigrationTestUtils.prepareSampleLegacyDatabase(this.version, this.fs, storeDirectory, prepare);
        NullLogService logService = NullLogService.getInstance();
        PageCache pageCache = this.pageCacheRule.getPageCache(this.fs);
        LogTailScanner tailScanner = this.getTailScanner(storeDirectory);
        UpgradableDatabase upgradableDatabase = this.getUpgradableDatabase(pageCache, tailScanner);
        String versionToMigrateFrom = upgradableDatabase.checkUpgradeable(storeDirectory).storeVersion();
        SilentMigrationProgressMonitor progressMonitor = new SilentMigrationProgressMonitor();
        StoreMigrator migrator = new StoreMigrator(this.fs, pageCache, CONFIG, (LogService)logService);
        File migrationDir = new File(storeDirectory, "upgrade");
        this.fs.mkdirs(migrationDir);
        migrator.migrate(storeDirectory, migrationDir, progressMonitor.startSection("section"), versionToMigrateFrom, upgradableDatabase.currentVersion());
        Assert.assertEquals((Object)this.expectedLogPosition, (Object)migrator.readLastTxLogPosition(migrationDir));
    }

    @Test
    public void shouldComputeTheLastTxInfoCorrectly() throws Exception {
        File storeDirectory = this.directory.graphDbDir();
        File prepare = this.directory.directory("prepare");
        MigrationTestUtils.prepareSampleLegacyDatabase(this.version, this.fs, storeDirectory, prepare);
        NullLogService logService = NullLogService.getInstance();
        PageCache pageCache = this.pageCacheRule.getPageCache(this.fs);
        LogTailScanner tailScanner = this.getTailScanner(storeDirectory);
        UpgradableDatabase upgradableDatabase = this.getUpgradableDatabase(pageCache, tailScanner);
        String versionToMigrateFrom = upgradableDatabase.checkUpgradeable(storeDirectory).storeVersion();
        SilentMigrationProgressMonitor progressMonitor = new SilentMigrationProgressMonitor();
        StoreMigrator migrator = new StoreMigrator(this.fs, pageCache, CONFIG, (LogService)logService);
        File migrationDir = new File(storeDirectory, "upgrade");
        this.fs.mkdir(migrationDir);
        migrator.migrate(storeDirectory, migrationDir, progressMonitor.startSection("section"), versionToMigrateFrom, upgradableDatabase.currentVersion());
        Assert.assertTrue((boolean)this.txIdComparator.apply(migrator.readLastTxInformation(migrationDir)));
    }

    private UpgradableDatabase getUpgradableDatabase(PageCache pageCache, LogTailScanner tailScanner) {
        return new UpgradableDatabase(new StoreVersionCheck(pageCache), this.selectFormat(), tailScanner);
    }

    private LogTailScanner getTailScanner(File storeDirectory) throws IOException {
        LogFiles logFiles = LogFilesBuilder.logFilesBasedOnlyBuilder((File)storeDirectory, (FileSystemAbstraction)this.fs).build();
        return new LogTailScanner(logFiles, (LogEntryReader)new VersionAwareLogEntryReader(), this.monitors);
    }

    private RecordFormats selectFormat() {
        return Standard.LATEST_RECORD_FORMATS;
    }
}

