/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.kernel.impl.util.Validators;
import org.neo4j.test.rule.TestDirectory;

public class ValidatorsTest {
    @Rule
    public final TestDirectory directory = TestDirectory.testDirectory();

    @Test
    public void shouldFindFilesByRegex() throws Exception {
        this.existenceOfFile("abc");
        this.existenceOfFile("bcd");
        this.assertValid("abc");
        this.assertValid("bcd");
        this.assertValid("ab.");
        this.assertValid(".*bc");
        this.assertNotValid("abcd");
        this.assertNotValid(".*de.*");
    }

    @Test
    public void shouldValidateInList() {
        try {
            Validators.inList((String[])new String[]{"foo", "bar", "baz"}).validate((Object)"qux");
            Assert.fail((String)"Should have failed to find item in list.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"'qux' found but must be one of: [foo, bar, baz]."));
        }
        try {
            Validators.inList((String[])new String[]{"foo", "bar", "baz"}).validate((Object)"bar");
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)"Should have found item in list.");
        }
    }

    private void assertNotValid(String string) {
        try {
            this.validate(string);
            Assert.fail((String)"Should have failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void assertValid(String fileByName) {
        this.validate(fileByName);
    }

    private void validate(String fileByName) {
        Validators.REGEX_FILE_EXISTS.validate((Object)this.directory.file(fileByName));
    }

    private void existenceOfFile(String name) throws IOException {
        this.directory.file(name).createNewFile();
    }
}

