/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.function.Predicate;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;

public class LogTestUtils {
    private LogTestUtils() {
    }

    public static File[] filterNeostoreLogicalLog(LogFiles logFiles, FileSystemAbstraction fileSystem, LogHook<LogEntry> filter) throws IOException {
        File[] files;
        for (File file : files = logFiles.logFiles()) {
            LogTestUtils.filterTransactionLogFile(fileSystem, file, filter);
        }
        return files;
    }

    static void filterTransactionLogFile(FileSystemAbstraction fileSystem, File file, LogHook<LogEntry> filter) throws IOException {
        filter.file(file);
        try (StoreChannel in = fileSystem.open(file, OpenMode.READ);){
            LogEntry entry;
            LogHeader logHeader = LogHeaderReader.readLogHeader((ByteBuffer)ByteBuffer.allocate(16), (ReadableByteChannel)in, (boolean)true, (File)file);
            PhysicalLogVersionedStoreChannel inChannel = new PhysicalLogVersionedStoreChannel(in, logHeader.logVersion, logHeader.logFormatVersion);
            ReadAheadLogChannel inBuffer = new ReadAheadLogChannel((LogVersionedStoreChannel)inChannel);
            VersionAwareLogEntryReader entryReader = new VersionAwareLogEntryReader();
            while ((entry = entryReader.readLogEntry((ReadableClosablePositionAwareChannel)inBuffer)) != null) {
                filter.test(entry);
            }
        }
    }

    public static class CountingLogHook<RECORD>
    extends LogHookAdapter<RECORD> {
        private int count;

        @Override
        public boolean test(RECORD item) {
            ++this.count;
            return true;
        }

        public int getCount() {
            return this.count;
        }
    }

    public static abstract class LogHookAdapter<RECORD>
    implements LogHook<RECORD> {
        @Override
        public void file(File file) {
        }

        @Override
        public void done(File file) {
        }
    }

    public static interface LogHook<RECORD>
    extends Predicate<RECORD> {
        public void file(File var1);

        public void done(File var1);
    }
}

