/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.concurrent.Runnables;
import org.neo4j.test.Race;

public class RaceTest {
    @Test
    public void shouldWaitForAllContestantsToComplete() throws Throwable {
        Race race = new Race();
        AtomicInteger completed = new AtomicInteger();
        int count = 5;
        race.addContestants(count, Race.throwing(() -> {
            Thread.sleep(ThreadLocalRandom.current().nextInt(100));
            completed.incrementAndGet();
        }));
        race.go();
        Assert.assertEquals((long)count, (long)completed.get());
    }

    @Test
    public void shouldConsultEndCondition() throws Throwable {
        CallCountBooleanSupplier endCondition = new CallCountBooleanSupplier(100);
        Race race = new Race().withEndCondition(new BooleanSupplier[]{endCondition});
        race.addContestants(20, Race.throwing(() -> Thread.sleep(10L)));
        race.go();
        Assert.assertTrue((endCondition.callCount.get() >= 100 ? 1 : 0) != 0);
    }

    @Test
    public void shouldHaveMultipleEndConditions() throws Throwable {
        ControlledBooleanSupplier endCondition1 = (ControlledBooleanSupplier)Mockito.spy((Object)new ControlledBooleanSupplier(false));
        ControlledBooleanSupplier endCondition2 = (ControlledBooleanSupplier)Mockito.spy((Object)new ControlledBooleanSupplier(false));
        ControlledBooleanSupplier endCondition3 = (ControlledBooleanSupplier)Mockito.spy((Object)new ControlledBooleanSupplier(false));
        Race race = new Race().withEndCondition(new BooleanSupplier[]{endCondition1, endCondition2, endCondition3});
        race.addContestant(() -> endCondition2.set(true));
        race.addContestants(3, Runnables.EMPTY_RUNNABLE);
        race.go();
        ((ControlledBooleanSupplier)Mockito.verify((Object)endCondition1, (VerificationMode)Mockito.atLeast((int)4))).getAsBoolean();
        ((ControlledBooleanSupplier)Mockito.verify((Object)endCondition2, (VerificationMode)Mockito.atLeast((int)4))).getAsBoolean();
    }

    @Test
    public void shouldBreakOnError() throws Throwable {
        String error = "Noooo";
        Race race = new Race();
        race.withEndCondition(new BooleanSupplier[]{() -> false});
        race.addContestant(() -> {
            throw new RuntimeException(error);
        });
        race.addContestants(3, () -> {});
        try {
            race.go();
            Assert.fail((String)"Should've failed ");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)error, (Object)e.getMessage());
        }
    }

    public static class CallCountBooleanSupplier
    implements BooleanSupplier {
        private final int callCountTriggeringTrueEndCondition;
        private final AtomicInteger callCount = new AtomicInteger();

        public CallCountBooleanSupplier(int callCountTriggeringTrueEndCondition) {
            this.callCountTriggeringTrueEndCondition = callCountTriggeringTrueEndCondition;
        }

        @Override
        public boolean getAsBoolean() {
            return this.callCount.incrementAndGet() >= this.callCountTriggeringTrueEndCondition;
        }
    }

    public static class ControlledBooleanSupplier
    implements BooleanSupplier {
        private volatile boolean value;

        public ControlledBooleanSupplier(boolean initialValue) {
            this.value = initialValue;
        }

        public void set(boolean value) {
            this.value = value;
        }

        @Override
        public boolean getAsBoolean() {
            return this.value;
        }
    }
}

