/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.unsafe.impl.batchimport.cache.ByteArray;
import org.neo4j.unsafe.impl.batchimport.cache.HeapByteArray;
import org.neo4j.unsafe.impl.batchimport.cache.HeapIntArray;
import org.neo4j.unsafe.impl.batchimport.cache.HeapLongArray;
import org.neo4j.unsafe.impl.batchimport.cache.IntArray;
import org.neo4j.unsafe.impl.batchimport.cache.LongArray;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;

public class NumberArrayFactoryTest {
    private static final long KILO = 1024L;

    @Test
    public void shouldPickFirstAvailableCandidateLongArray() {
        NumberArrayFactory.Auto factory = new NumberArrayFactory.Auto(new NumberArrayFactory[]{NumberArrayFactory.HEAP});
        LongArray array = factory.newLongArray(1024L, -1L);
        array.set(1014L, 12345L);
        Assert.assertTrue((boolean)(array instanceof HeapLongArray));
        Assert.assertEquals((long)12345L, (long)array.get(1014L));
    }

    @Test
    public void shouldPickFirstAvailableCandidateLongArrayWhenSomeDontHaveEnoughMemory() {
        NumberArrayFactory lowMemoryFactory = (NumberArrayFactory)Mockito.mock(NumberArrayFactory.class);
        ((NumberArrayFactory)Mockito.doThrow(OutOfMemoryError.class).when((Object)lowMemoryFactory)).newLongArray(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
        NumberArrayFactory.Auto factory = new NumberArrayFactory.Auto(new NumberArrayFactory[]{lowMemoryFactory, NumberArrayFactory.HEAP});
        LongArray array = factory.newLongArray(1024L, -1L);
        array.set(1014L, 12345L);
        ((NumberArrayFactory)Mockito.verify((Object)lowMemoryFactory, (VerificationMode)Mockito.times((int)1))).newLongArray(1024L, -1L, 0L);
        Assert.assertTrue((boolean)(array instanceof HeapLongArray));
        Assert.assertEquals((long)12345L, (long)array.get(1014L));
    }

    @Test
    public void shouldThrowOomOnNotEnoughMemory() {
        NumberArrayFactory lowMemoryFactory = (NumberArrayFactory)Mockito.mock(NumberArrayFactory.class);
        ((NumberArrayFactory)Mockito.doThrow(OutOfMemoryError.class).when((Object)lowMemoryFactory)).newLongArray(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
        NumberArrayFactory.Auto factory = new NumberArrayFactory.Auto(new NumberArrayFactory[]{lowMemoryFactory});
        try {
            factory.newLongArray(1024L, -1L);
            Assert.fail((String)"Should have thrown");
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
    }

    @Test
    public void shouldPickFirstAvailableCandidateIntArray() {
        NumberArrayFactory.Auto factory = new NumberArrayFactory.Auto(new NumberArrayFactory[]{NumberArrayFactory.HEAP});
        IntArray array = factory.newIntArray(1024L, -1);
        array.set(1014L, 12345);
        Assert.assertTrue((boolean)(array instanceof HeapIntArray));
        Assert.assertEquals((long)12345L, (long)array.get(1014L));
    }

    @Test
    public void shouldPickFirstAvailableCandidateIntArrayWhenSomeDontHaveEnoughMemory() {
        NumberArrayFactory lowMemoryFactory = (NumberArrayFactory)Mockito.mock(NumberArrayFactory.class);
        ((NumberArrayFactory)Mockito.doThrow(OutOfMemoryError.class).when((Object)lowMemoryFactory)).newIntArray(ArgumentMatchers.anyLong(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyLong());
        NumberArrayFactory.Auto factory = new NumberArrayFactory.Auto(new NumberArrayFactory[]{lowMemoryFactory, NumberArrayFactory.HEAP});
        IntArray array = factory.newIntArray(1024L, -1);
        array.set(1014L, 12345);
        ((NumberArrayFactory)Mockito.verify((Object)lowMemoryFactory, (VerificationMode)Mockito.times((int)1))).newIntArray(1024L, -1, 0L);
        Assert.assertTrue((boolean)(array instanceof HeapIntArray));
        Assert.assertEquals((long)12345L, (long)array.get(1014L));
    }

    @Test
    public void shouldEvenCatchOtherExceptionsAndTryNext() {
        NumberArrayFactory throwingMemoryFactory = (NumberArrayFactory)Mockito.mock(NumberArrayFactory.class);
        ((NumberArrayFactory)Mockito.doThrow(ArithmeticException.class).when((Object)throwingMemoryFactory)).newByteArray(ArgumentMatchers.anyLong(), (byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.anyLong());
        NumberArrayFactory.Auto factory = new NumberArrayFactory.Auto(new NumberArrayFactory[]{throwingMemoryFactory, NumberArrayFactory.HEAP});
        ByteArray array = factory.newByteArray(1024L, new byte[4], 0L);
        array.setInt(1014L, 0, 12345);
        ((NumberArrayFactory)Mockito.verify((Object)throwingMemoryFactory, (VerificationMode)Mockito.times((int)1))).newByteArray(ArgumentMatchers.eq((long)1024L), (byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.eq((long)0L));
        Assert.assertTrue((boolean)(array instanceof HeapByteArray));
        Assert.assertEquals((long)12345L, (long)array.getInt(1014L, 0));
    }

    @Test
    public void heapArrayShouldAllowVeryLargeBases() {
        NumberArrayFactory.Auto factory = new NumberArrayFactory.Auto(new NumberArrayFactory[]{NumberArrayFactory.HEAP});
        this.verifyVeryLargeBaseSupport((NumberArrayFactory)factory);
    }

    @Test
    public void offHeapArrayShouldAllowVeryLargeBases() {
        NumberArrayFactory.Auto factory = new NumberArrayFactory.Auto(new NumberArrayFactory[]{NumberArrayFactory.OFF_HEAP});
        this.verifyVeryLargeBaseSupport((NumberArrayFactory)factory);
    }

    private void verifyVeryLargeBaseSupport(NumberArrayFactory factory) {
        long base = 2871185636039L;
        byte[] into = new byte[]{1};
        factory.newByteArray(10L, new byte[1], base).get(base + 1L, into);
        Assert.assertThat((Object)into[0], (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)factory.newIntArray(10L, 1, base).get(base + 1L), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)factory.newLongArray(10L, 1L, base).get(base + 1L), (Matcher)Matchers.is((Object)1L));
    }
}

