/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import java.io.IOException;
import org.junit.Assert;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.unsafe.impl.batchimport.cache.ByteArray;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArray;
import org.neo4j.unsafe.impl.batchimport.cache.PageCacheByteArray;
import org.neo4j.unsafe.impl.batchimport.cache.PageCacheNumberArrayConcurrencyTest;

public class PageCacheByteArrayConcurrencyTest
extends PageCacheNumberArrayConcurrencyTest {
    @Override
    protected Runnable wholeFileRacer(NumberArray array, int contestant) {
        return new WholeFileRacer((ByteArray)array);
    }

    @Override
    protected Runnable fileRangeRacer(NumberArray array, int contestant) {
        return new FileRangeRacer((ByteArray)array, contestant);
    }

    protected ByteArray getNumberArray(PagedFile file) throws IOException {
        return new PageCacheByteArray(file, 100L, new byte[]{-1, -1, -1, -1}, 0L);
    }

    private class FileRangeRacer
    implements Runnable {
        private ByteArray array;
        private int contestant;

        FileRangeRacer(ByteArray array, int contestant) {
            this.array = array;
            this.contestant = contestant;
        }

        @Override
        public void run() {
            for (int o = 0; o < 2000; ++o) {
                for (int i = this.contestant; i < 100; i += 10) {
                    byte[] value = new byte[4];
                    byte[] actual = new byte[4];
                    PageCacheByteArrayConcurrencyTest.this.random.nextBytes(value);
                    this.array.set((long)i, value);
                    this.array.get((long)i, actual);
                    Assert.assertArrayEquals((byte[])value, (byte[])actual);
                }
            }
        }
    }

    private class WholeFileRacer
    implements Runnable {
        private ByteArray array;

        WholeFileRacer(ByteArray array) {
            this.array = array;
        }

        @Override
        public void run() {
            for (int o = 0; o < 2000; ++o) {
                for (int i = 0; i < 100; ++i) {
                    byte[] value = new byte[]{1, 2, 3, 4};
                    this.array.set((long)i, value);
                    byte[] actual = new byte[4];
                    this.array.get((long)i, actual);
                    Assert.assertArrayEquals((byte[])value, (byte[])actual);
                }
            }
        }
    }
}

