/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input.csv;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.collection.RawIterator;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.csv.reader.Extractor;
import org.neo4j.csv.reader.Extractors;
import org.neo4j.csv.reader.Readables;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.Collectors;
import org.neo4j.unsafe.impl.batchimport.input.Group;
import org.neo4j.unsafe.impl.batchimport.input.Groups;
import org.neo4j.unsafe.impl.batchimport.input.InputChunk;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityDecorators;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityVisitor;
import org.neo4j.unsafe.impl.batchimport.input.InputException;
import org.neo4j.unsafe.impl.batchimport.input.csv.Configuration;
import org.neo4j.unsafe.impl.batchimport.input.csv.CsvInput;
import org.neo4j.unsafe.impl.batchimport.input.csv.Data;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactories;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactory;
import org.neo4j.unsafe.impl.batchimport.input.csv.Decorator;
import org.neo4j.unsafe.impl.batchimport.input.csv.Header;
import org.neo4j.unsafe.impl.batchimport.input.csv.IdType;
import org.neo4j.unsafe.impl.batchimport.input.csv.Type;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Values;

@RunWith(value=Parameterized.class)
public class CsvInputTest {
    @Rule
    public final RandomRule random = new RandomRule();
    @Rule
    public final TestDirectory directory = TestDirectory.testDirectory(this.getClass());
    private final Extractors extractors = new Extractors(',');
    @Parameterized.Parameter
    public Boolean allowMultilineFields;
    private final InputEntity visitor = new InputEntity();
    private final Groups groups = new Groups();
    private InputChunk chunk;
    private InputIterator referenceData;

    @Parameterized.Parameters
    public static Collection<Boolean> data() {
        return Arrays.asList(Boolean.TRUE, Boolean.FALSE);
    }

    @Test
    public void shouldProvideNodesFromCsvInput() throws Exception {
        IdType idType = IdType.ACTUAL;
        Iterable<DataFactory> data = this.dataIterable(CsvInputTest.data("123,Mattias Persson,HACKER"));
        CsvInput input = new CsvInput(data, this.header(this.entry(null, Type.ID, idType.extractor(this.extractors)), this.entry("name", Type.PROPERTY, this.extractors.string()), this.entry("labels", Type.LABEL, this.extractors.string())), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), idType, this.config(Configuration.COMMAS), Collectors.silentBadCollector((long)0L));
        try (InputIterator nodes = input.nodes().iterator();){
            this.assertNextNode(nodes, 123L, this.properties("name", "Mattias Persson"), this.labels("HACKER"));
            Assert.assertFalse((boolean)this.chunk.next((InputEntityVisitor)this.visitor));
        }
    }

    @Test
    public void shouldProvideRelationshipsFromCsvInput() throws Exception {
        IdType idType = IdType.STRING;
        Iterable<DataFactory> data = this.dataIterable(CsvInputTest.data("node1,node2,KNOWS,1234567\nnode2,node10,HACKS,987654"));
        CsvInput input = new CsvInput(DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatNodeFileHeader(), data, this.header(this.entry("from", Type.START_ID, idType.extractor(this.extractors)), this.entry("to", Type.END_ID, idType.extractor(this.extractors)), this.entry("type", Type.TYPE, this.extractors.string()), this.entry("since", Type.PROPERTY, (Extractor<?>)this.extractors.long_())), idType, this.config(Configuration.COMMAS), Collectors.silentBadCollector((long)0L));
        try (InputIterator relationships = input.relationships().iterator();){
            this.assertNextRelationship(relationships, "node1", "node2", "KNOWS", this.properties("since", 1234567L));
            this.assertNextRelationship(relationships, "node2", "node10", "HACKS", this.properties("since", 987654L));
        }
    }

    @Test
    public void shouldCloseDataIteratorsInTheEnd() throws Exception {
        CapturingDataFactories nodeData = new CapturingDataFactories(config -> CsvInputTest.charReader("1"), InputEntityDecorators.NO_DECORATOR);
        CapturingDataFactories relationshipData = new CapturingDataFactories(config -> CsvInputTest.charReader("1,1"), InputEntityDecorators.defaultRelationshipType((String)"TYPE"));
        IdType idType = IdType.STRING;
        CsvInput input = new CsvInput((Iterable)nodeData, this.header(this.entry(null, Type.ID, idType.extractor(this.extractors))), (Iterable)relationshipData, this.header(this.entry(null, Type.START_ID, idType.extractor(this.extractors)), this.entry(null, Type.END_ID, idType.extractor(this.extractors))), idType, this.config(Configuration.COMMAS), Collectors.silentBadCollector((long)0L));
        try (InputIterator iterator = input.nodes().iterator();){
            this.readNext(iterator);
        }
        iterator = input.relationships().iterator();
        var6_6 = null;
        try {
            this.readNext(iterator);
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (iterator != null) {
                if (var6_6 != null) {
                    try {
                        iterator.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    iterator.close();
                }
            }
        }
        this.assertClosed(nodeData.last());
        this.assertClosed(relationshipData.last());
    }

    private void assertClosed(CharReadable reader) {
        try {
            reader.read(new char[1], 0, 1);
            Assert.fail((String)(reader + " not closed"));
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("closed"));
        }
    }

    @Test
    public void shouldCopeWithLinesThatHasTooFewValuesButStillValidates() throws Exception {
        Iterable<DataFactory> data = this.dataIterable(CsvInputTest.data("1,ultralisk,ZERG,10\n2,corruptor,ZERG\n3,mutalisk,ZERG,3"));
        CsvInput input = new CsvInput(data, this.header(this.entry(null, Type.ID, (Extractor<?>)this.extractors.long_()), this.entry("unit", Type.PROPERTY, this.extractors.string()), this.entry("type", Type.LABEL, this.extractors.string()), this.entry("kills", Type.PROPERTY, (Extractor<?>)this.extractors.int_())), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.ACTUAL, this.config(Configuration.COMMAS), Collectors.silentBadCollector((long)0L));
        try (InputIterator nodes = input.nodes().iterator();){
            this.assertNextNode(nodes, 1L, new Object[]{"unit", "ultralisk", "kills", 10}, this.labels("ZERG"));
            this.assertNextNode(nodes, 2L, new Object[]{"unit", "corruptor"}, this.labels("ZERG"));
            this.assertNextNode(nodes, 3L, new Object[]{"unit", "mutalisk", "kills", 3}, this.labels("ZERG"));
            Assert.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @Test
    public void shouldIgnoreValuesAfterHeaderEntries() throws Exception {
        Iterable<DataFactory> data = this.dataIterable(CsvInputTest.data("1,zergling,bubble,bobble\n2,scv,pun,intended"));
        CsvInput input = new CsvInput(data, this.header(this.entry(null, Type.ID, (Extractor<?>)this.extractors.long_()), this.entry("name", Type.PROPERTY, this.extractors.string())), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.ACTUAL, this.config(Configuration.COMMAS), Collectors.silentBadCollector((long)4L));
        try (InputIterator nodes = input.nodes().iterator();){
            this.assertNextNode(nodes, 1L, new Object[]{"name", "zergling"}, this.labels(new String[0]));
            this.assertNextNode(nodes, 2L, new Object[]{"name", "scv"}, this.labels(new String[0]));
            Assert.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @Test
    public void shouldHandleMultipleInputGroups() throws Exception {
        DataFactory group1 = CsvInputTest.data(":ID,name,kills:int,health:int\n1,Jim,10,100\n2,Abathur,0,200\n");
        DataFactory group2 = CsvInputTest.data(":ID,type\n3,zergling\n4,csv\n");
        Iterable<DataFactory> data = this.dataIterable(group1, group2);
        CsvInput input = new CsvInput(data, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.STRING, this.config(Configuration.COMMAS), Collectors.silentBadCollector((long)0L));
        try (InputIterator nodes = input.nodes().iterator();){
            this.assertNextNode(nodes, "1", this.properties("name", "Jim", "kills", 10, "health", 100), this.labels(new String[0]));
            this.assertNextNode(nodes, "2", this.properties("name", "Abathur", "kills", 0, "health", 200), this.labels(new String[0]));
            this.assertNextNode(nodes, "3", this.properties("type", "zergling"), this.labels(new String[0]));
            this.assertNextNode(nodes, "4", this.properties("type", "csv"), this.labels(new String[0]));
            Assert.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @Test
    public void shouldProvideAdditiveLabels() throws Exception {
        Object[] addedLabels = new String[]{"Two", "AddTwo"};
        DataFactory data = CsvInputTest.data(":ID,name,:LABEL\n0,First,\n1,Second,One\n2,Third,One;Two", InputEntityDecorators.additiveLabels((String[])addedLabels));
        Iterable<DataFactory> dataIterable = this.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.ACTUAL, this.config(Configuration.COMMAS), Collectors.silentBadCollector((long)0L));
        try (InputIterator nodes = input.nodes().iterator();){
            this.assertNextNode(nodes, 0L, this.properties("name", "First"), this.labels((String[])addedLabels));
            this.assertNextNode(nodes, 1L, this.properties("name", "Second"), this.labels((String[])ArrayUtil.union((Object[])new String[]{"One"}, (Object[])addedLabels)));
            this.assertNextNode(nodes, 2L, this.properties("name", "Third"), this.labels((String[])ArrayUtil.union((Object[])new String[]{"One"}, (Object[])addedLabels)));
            Assert.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @Test
    public void shouldProvideDefaultRelationshipType() throws Exception {
        String defaultType = "DEFAULT";
        String customType = "CUSTOM";
        DataFactory data = CsvInputTest.data(":START_ID,:END_ID,:TYPE\n0,1,\n1,2," + customType + "\n2,1," + defaultType, InputEntityDecorators.defaultRelationshipType((String)defaultType));
        Iterable<DataFactory> dataIterable = this.dataIterable(data);
        CsvInput input = new CsvInput(DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatNodeFileHeader(), dataIterable, DataFactories.defaultFormatRelationshipFileHeader(), IdType.ACTUAL, this.config(Configuration.COMMAS), Collectors.silentBadCollector((long)0L));
        try (InputIterator relationships = input.relationships().iterator();){
            this.assertNextRelationship(relationships, 0L, 1L, defaultType, InputEntity.NO_PROPERTIES);
            this.assertNextRelationship(relationships, 1L, 2L, customType, InputEntity.NO_PROPERTIES);
            this.assertNextRelationship(relationships, 2L, 1L, defaultType, InputEntity.NO_PROPERTIES);
            Assert.assertFalse((boolean)this.readNext(relationships));
        }
    }

    @Test
    public void shouldAllowNodesWithoutIdHeader() throws Exception {
        DataFactory data = CsvInputTest.data("name:string,level:int\nMattias,1\nJohan,2\n");
        Iterable<DataFactory> dataIterable = this.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.STRING, this.config(Configuration.COMMAS), Collectors.silentBadCollector((long)0L));
        try (InputIterator nodes = input.nodes().iterator();){
            this.assertNextNode(nodes, null, new Object[]{"name", "Mattias", "level", 1}, this.labels(new String[0]));
            this.assertNextNode(nodes, null, new Object[]{"name", "Johan", "level", 2}, this.labels(new String[0]));
            Assert.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @Test
    public void shouldAllowSomeNodesToBeAnonymous() throws Exception {
        DataFactory data = CsvInputTest.data(":ID,name:string,level:int\nabc,Mattias,1\n,Johan,2\n");
        Iterable<DataFactory> dataIterable = this.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.STRING, this.config(Configuration.COMMAS), Collectors.silentBadCollector((long)0L));
        try (InputIterator nodes = input.nodes().iterator();){
            this.assertNextNode(nodes, "abc", new Object[]{"name", "Mattias", "level", 1}, this.labels(new String[0]));
            this.assertNextNode(nodes, null, new Object[]{"name", "Johan", "level", 2}, this.labels(new String[0]));
            Assert.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @Test
    public void shouldAllowNodesToBeAnonymousEvenIfIdHeaderIsNamed() throws Exception {
        DataFactory data = CsvInputTest.data("id:ID,name:string,level:int\nabc,Mattias,1\n,Johan,2\n");
        Iterable<DataFactory> dataIterable = this.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.STRING, this.config(Configuration.COMMAS), Collectors.silentBadCollector((long)0L));
        try (InputIterator nodes = input.nodes().iterator();){
            this.assertNextNode(nodes, "abc", new Object[]{"id", "abc", "name", "Mattias", "level", 1}, this.labels(new String[0]));
            this.assertNextNode(nodes, null, new Object[]{"name", "Johan", "level", 2}, this.labels(new String[0]));
            Assert.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @Test
    public void shouldNotHaveIdSetAsPropertyIfIdHeaderEntryIsNamedForActualIds() throws Exception {
        DataFactory data = CsvInputTest.data("myId:ID,name:string,level:int\n0,Mattias,1\n1,Johan,2\n");
        Iterable<DataFactory> dataIterable = this.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.ACTUAL, this.config(Configuration.COMMAS), Collectors.silentBadCollector((long)0L));
        try (InputIterator nodes = input.nodes().iterator();){
            this.assertNextNode(nodes, 0L, new Object[]{"name", "Mattias", "level", 1}, this.labels(new String[0]));
            this.assertNextNode(nodes, 1L, new Object[]{"name", "Johan", "level", 2}, this.labels(new String[0]));
            Assert.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @Test
    public void shouldIgnoreEmptyPropertyValues() throws Exception {
        DataFactory data = CsvInputTest.data(":ID,name,extra\n0,Mattias,\n1,Johan,Additional\n");
        Iterable<DataFactory> dataIterable = this.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.ACTUAL, this.config(Configuration.COMMAS), Collectors.silentBadCollector((long)0L));
        try (InputIterator nodes = input.nodes().iterator();){
            this.assertNextNode(nodes, 0L, new Object[]{"name", "Mattias"}, this.labels(new String[0]));
            this.assertNextNode(nodes, 1L, new Object[]{"name", "Johan", "extra", "Additional"}, this.labels(new String[0]));
            Assert.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @Test
    public void shouldIgnoreEmptyIntPropertyValues() throws Exception {
        DataFactory data = CsvInputTest.data(":ID,name,extra:int\n0,Mattias,\n1,Johan,10\n");
        Iterable<DataFactory> dataIterable = this.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.ACTUAL, this.config(Configuration.COMMAS), Collectors.silentBadCollector((long)0L));
        try (InputIterator nodes = input.nodes().iterator();){
            this.assertNextNode(nodes, 0L, new Object[]{"name", "Mattias"}, this.labels(new String[0]));
            this.assertNextNode(nodes, 1L, new Object[]{"name", "Johan", "extra", 10}, this.labels(new String[0]));
            Assert.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @Test
    public void shouldParsePointPropertyValues() throws Exception {
        DataFactory data = CsvInputTest.data(":ID,name,point:Point\n0,Mattias,\"{x: 2.7, y:3.2 }\"\n1,Johan,\" { height :0.01 ,longitude:5, latitude : -4.2 } \"\n");
        Iterable<DataFactory> dataIterable = this.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.ACTUAL, this.config(Configuration.COMMAS), Collectors.silentBadCollector((long)0L));
        try (InputIterator nodes = input.nodes().iterator();){
            this.assertNextNode(nodes, 0L, new Object[]{"name", "Mattias", "point", Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{2.7, 3.2})}, this.labels(new String[0]));
            this.assertNextNode(nodes, 1L, new Object[]{"name", "Johan", "point", Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84_3D, (double[])new double[]{5.0, -4.2, 0.01})}, this.labels(new String[0]));
            Assert.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @Test
    public void shouldNotParsePointPropertyValuesWithDuplicateKeys() throws Exception {
        DataFactory data = CsvInputTest.data(":ID,name,point:Point\n1,Johan,\" { height :0.01 ,longitude:5, latitude : -4.2, latitude : 4.2 } \"\n");
        Iterable<DataFactory> dataIterable = this.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.ACTUAL, this.config(Configuration.COMMAS), Collectors.silentBadCollector((long)0L));
        try (InputIterator nodes = input.nodes().iterator();){
            this.readNext(nodes);
            Assert.fail((String)"Should have failed when key assigned multiple times, but didn't.");
        }
        catch (InputException inputException) {
            // empty catch block
        }
    }

    @Test
    public void shouldParsePointPropertyValuesWithCRSInHeader() throws Exception {
        DataFactory data = CsvInputTest.data(":ID,name,point:Point{crs:WGS-84-3D}\n0,Johan,\" { height :0.01 ,longitude:5, latitude : -4.2 } \"\n");
        Iterable<DataFactory> dataIterable = this.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.ACTUAL, this.config(Configuration.COMMAS), Collectors.silentBadCollector((long)0L));
        try (InputIterator nodes = input.nodes().iterator();){
            this.assertNextNode(nodes, 0L, new Object[]{"name", "Johan", "point", Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84_3D, (double[])new double[]{5.0, -4.2, 0.01})}, this.labels(new String[0]));
            Assert.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @Test
    public void shouldUseHeaderInformationToParsePoint() throws Exception {
        DataFactory data = CsvInputTest.data(":ID,name,point:Point{crs:WGS-84}\n0,Johan,\" { x :1 ,y:2 } \"\n");
        Iterable<DataFactory> dataIterable = this.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.ACTUAL, this.config(Configuration.COMMAS), Collectors.silentBadCollector((long)0L));
        try (InputIterator nodes = input.nodes().iterator();){
            this.assertNextNode(nodes, 0L, new Object[]{"name", "Johan", "point", Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{1.0, 2.0})}, this.labels(new String[0]));
            Assert.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @Test
    public void shouldParseDatePropertyValues() throws Exception {
        DataFactory data = CsvInputTest.data(":ID,name,date:Date\n0,Mattias,2018-02-27\n1,Johan,2018-03-01\n");
        Iterable<DataFactory> dataIterable = this.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.ACTUAL, this.config(Configuration.COMMAS), Collectors.silentBadCollector((long)0L));
        try (InputIterator nodes = input.nodes().iterator();){
            this.assertNextNode(nodes, 0L, new Object[]{"name", "Mattias", "date", DateValue.date((int)2018, (int)2, (int)27)}, this.labels(new String[0]));
            this.assertNextNode(nodes, 1L, new Object[]{"name", "Johan", "date", DateValue.date((int)2018, (int)3, (int)1)}, this.labels(new String[0]));
            Assert.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @Test
    public void shouldParseTimePropertyValues() throws Exception {
        DataFactory data = CsvInputTest.data(":ID,name,time:Time\n0,Mattias,13:37\n1,Johan,\"16:20:01\"\n2,Bob,07:30-05:00\n");
        Iterable<DataFactory> dataIterable = this.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.ACTUAL, this.config(Configuration.COMMAS), Collectors.silentBadCollector((long)0L));
        try (InputIterator nodes = input.nodes().iterator();){
            this.assertNextNode(nodes, 0L, new Object[]{"name", "Mattias", "time", TimeValue.time((int)13, (int)37, (int)0, (int)0, (String)"+00:00")}, this.labels(new String[0]));
            this.assertNextNode(nodes, 1L, new Object[]{"name", "Johan", "time", TimeValue.time((int)16, (int)20, (int)1, (int)0, (String)"+00:00")}, this.labels(new String[0]));
            this.assertNextNode(nodes, 2L, new Object[]{"name", "Bob", "time", TimeValue.time((int)7, (int)30, (int)0, (int)0, (String)"-05:00")}, this.labels(new String[0]));
            Assert.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @Test
    public void shouldParseTimePropertyValuesWithTimezoneInHeader() throws Exception {
        DataFactory data = CsvInputTest.data(":ID,name,time:Time{timezone:+02:00}\n0,Mattias,13:37\n1,Johan,\"16:20:01\"\n2,Bob,07:30-05:00\n");
        Iterable<DataFactory> dataIterable = this.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.ACTUAL, this.config(Configuration.COMMAS), Collectors.silentBadCollector((long)0L));
        try (InputIterator nodes = input.nodes().iterator();){
            this.assertNextNode(nodes, 0L, new Object[]{"name", "Mattias", "time", TimeValue.time((int)13, (int)37, (int)0, (int)0, (String)"+02:00")}, this.labels(new String[0]));
            this.assertNextNode(nodes, 1L, new Object[]{"name", "Johan", "time", TimeValue.time((int)16, (int)20, (int)1, (int)0, (String)"+02:00")}, this.labels(new String[0]));
            this.assertNextNode(nodes, 2L, new Object[]{"name", "Bob", "time", TimeValue.time((int)7, (int)30, (int)0, (int)0, (String)"-05:00")}, this.labels(new String[0]));
            Assert.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @Test
    public void shouldParseDateTimePropertyValues() throws Exception {
        DataFactory data = CsvInputTest.data(":ID,name,time:DateTime\n0,Mattias,2018-02-27T13:37\n1,Johan,\"2018-03-01T16:20:01\"\n2,Bob,1981-05-11T07:30-05:00\n");
        Iterable<DataFactory> dataIterable = this.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.ACTUAL, this.config(Configuration.COMMAS), Collectors.silentBadCollector((long)0L));
        try (InputIterator nodes = input.nodes().iterator();){
            this.assertNextNode(nodes, 0L, new Object[]{"name", "Mattias", "time", DateTimeValue.datetime((int)2018, (int)2, (int)27, (int)13, (int)37, (int)0, (int)0, (String)"+00:00")}, this.labels(new String[0]));
            this.assertNextNode(nodes, 1L, new Object[]{"name", "Johan", "time", DateTimeValue.datetime((int)2018, (int)3, (int)1, (int)16, (int)20, (int)1, (int)0, (String)"+00:00")}, this.labels(new String[0]));
            this.assertNextNode(nodes, 2L, new Object[]{"name", "Bob", "time", DateTimeValue.datetime((int)1981, (int)5, (int)11, (int)7, (int)30, (int)0, (int)0, (String)"-05:00")}, this.labels(new String[0]));
            Assert.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @Test
    public void shouldParseDateTimePropertyValuesWithTimezoneInHeader() throws Exception {
        DataFactory data = CsvInputTest.data(":ID,name,time:DateTime{timezone:Europe/Stockholm}\n0,Mattias,2018-02-27T13:37\n1,Johan,\"2018-03-01T16:20:01\"\n2,Bob,1981-05-11T07:30-05:00\n");
        Iterable<DataFactory> dataIterable = this.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.ACTUAL, this.config(Configuration.COMMAS), Collectors.silentBadCollector((long)0L));
        try (InputIterator nodes = input.nodes().iterator();){
            this.assertNextNode(nodes, 0L, new Object[]{"name", "Mattias", "time", DateTimeValue.datetime((int)2018, (int)2, (int)27, (int)13, (int)37, (int)0, (int)0, (String)"Europe/Stockholm")}, this.labels(new String[0]));
            this.assertNextNode(nodes, 1L, new Object[]{"name", "Johan", "time", DateTimeValue.datetime((int)2018, (int)3, (int)1, (int)16, (int)20, (int)1, (int)0, (String)"Europe/Stockholm")}, this.labels(new String[0]));
            this.assertNextNode(nodes, 2L, new Object[]{"name", "Bob", "time", DateTimeValue.datetime((int)1981, (int)5, (int)11, (int)7, (int)30, (int)0, (int)0, (String)"-05:00")}, this.labels(new String[0]));
            Assert.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @Test
    public void shouldParseLocalTimePropertyValues() throws Exception {
        DataFactory data = CsvInputTest.data(":ID,name,time:LocalTime\n0,Mattias,13:37\n1,Johan,\"16:20:01\"\n");
        Iterable<DataFactory> dataIterable = this.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.ACTUAL, this.config(Configuration.COMMAS), Collectors.silentBadCollector((long)0L));
        try (InputIterator nodes = input.nodes().iterator();){
            this.assertNextNode(nodes, 0L, new Object[]{"name", "Mattias", "time", LocalTimeValue.localTime((int)13, (int)37, (int)0, (int)0)}, this.labels(new String[0]));
            this.assertNextNode(nodes, 1L, new Object[]{"name", "Johan", "time", LocalTimeValue.localTime((int)16, (int)20, (int)1, (int)0)}, this.labels(new String[0]));
            Assert.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @Test
    public void shouldParseLocalDateTimePropertyValues() throws Exception {
        DataFactory data = CsvInputTest.data(":ID,name,time:LocalDateTime\n0,Mattias,2018-02-27T13:37\n1,Johan,\"2018-03-01T16:20:01\"\n");
        Iterable<DataFactory> dataIterable = this.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.ACTUAL, this.config(Configuration.COMMAS), Collectors.silentBadCollector((long)0L));
        try (InputIterator nodes = input.nodes().iterator();){
            this.assertNextNode(nodes, 0L, new Object[]{"name", "Mattias", "time", LocalDateTimeValue.localDateTime((int)2018, (int)2, (int)27, (int)13, (int)37, (int)0, (int)0)}, this.labels(new String[0]));
            this.assertNextNode(nodes, 1L, new Object[]{"name", "Johan", "time", LocalDateTimeValue.localDateTime((int)2018, (int)3, (int)1, (int)16, (int)20, (int)1, (int)0)}, this.labels(new String[0]));
            Assert.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @Test
    public void shouldParseDurationPropertyValues() throws Exception {
        DataFactory data = CsvInputTest.data(":ID,name,duration:Duration\n0,Mattias,P3MT13H37M\n1,Johan,\"P-1YT4H20M\"\n");
        Iterable<DataFactory> dataIterable = this.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.ACTUAL, this.config(Configuration.COMMAS), Collectors.silentBadCollector((long)0L));
        try (InputIterator nodes = input.nodes().iterator();){
            this.assertNextNode(nodes, 0L, new Object[]{"name", "Mattias", "duration", DurationValue.duration((long)3L, (long)0L, (long)49020L, (long)0L)}, this.labels(new String[0]));
            this.assertNextNode(nodes, 1L, new Object[]{"name", "Johan", "duration", DurationValue.duration((long)-12L, (long)0L, (long)15600L, (long)0L)}, this.labels(new String[0]));
            Assert.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @Test
    public void shouldFailOnArrayDelimiterBeingSameAsDelimiter() {
        try {
            new CsvInput(null, null, null, null, IdType.ACTUAL, this.customConfig(',', ',', '\"'), Collectors.silentBadCollector((long)0L));
            Assert.fail((String)"Should not be possible");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("array delimiter"));
        }
    }

    @Test
    public void shouldFailOnQuotationCharacterBeingSameAsDelimiter() {
        try {
            new CsvInput(null, null, null, null, IdType.ACTUAL, this.customConfig(',', ';', ','), Collectors.silentBadCollector((long)0L));
            Assert.fail((String)"Should not be possible");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("delimiter"));
            Assert.assertTrue((boolean)e.getMessage().contains("quotation"));
        }
    }

    @Test
    public void shouldFailOnQuotationCharacterBeingSameAsArrayDelimiter() {
        try {
            new CsvInput(null, null, null, null, IdType.ACTUAL, this.customConfig(',', ';', ';'), Collectors.silentBadCollector((long)0L));
            Assert.fail((String)"Should not be possible");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("array delimiter"));
            Assert.assertTrue((boolean)e.getMessage().contains("quotation"));
        }
    }

    @Test
    public void shouldHaveNodesBelongToGroupSpecifiedInHeader() throws Exception {
        IdType idType = IdType.INTEGER;
        Iterable<DataFactory> data = this.dataIterable(CsvInputTest.data("123,one\n456,two"));
        Groups groups = new Groups();
        Group group = groups.getOrCreate("MyGroup");
        CsvInput input = new CsvInput(data, this.header(this.entry(null, Type.ID, group.name(), idType.extractor(this.extractors)), this.entry("name", Type.PROPERTY, this.extractors.string())), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), idType, this.config(Configuration.COMMAS), Collectors.silentBadCollector((long)0L));
        try (InputIterator nodes = input.nodes().iterator();){
            this.assertNextNode(nodes, group, 123L, this.properties("name", "one"), this.labels(new String[0]));
            this.assertNextNode(nodes, group, 456L, this.properties("name", "two"), this.labels(new String[0]));
            Assert.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @Test
    public void shouldHaveRelationshipsSpecifyStartEndNodeIdGroupsInHeader() throws Exception {
        IdType idType = IdType.INTEGER;
        Iterable<DataFactory> data = this.dataIterable(CsvInputTest.data("123,TYPE,234\n345,TYPE,456"));
        Groups groups = new Groups();
        Group startNodeGroup = groups.getOrCreate("StartGroup");
        Group endNodeGroup = groups.getOrCreate("EndGroup");
        Iterable<DataFactory> nodeHeader = this.dataIterable(CsvInputTest.data(":ID(" + startNodeGroup.name() + ")"), CsvInputTest.data(":ID(" + endNodeGroup.name() + ")"));
        CsvInput input = new CsvInput(nodeHeader, DataFactories.defaultFormatNodeFileHeader(), data, this.header(this.entry(null, Type.START_ID, startNodeGroup.name(), idType.extractor(this.extractors)), this.entry(null, Type.TYPE, this.extractors.string()), this.entry(null, Type.END_ID, endNodeGroup.name(), idType.extractor(this.extractors))), idType, this.config(Configuration.COMMAS), Collectors.silentBadCollector((long)0L));
        try (InputIterator relationships = input.relationships().iterator();){
            this.assertRelationship(relationships, startNodeGroup, 123L, endNodeGroup, 234L, "TYPE", this.properties(new Object[0]));
            this.assertRelationship(relationships, startNodeGroup, 345L, endNodeGroup, 456L, "TYPE", this.properties(new Object[0]));
            Assert.assertFalse((boolean)this.readNext(relationships));
        }
    }

    @Test
    public void shouldDoWithoutRelationshipTypeHeaderIfDefaultSupplied() throws Exception {
        String defaultType = "HERE";
        DataFactory data = CsvInputTest.data(":START_ID,:END_ID,name\n0,1,First\n2,3,Second\n", InputEntityDecorators.defaultRelationshipType((String)defaultType));
        Iterable<DataFactory> dataIterable = this.dataIterable(data);
        CsvInput input = new CsvInput(DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatNodeFileHeader(), dataIterable, DataFactories.defaultFormatRelationshipFileHeader(), IdType.ACTUAL, this.config(Configuration.COMMAS), Collectors.silentBadCollector((long)0L));
        try (InputIterator relationships = input.relationships().iterator();){
            this.assertNextRelationship(relationships, 0L, 1L, defaultType, this.properties("name", "First"));
            this.assertNextRelationship(relationships, 2L, 3L, defaultType, this.properties("name", "Second"));
            Assert.assertFalse((boolean)this.readNext(relationships));
        }
    }

    @Test
    public void shouldIgnoreNodeEntriesMarkedIgnoreUsingHeader() throws Exception {
        Iterable data = DataFactories.datas((DataFactory[])new DataFactory[]{CsvInputTest.data(":ID,name:IGNORE,other:int,:LABEL\n1,Mattias,10,Person\n2,Johan,111,Person\n3,Emil,12,Person")});
        CsvInput input = new CsvInput(data, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatNodeFileHeader(), IdType.INTEGER, this.config(Configuration.COMMAS), Collectors.silentBadCollector((long)0L));
        try (InputIterator nodes = input.nodes().iterator();){
            this.assertNextNode(nodes, 1L, new Object[]{"other", 10}, this.labels("Person"));
            this.assertNextNode(nodes, 2L, new Object[]{"other", 111}, this.labels("Person"));
            this.assertNextNode(nodes, 3L, new Object[]{"other", 12}, this.labels("Person"));
            Assert.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @Test
    public void shouldIgnoreRelationshipEntriesMarkedIgnoreUsingHeader() throws Exception {
        Iterable data = DataFactories.datas((DataFactory[])new DataFactory[]{CsvInputTest.data(":START_ID,:TYPE,:END_ID,prop:IGNORE,other:int\n1,KNOWS,2,Mattias,10\n2,KNOWS,3,Johan,111\n3,KNOWS,4,Emil,12")});
        CsvInput input = new CsvInput(DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatNodeFileHeader(), data, DataFactories.defaultFormatRelationshipFileHeader(), IdType.INTEGER, this.config(Configuration.COMMAS), Collectors.silentBadCollector((long)0L));
        try (InputIterator relationships = input.relationships().iterator();){
            this.assertNextRelationship(relationships, 1L, 2L, "KNOWS", new Object[]{"other", 10});
            this.assertNextRelationship(relationships, 2L, 3L, "KNOWS", new Object[]{"other", 111});
            this.assertNextRelationship(relationships, 3L, 4L, "KNOWS", new Object[]{"other", 12});
            Assert.assertFalse((boolean)this.readNext(relationships));
        }
    }

    @Test
    public void shouldPropagateExceptionFromFailingDecorator() throws Exception {
        RuntimeException failure = new RuntimeException("FAILURE");
        Iterable data = DataFactories.datas((DataFactory[])new DataFactory[]{CsvInputTest.data(":ID,name\n1,Mattias", new FailingNodeDecorator(failure))});
        CsvInput input = new CsvInput(data, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatNodeFileHeader(), IdType.INTEGER, this.config(Configuration.COMMAS), Collectors.silentBadCollector((long)0L));
        try (InputIterator nodes = input.nodes().iterator();){
            this.readNext(nodes);
        }
        catch (InputException e) {
            Assert.assertTrue((e.getCause() == failure ? 1 : 0) != 0);
        }
    }

    @Test
    public void shouldNotIncludeEmptyArraysInEntities() throws Exception {
        Iterable data = DataFactories.datas((DataFactory[])new DataFactory[]{CsvInputTest.data(":ID,sprop:String[],lprop:long[]\n1,,\n2,a;b,10;20")});
        CsvInput input = new CsvInput(data, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatNodeFileHeader(), IdType.INTEGER, this.config(Configuration.COMMAS), Collectors.silentBadCollector((long)0L));
        try (InputIterator nodes = input.nodes().iterator();){
            this.assertNextNode(nodes, 1L, InputEntity.NO_PROPERTIES, this.labels(new String[0]));
            this.assertNextNode(nodes, 2L, this.properties("sprop", new String[]{"a", "b"}, "lprop", new long[]{10L, 20L}), this.labels(new String[0]));
            Assert.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @Test
    public void shouldTreatEmptyQuotedStringsAsNullIfConfiguredTo() throws Exception {
        Iterable data = DataFactories.datas((DataFactory[])new DataFactory[]{CsvInputTest.data(":ID,one,two,three\n1,\"\",,value")});
        Configuration config = this.config((Configuration)new Configuration.Overridden(Configuration.COMMAS){

            public boolean emptyQuotedStringsAsNull() {
                return true;
            }
        });
        CsvInput input = new CsvInput(data, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.INTEGER, config, Collectors.silentBadCollector((long)0L));
        try (InputIterator nodes = input.nodes().iterator();){
            this.assertNextNode(nodes, 1L, this.properties("three", "value"), this.labels(new String[0]));
            Assert.assertFalse((boolean)this.readNext(nodes));
        }
    }

    @Test
    public void shouldIgnoreEmptyExtraColumns() throws Exception {
        Iterable data = DataFactories.datas((DataFactory[])new DataFactory[]{CsvInputTest.data(":ID,one\n1,test,\n2,test,,additional")});
        Collector collector = (Collector)Mockito.mock(Collector.class);
        CsvInput input = new CsvInput(data, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.INTEGER, this.config(Configuration.COMMAS), collector);
        try (InputIterator nodes = input.nodes().iterator();){
            this.assertNextNode(nodes, 1L, this.properties("one", "test"), this.labels(new String[0]));
            this.assertNextNode(nodes, 2L, this.properties("one", "test"), this.labels(new String[0]));
            Assert.assertFalse((boolean)this.readNext(nodes));
        }
        ((Collector)Mockito.verify((Object)collector, (VerificationMode)Mockito.times((int)1))).collectExtraColumns(ArgumentMatchers.anyString(), ArgumentMatchers.eq((long)1L), (String)ArgumentMatchers.eq(null));
        ((Collector)Mockito.verify((Object)collector, (VerificationMode)Mockito.times((int)1))).collectExtraColumns(ArgumentMatchers.anyString(), ArgumentMatchers.eq((long)2L), (String)ArgumentMatchers.eq(null));
        ((Collector)Mockito.verify((Object)collector, (VerificationMode)Mockito.times((int)1))).collectExtraColumns(ArgumentMatchers.anyString(), ArgumentMatchers.eq((long)2L), (String)ArgumentMatchers.eq((Object)"additional"));
    }

    @Test
    public void shouldSkipRelationshipValidationIfToldTo() throws Exception {
        Iterable data = DataFactories.datas((DataFactory[])new DataFactory[]{CsvInputTest.data(":START_ID,:END_ID,:TYPE\n,,")});
        CsvInput input = new CsvInput(DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatNodeFileHeader(), data, DataFactories.defaultFormatRelationshipFileHeader(), IdType.INTEGER, this.config(Configuration.COMMAS), Collectors.silentBadCollector((long)0L));
        try (InputIterator relationships = input.relationships().iterator();){
            this.readNext(relationships);
            Assert.assertNull((Object)this.visitor.startId());
            Assert.assertNull((Object)this.visitor.endId());
            Assert.assertNull((Object)this.visitor.stringType);
        }
    }

    @Test
    public void shouldFailOnUnparsableNodeHeader() {
        Iterable data = DataFactories.datas((DataFactory[])new DataFactory[]{CsvInputTest.data(":SOMETHING,abcde#rtg:123,")});
        try {
            new CsvInput(data, DataFactories.defaultFormatNodeFileHeader(), DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatRelationshipFileHeader(), IdType.INTEGER, Configuration.COMMAS, (Collector)Mockito.mock(Collector.class));
            Assert.fail((String)"Should not parse");
        }
        catch (InputException inputException) {
            // empty catch block
        }
    }

    @Test
    public void shouldFailOnUnparsableRelationshipHeader() {
        Iterable data = DataFactories.datas((DataFactory[])new DataFactory[]{CsvInputTest.data(":SOMETHING,abcde#rtg:123,")});
        try {
            new CsvInput(DataFactories.datas((DataFactory[])new DataFactory[0]), DataFactories.defaultFormatNodeFileHeader(), data, DataFactories.defaultFormatRelationshipFileHeader(), IdType.INTEGER, Configuration.COMMAS, (Collector)Mockito.mock(Collector.class));
            Assert.fail((String)"Should not parse");
        }
        catch (InputException inputException) {
            // empty catch block
        }
    }

    @Test
    public void shouldFailOnUndefinedGroupInRelationshipHeader() {
        Iterable nodeData = DataFactories.datas((DataFactory[])new DataFactory[]{CsvInputTest.data(":ID(left)"), CsvInputTest.data(":ID(right)")});
        Iterable relationshipData = DataFactories.datas((DataFactory[])new DataFactory[]{CsvInputTest.data(":START_ID(left),:END_ID(rite)")});
        try {
            new CsvInput(nodeData, DataFactories.defaultFormatNodeFileHeader(), relationshipData, DataFactories.defaultFormatRelationshipFileHeader(), IdType.INTEGER, Configuration.COMMAS, (Collector)Mockito.mock(Collector.class));
            Assert.fail((String)"Should not validate");
        }
        catch (InputException inputException) {
            // empty catch block
        }
    }

    @Test
    public void shouldFailOnGlobalGroupInRelationshipHeaderIfNoGLobalGroupInNodeHeader() {
        Iterable nodeData = DataFactories.datas((DataFactory[])new DataFactory[]{CsvInputTest.data(":ID(left)"), CsvInputTest.data(":ID(right)")});
        Iterable relationshipData = DataFactories.datas((DataFactory[])new DataFactory[]{CsvInputTest.data(":START_ID(left),:END_ID(rite)")});
        try {
            new CsvInput(nodeData, DataFactories.defaultFormatNodeFileHeader(), relationshipData, DataFactories.defaultFormatRelationshipFileHeader(), IdType.INTEGER, Configuration.COMMAS, (Collector)Mockito.mock(Collector.class));
            Assert.fail((String)"Should not validate");
        }
        catch (InputException inputException) {
            // empty catch block
        }
    }

    private Configuration customConfig(final char delimiter, final char arrayDelimiter, final char quote) {
        return this.config((Configuration)new Configuration.Default(){

            public char quotationCharacter() {
                return quote;
            }

            public char delimiter() {
                return delimiter;
            }

            public char arrayDelimiter() {
                return arrayDelimiter;
            }
        });
    }

    private DataFactory given(CharReadable data) {
        return config -> CsvInputTest.dataItem(data, InputEntityDecorators.NO_DECORATOR);
    }

    private DataFactory data(CharReadable data, Decorator decorator) {
        return config -> CsvInputTest.dataItem(data, decorator);
    }

    private static Data dataItem(CharReadable data, Decorator decorator) {
        return DataFactories.data((Decorator)decorator, () -> data).create(Configuration.COMMAS);
    }

    private void assertNextRelationship(InputIterator relationship, Object startNode, Object endNode, String type, Object[] properties) throws IOException {
        this.assertRelationship(relationship, Group.GLOBAL, startNode, Group.GLOBAL, endNode, type, properties);
    }

    private void assertRelationship(InputIterator data, Group startNodeGroup, Object startNode, Group endNodeGroup, Object endNode, String type, Object[] properties) throws IOException {
        Assert.assertTrue((boolean)this.readNext(data));
        Assert.assertEquals((Object)startNodeGroup, (Object)this.visitor.startIdGroup);
        Assert.assertEquals((Object)startNode, (Object)this.visitor.startId());
        Assert.assertEquals((Object)endNodeGroup, (Object)this.visitor.endIdGroup);
        Assert.assertEquals((Object)endNode, (Object)this.visitor.endId());
        Assert.assertEquals((Object)type, (Object)this.visitor.stringType);
        Assert.assertArrayEquals((Object[])properties, (Object[])this.visitor.properties());
    }

    private void assertNextNode(InputIterator data, Object id, Object[] properties, Set<String> labels) throws IOException {
        this.assertNextNode(data, Group.GLOBAL, id, properties, labels);
    }

    private void assertNextNode(InputIterator data, Group group, Object id, Object[] properties, Set<String> labels) throws IOException {
        Assert.assertTrue((boolean)this.readNext(data));
        Assert.assertEquals((long)group.id(), (long)this.visitor.idGroup.id());
        Assert.assertEquals((Object)id, (Object)this.visitor.id());
        Assert.assertArrayEquals((Object[])properties, (Object[])this.visitor.properties());
        Assert.assertEquals(labels, (Object)Iterators.asSet((Object[])this.visitor.labels()));
    }

    private boolean readNext(InputIterator data) throws IOException {
        if (this.referenceData != data) {
            this.chunk = null;
            this.referenceData = data;
        }
        if (this.chunk == null) {
            this.chunk = data.newChunk();
            if (!data.next(this.chunk)) {
                return false;
            }
        }
        if (this.chunk.next((InputEntityVisitor)this.visitor)) {
            return true;
        }
        if (!data.next(this.chunk)) {
            return false;
        }
        return this.chunk.next((InputEntityVisitor)this.visitor);
    }

    private Object[] properties(Object ... keysAndValues) {
        return keysAndValues;
    }

    private Set<String> labels(String ... labels) {
        return Iterators.asSet((Object[])labels);
    }

    private Header.Factory header(final Header.Entry ... entries) {
        return new Header.Factory(){

            public boolean isDefined() {
                return true;
            }

            public Header create(CharSeeker dataSeeker, Configuration configuration, IdType idType, Groups groups) {
                return new Header(entries);
            }
        };
    }

    private Header.Entry entry(String name, Type type, Extractor<?> extractor) {
        return this.entry(name, type, null, extractor);
    }

    private Header.Entry entry(String name, Type type, String groupName, Extractor<?> extractor) {
        return new Header.Entry(name, type, this.groups.getOrCreate(groupName), extractor);
    }

    private static DataFactory data(String data) {
        return CsvInputTest.data(data, value -> value);
    }

    private static DataFactory data(String data, Decorator decorator) {
        return config -> CsvInputTest.dataItem(CsvInputTest.charReader(data), decorator);
    }

    private static CharReadable charReader(String data) {
        return Readables.wrap((String)data);
    }

    private Iterable<DataFactory> dataIterable(DataFactory ... data) {
        return Iterables.iterable((Object[])data);
    }

    private Configuration config(Configuration config) {
        return new Configuration.Overridden(config){

            public boolean multilineFields() {
                return CsvInputTest.this.allowMultilineFields;
            }
        };
    }

    private static class FailingNodeDecorator
    implements Decorator {
        private final RuntimeException failure;

        FailingNodeDecorator(RuntimeException failure) {
            this.failure = failure;
        }

        public InputEntityVisitor apply(InputEntityVisitor t) {
            return new InputEntityVisitor.Delegate(t){

                public void endOfEntity() {
                    throw failure;
                }
            };
        }
    }

    private static class CapturingDataFactories
    implements Iterable<DataFactory> {
        private final Function<Configuration, CharReadable> factory;
        private CharReadable last;
        private final Decorator decorator;

        CapturingDataFactories(Function<Configuration, CharReadable> factory, Decorator decorator) {
            this.factory = factory;
            this.decorator = decorator;
        }

        @Override
        public Iterator<DataFactory> iterator() {
            return Iterators.iterator(config -> new Data(){

                public RawIterator<CharReadable, IOException> stream() {
                    last = (CharReadable)factory.apply(config);
                    return Readables.iterator(in -> in, (Object[])new CharReadable[]{last});
                }

                public Decorator decorator() {
                    return decorator;
                }
            });
        }

        CharReadable last() {
            return this.last;
        }
    }
}

