/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.schema;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransientFailureException;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.test.Race;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.ImpermanentDatabaseRule;

public class ConcurrentCreateDropIndexIT {
    private static final String KEY = "key";
    @Rule
    public final DatabaseRule db = new ImpermanentDatabaseRule();
    private final int threads = Runtime.getRuntime().availableProcessors();

    @Before
    public void createTokens() {
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < this.threads; ++i) {
                this.db.createNode(ConcurrentCreateDropIndexIT.label(i)).setProperty(KEY, (Object)i);
            }
            tx.success();
        }
    }

    @Test
    public void concurrentCreatingOfIndexesShouldNotInterfere() throws Throwable {
        Race race = new Race();
        for (int i = 0; i < this.threads; ++i) {
            race.addContestant(this.indexCreate(i), 1);
        }
        race.go();
        try (Transaction tx = this.db.beginTx();){
            List indexes = Iterables.asList((Iterable)this.db.schema().getIndexes());
            Assert.assertEquals((long)this.threads, (long)indexes.size());
            HashSet<String> labels = new HashSet<String>();
            for (IndexDefinition index : indexes) {
                Assert.assertTrue((boolean)labels.add(index.getLabel().name()));
            }
            tx.success();
        }
    }

    @Test
    public void concurrentDroppingOfIndexesShouldNotInterfere() throws Throwable {
        ArrayList<IndexDefinition> indexes = new ArrayList<IndexDefinition>();
        Transaction tx = this.db.beginTx();
        Object object = null;
        try {
            for (int i = 0; i < this.threads; ++i) {
                indexes.add(this.db.schema().indexFor(ConcurrentCreateDropIndexIT.label(i)).on(KEY).create());
            }
            tx.success();
        }
        catch (Throwable i) {
            object = i;
            throw i;
        }
        finally {
            if (tx != null) {
                if (object != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable i) {
                        ((Throwable)object).addSuppressed(i);
                    }
                } else {
                    tx.close();
                }
            }
        }
        Race race = new Race();
        for (IndexDefinition index : indexes) {
            race.addContestant(this.indexDrop(index), 1);
        }
        race.go();
        try (Transaction tx2 = this.db.beginTx();){
            Assert.assertEquals((long)0L, (long)Iterables.asList((Iterable)this.db.schema().getIndexes()).size());
            tx2.success();
        }
    }

    @Test
    public void concurrentMixedCreatingAndDroppingOfIndexesShouldNotInterfere() throws Throwable {
        int i;
        ArrayList<IndexDefinition> indexesToDrop = new ArrayList<IndexDefinition>();
        int creates = this.threads / 2;
        int drops = this.threads - creates;
        try (Transaction tx = this.db.beginTx();){
            for (i = 0; i < drops; ++i) {
                indexesToDrop.add(this.db.schema().indexFor(ConcurrentCreateDropIndexIT.label(i)).on(KEY).create());
            }
            tx.success();
        }
        Race race = new Race();
        HashSet<String> expectedIndexedLabels = new HashSet<String>();
        for (i = 0; i < creates; ++i) {
            expectedIndexedLabels.add(ConcurrentCreateDropIndexIT.label(drops + i).name());
            race.addContestant(this.indexCreate(drops + i), 1);
        }
        for (IndexDefinition index : indexesToDrop) {
            race.addContestant(this.indexDrop(index), 1);
        }
        race.go();
        try (Transaction tx = this.db.beginTx();){
            List indexes = Iterables.asList((Iterable)this.db.schema().getIndexes());
            Assert.assertEquals((long)creates, (long)indexes.size());
            tx.success();
            for (IndexDefinition index : indexes) {
                Assert.assertTrue((boolean)expectedIndexedLabels.remove(index.getLabel().name()));
            }
        }
    }

    @Test
    public void concurrentCreatingUniquenessConstraint() throws Throwable {
        Race race = new Race().withMaxDuration(10L, TimeUnit.SECONDS);
        Label label = ConcurrentCreateDropIndexIT.label(0);
        race.addContestants(10, () -> {
            try (Transaction tx = this.db.beginTx();){
                this.db.schema().constraintFor(label).assertPropertyIsUnique(KEY).create();
                tx.success();
            }
            catch (ConstraintViolationException | TransientFailureException throwable) {
                // empty catch block
            }
        }, 300);
        race.go();
        try (Transaction tx = this.db.beginTx();){
            ConstraintDefinition constraint = (ConstraintDefinition)Iterables.single((Iterable)this.db.schema().getConstraints(label));
            Assert.assertNotNull((Object)constraint);
            IndexDefinition index = (IndexDefinition)Iterables.single((Iterable)this.db.schema().getIndexes(label));
            Assert.assertNotNull((Object)index);
            tx.success();
        }
    }

    @Test
    public void concurrentCreatingUniquenessConstraintOnNonUniqueData() throws Throwable {
        Label label = ConcurrentCreateDropIndexIT.label(0);
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < 2; ++i) {
                this.db.createNode(label).setProperty(KEY, (Object)"A");
            }
            tx.success();
        }
        Race race = new Race().withMaxDuration(10L, TimeUnit.SECONDS);
        race.addContestants(3, () -> {
            try (Transaction tx = this.db.beginTx();){
                this.db.schema().constraintFor(label).assertPropertyIsUnique(KEY).create();
                tx.success();
            }
            catch (ConstraintViolationException | TransientFailureException throwable) {
                // empty catch block
            }
        }, 100);
        race.go();
        try (Transaction tx = this.db.beginTx();){
            ConstraintDefinition constraint = (ConstraintDefinition)Iterables.singleOrNull((Iterable)this.db.schema().getConstraints(label));
            Assert.assertNull((Object)constraint);
            IndexDefinition index = (IndexDefinition)Iterables.singleOrNull((Iterable)this.db.schema().getIndexes(label));
            Assert.assertNull((Object)index);
            tx.success();
        }
    }

    private Runnable indexCreate(int labelIndex) {
        return () -> {
            try (Transaction tx = this.db.beginTx();){
                this.db.schema().indexFor(ConcurrentCreateDropIndexIT.label(labelIndex)).on(KEY).create();
                tx.success();
            }
        };
    }

    private Runnable indexDrop(IndexDefinition index) {
        return () -> {
            try (Transaction tx = this.db.beginTx();){
                index.drop();
                tx.success();
            }
        };
    }

    private static Label label(int i) {
        return Label.label((String)("L" + i));
    }
}

