/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Test;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;

public class ValueUtilsTest {
    @Test
    public void shouldHandleCollection() {
        List<Integer> collection = Arrays.asList(1, 2, 3);
        AnyValue of = ValueUtils.of(collection);
        MatcherAssert.assertThat((Object)of, (Matcher)IsInstanceOf.instanceOf(ListValue.class));
        ListValue listValue = (ListValue)of;
        MatcherAssert.assertThat((Object)listValue.value(0), (Matcher)CoreMatchers.equalTo((Object)Values.intValue((int)1)));
        MatcherAssert.assertThat((Object)listValue.value(1), (Matcher)CoreMatchers.equalTo((Object)Values.intValue((int)2)));
        MatcherAssert.assertThat((Object)listValue.value(2), (Matcher)CoreMatchers.equalTo((Object)Values.intValue((int)3)));
        MatcherAssert.assertThat((Object)listValue.size(), (Matcher)CoreMatchers.equalTo((Object)3));
    }

    @Test
    public void shouldHandleIterator() {
        Iterator<Integer> iterator = Arrays.asList(1, 2, 3).iterator();
        AnyValue of = ValueUtils.of(iterator);
        MatcherAssert.assertThat((Object)of, (Matcher)IsInstanceOf.instanceOf(ListValue.class));
        ListValue listValue = (ListValue)of;
        MatcherAssert.assertThat((Object)listValue.value(0), (Matcher)CoreMatchers.equalTo((Object)Values.intValue((int)1)));
        MatcherAssert.assertThat((Object)listValue.value(1), (Matcher)CoreMatchers.equalTo((Object)Values.intValue((int)2)));
        MatcherAssert.assertThat((Object)listValue.value(2), (Matcher)CoreMatchers.equalTo((Object)Values.intValue((int)3)));
        MatcherAssert.assertThat((Object)listValue.size(), (Matcher)CoreMatchers.equalTo((Object)3));
    }

    @Test
    public void shouldHandleMaps() {
        Map map = MapUtil.map((Object[])new Object[]{"a", Arrays.asList("foo", 42)});
        AnyValue anyValue = ValueUtils.of((Object)map);
        MatcherAssert.assertThat((Object)anyValue, (Matcher)IsInstanceOf.instanceOf(MapValue.class));
        MapValue mapValue = (MapValue)anyValue;
        MatcherAssert.assertThat((Object)mapValue.get("a"), (Matcher)CoreMatchers.equalTo((Object)VirtualValues.list((AnyValue[])new AnyValue[]{Values.stringValue((String)"foo"), Values.intValue((int)42)})));
        MatcherAssert.assertThat((Object)mapValue.size(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void shouldHandleIterable() {
        List<Integer> collection = Arrays.asList(1, 2, 3);
        AnyValue of = ValueUtils.of(collection);
        MatcherAssert.assertThat((Object)of, (Matcher)IsInstanceOf.instanceOf(ListValue.class));
        ListValue listValue = (ListValue)of;
        MatcherAssert.assertThat((Object)listValue.value(0), (Matcher)CoreMatchers.equalTo((Object)Values.intValue((int)1)));
        MatcherAssert.assertThat((Object)listValue.value(1), (Matcher)CoreMatchers.equalTo((Object)Values.intValue((int)2)));
        MatcherAssert.assertThat((Object)listValue.value(2), (Matcher)CoreMatchers.equalTo((Object)Values.intValue((int)3)));
        MatcherAssert.assertThat((Object)listValue.size(), (Matcher)CoreMatchers.equalTo((Object)3));
    }
}

