/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorSupplier;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.properties.PropertyKeyValue;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.impl.api.index.NodeUpdates;
import org.neo4j.kernel.impl.api.index.PropertyLoader;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class NodeUpdatesTest {
    private static final long nodeId = 0L;
    private static final int labelId = 0;
    private static final int propertyKeyId1 = 0;
    private static final int propertyKeyId2 = 1;
    private static final int propertyKeyId3 = 2;
    private static final long[] labels = new long[]{0L};
    private static final long[] empty = new long[0];
    private static final LabelSchemaDescriptor index1 = SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{0});
    private static final LabelSchemaDescriptor index2 = SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{1});
    private static final LabelSchemaDescriptor index3 = SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{2});
    private static final LabelSchemaDescriptor index123 = SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{0, 1, 2});
    private static final List<LabelSchemaDescriptor> indexes = Arrays.asList(index1, index2, index3, index123);
    private static final StorageProperty property1 = new PropertyKeyValue(0, Values.of((Object)"Neo"));
    private static final StorageProperty property2 = new PropertyKeyValue(1, Values.of((Object)100L));
    private static final StorageProperty property3 = new PropertyKeyValue(2, (Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.3, 45.6}));
    private static final Value[] values123 = new Value[]{property1.value(), property2.value(), property3.value()};

    @Test
    public void shouldNotGenerateUpdatesForEmptyNodeUpdates() {
        NodeUpdates updates = NodeUpdates.forNode((long)0L).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, this.assertNoLoading()), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void shouldNotGenerateUpdateForMultipleExistingPropertiesAndLabels() {
        NodeUpdates updates = NodeUpdates.forNode((long)0L, (long[])labels).existing(0, Values.of((Object)"Neo")).existing(1, Values.of((Object)100L)).existing(2, (Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.3, 45.6})).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, this.assertNoLoading()), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void shouldNotGenerateUpdatesForLabelAdditionWithNoProperties() {
        NodeUpdates updates = NodeUpdates.forNode((long)0L, (long[])empty, (long[])labels).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, this.propertyLoader(new StorageProperty[0])), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void shouldGenerateUpdateForLabelAdditionWithExistingProperty() {
        NodeUpdates updates = NodeUpdates.forNode((long)0L, (long[])empty, (long[])labels).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, this.propertyLoader(property1)), (Matcher)Matchers.containsInAnyOrder((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)index1, (Value[])new Value[]{property1.value()})}));
    }

    @Test
    public void shouldGenerateUpdatesForLabelAdditionWithExistingProperties() {
        NodeUpdates updates = NodeUpdates.forNode((long)0L, (long[])empty, (long[])labels).existing(0, Values.of((Object)"Neo")).existing(1, Values.of((Object)100L)).existing(2, (Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.3, 45.6})).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, this.propertyLoader(property1, property2, property3)), (Matcher)Matchers.containsInAnyOrder((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)index1, (Value[])new Value[]{property1.value()}), IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)index2, (Value[])new Value[]{property2.value()}), IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)index3, (Value[])new Value[]{property3.value()}), IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)index123, (Value[])values123)}));
    }

    @Test
    public void shouldNotGenerateUpdatesForLabelRemovalWithNoProperties() {
        NodeUpdates updates = NodeUpdates.forNode((long)0L, (long[])labels, (long[])empty).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, this.propertyLoader(new StorageProperty[0])), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void shouldGenerateUpdateForLabelRemovalWithExistingProperty() {
        NodeUpdates updates = NodeUpdates.forNode((long)0L, (long[])labels, (long[])empty).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, this.propertyLoader(property1)), (Matcher)Matchers.containsInAnyOrder((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.remove((long)0L, (SchemaDescriptorSupplier)index1, (Value[])new Value[]{property1.value()})}));
    }

    @Test
    public void shouldGenerateUpdatesForLabelRemovalWithExistingProperties() {
        NodeUpdates updates = NodeUpdates.forNode((long)0L, (long[])labels, (long[])empty).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, this.propertyLoader(property1, property2, property3)), (Matcher)Matchers.containsInAnyOrder((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.remove((long)0L, (SchemaDescriptorSupplier)index1, (Value[])new Value[]{property1.value()}), IndexEntryUpdate.remove((long)0L, (SchemaDescriptorSupplier)index2, (Value[])new Value[]{property2.value()}), IndexEntryUpdate.remove((long)0L, (SchemaDescriptorSupplier)index3, (Value[])new Value[]{property3.value()}), IndexEntryUpdate.remove((long)0L, (SchemaDescriptorSupplier)index123, (Value[])values123)}));
    }

    @Test
    public void shouldNotGenerateUpdatesForPropertyAdditionWithNoLabels() {
        NodeUpdates updates = NodeUpdates.forNode((long)0L).added(property1.propertyKeyId(), property1.value()).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, this.assertNoLoading()), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void shouldGenerateUpdatesForSinglePropertyAdditionWithLabels() {
        NodeUpdates updates = NodeUpdates.forNode((long)0L, (long[])labels).added(property1.propertyKeyId(), property1.value()).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, this.propertyLoader(new StorageProperty[0])), (Matcher)Matchers.containsInAnyOrder((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)index1, (Value[])new Value[]{property1.value()})}));
    }

    @Test
    public void shouldGenerateUpdatesForMultiplePropertyAdditionWithLabels() {
        NodeUpdates updates = NodeUpdates.forNode((long)0L, (long[])labels).added(property1.propertyKeyId(), property1.value()).added(property2.propertyKeyId(), property2.value()).added(property3.propertyKeyId(), property3.value()).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, this.propertyLoader(property1, property2, property3)), (Matcher)Matchers.containsInAnyOrder((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)index1, (Value[])new Value[]{property1.value()}), IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)index2, (Value[])new Value[]{property2.value()}), IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)index3, (Value[])new Value[]{property3.value()}), IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)index123, (Value[])values123)}));
    }

    @Test
    public void shouldNotGenerateUpdatesForLabelAddAndPropertyRemove() {
        NodeUpdates updates = NodeUpdates.forNode((long)0L, (long[])empty, (long[])labels).removed(property1.propertyKeyId(), property1.value()).removed(property2.propertyKeyId(), property2.value()).removed(property3.propertyKeyId(), property3.value()).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, this.assertNoLoading()), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void shouldNotGenerateUpdatesForLabelRemoveAndPropertyAdd() {
        NodeUpdates updates = NodeUpdates.forNode((long)0L, (long[])labels, (long[])empty).added(property1.propertyKeyId(), property1.value()).added(property2.propertyKeyId(), property2.value()).added(property3.propertyKeyId(), property3.value()).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, this.assertNoLoading()), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void shouldNotLoadPropertyForLabelsAndNoPropertyChanges() {
        NodeUpdates updates = NodeUpdates.forNode((long)0L, (long[])labels).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(Collections.singleton(index1), this.assertNoLoading()), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void shouldNotLoadPropertyForNoLabelsAndButPropertyAddition() {
        NodeUpdates updates = NodeUpdates.forNode((long)0L, (long[])empty).added(property1.propertyKeyId(), property1.value()).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(Collections.singleton(index1), this.assertNoLoading()), (Matcher)Matchers.emptyIterable());
    }

    private PropertyLoader propertyLoader(StorageProperty ... properties) {
        HashMap<Integer, Value> propertyMap = new HashMap<Integer, Value>();
        for (StorageProperty p : properties) {
            propertyMap.put(p.propertyKeyId(), p.value());
        }
        return (nodeId1, propertyIds, sink) -> {
            for (int propertyId : propertyIds) {
                if (!propertyMap.containsKey(propertyId)) continue;
                sink.onProperty(propertyId, (Value)propertyMap.get(propertyId));
                propertyIds.remove(propertyId);
            }
        };
    }

    private PropertyLoader assertNoLoading() {
        return (nodeId1, propertyIds, sink) -> Assert.fail((String)"Should never attempt to load properties!");
    }
}

