/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.inmemory;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongResourceIterator;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.api.index.inmemory.HashBasedIndexSampler;
import org.neo4j.kernel.impl.api.index.inmemory.InMemoryIndexImplementation;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.storageengine.api.schema.IndexSampler;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

class HashBasedIndex
extends InMemoryIndexImplementation {
    private Map<List<Object>, Set<Long>> data;

    HashBasedIndex(SchemaIndexDescriptor descriptor) {
        super(descriptor);
    }

    public Map<List<Object>, Set<Long>> data() {
        if (this.data == null) {
            throw new IllegalStateException("Index has not been created, or has been dropped.");
        }
        return this.data;
    }

    public synchronized String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + this.data;
    }

    @Override
    synchronized void initialize() {
        this.data = new HashMap<List<Object>, Set<Long>>();
    }

    @Override
    synchronized void drop() {
        this.data = null;
    }

    @Override
    synchronized PrimitiveLongResourceIterator doIndexSeek(Object ... propertyValues) {
        Set<Long> nodes = this.data().get(Arrays.asList(propertyValues));
        return this.asResource(nodes == null ? PrimitiveLongCollections.emptyIterator() : PrimitiveLongCollections.toPrimitiveIterator(nodes.iterator()));
    }

    private synchronized PrimitiveLongResourceIterator rangeSeek(Value lower, boolean includeLower, Value upper, boolean includeUpper, ValueGroup targetValueGroup, IndexQuery query) {
        HashSet nodeIds = new HashSet();
        for (Map.Entry<List<Object>, Set<Long>> entry : this.data.entrySet()) {
            Value key = Values.of((Object)entry.getKey().get(0));
            if (!query.acceptsValue(key)) continue;
            nodeIds.addAll(entry.getValue());
        }
        return this.asResource(PrimitiveLongCollections.toPrimitiveIterator(nodeIds.iterator()));
    }

    private synchronized PrimitiveLongResourceIterator rangeSeekByPrefix(String prefix) {
        return this.stringSearch(entry -> entry.startsWith(prefix));
    }

    private synchronized PrimitiveLongResourceIterator containsString(String exactTerm) {
        return this.stringSearch(entry -> entry.contains(exactTerm));
    }

    private PrimitiveLongResourceIterator endsWith(String suffix) {
        return this.stringSearch(entry -> entry.endsWith(suffix));
    }

    private synchronized PrimitiveLongResourceIterator scan() {
        Iterable all = Iterables.flattenIterable(this.data.values());
        return this.asResource(PrimitiveLongCollections.toPrimitiveIterator(all.iterator()));
    }

    @Override
    synchronized boolean doAdd(long nodeId, boolean applyIdempotently, Object ... propertyValue) {
        Set nodes = this.data().computeIfAbsent(Arrays.asList(propertyValue), k -> new HashSet());
        return nodes.add(nodeId);
    }

    @Override
    synchronized void doRemove(long nodeId, Object ... propertyValues) {
        Set<Long> nodes = this.data().get(Arrays.asList(propertyValues));
        if (nodes != null) {
            nodes.remove(nodeId);
        }
    }

    @Override
    synchronized void remove(long nodeId) {
        for (Set<Long> nodes : this.data().values()) {
            nodes.remove(nodeId);
        }
    }

    @Override
    synchronized void iterateAll(InMemoryIndexImplementation.IndexEntryIterator iterator) throws Exception {
        for (Map.Entry<List<Object>, Set<Long>> entry : this.data().entrySet()) {
            iterator.visitEntry(entry.getKey(), entry.getValue());
        }
    }

    public synchronized long maxCount() {
        return this.ids().size();
    }

    public synchronized Iterator<Long> iterator() {
        return this.ids().iterator();
    }

    private Collection<Long> ids() {
        HashSet<Long> allIds = new HashSet<Long>();
        for (Set<Long> someIds : this.data().values()) {
            allIds.addAll(someIds);
        }
        return allIds;
    }

    @Override
    synchronized InMemoryIndexImplementation snapshot() {
        HashBasedIndex snapshot = new HashBasedIndex(this.descriptor);
        snapshot.initialize();
        for (Map.Entry<List<Object>, Set<Long>> entry : this.data().entrySet()) {
            snapshot.data().put(entry.getKey(), new HashSet(entry.getValue()));
        }
        return snapshot;
    }

    @Override
    protected synchronized long doCountIndexedNodes(long nodeId, Object ... propertyValues) {
        Set<Long> candidates = this.data().get(Arrays.asList(propertyValues));
        return candidates != null && candidates.contains(nodeId) ? 1L : 0L;
    }

    public synchronized IndexSampler createSampler() {
        return new HashBasedIndexSampler(this.data);
    }

    public PrimitiveLongResourceIterator query(IndexQuery ... predicates) {
        if (predicates.length > 1) {
            Value[] values = new Value[predicates.length];
            for (int i = 0; i < predicates.length; ++i) {
                assert (predicates[i].type() == IndexQuery.IndexQueryType.exact) : "composite indexes only supported for seek";
                values[i] = ((IndexQuery.ExactPredicate)predicates[i]).value();
            }
            return this.seek(values);
        }
        assert (predicates.length == 1) : "composite indexes not yet supported, except for seek on all properties";
        IndexQuery predicate = predicates[0];
        switch (predicate.type()) {
            case exists: {
                return this.scan();
            }
            case exact: {
                return this.seek(((IndexQuery.ExactPredicate)predicate).value());
            }
            case range: {
                switch (predicate.valueGroup().category()) {
                    case NUMBER: {
                        IndexQuery.NumberRangePredicate np = (IndexQuery.NumberRangePredicate)predicate;
                        return this.rangeSeek(np.fromValue(), np.fromInclusive(), np.toValue(), np.toInclusive(), ValueGroup.NUMBER, (IndexQuery)np);
                    }
                    case TEXT: {
                        IndexQuery.TextRangePredicate srp = (IndexQuery.TextRangePredicate)predicate;
                        return this.rangeSeek(srp.fromValue(), srp.fromInclusive(), srp.toValue(), srp.toInclusive(), ValueGroup.TEXT, (IndexQuery)srp);
                    }
                    case TEMPORAL: {
                        IndexQuery.RangePredicate trp = (IndexQuery.RangePredicate)predicate;
                        Value lower = trp.fromValue();
                        Value upper = trp.toValue();
                        return this.rangeSeek(lower, trp.fromInclusive(), upper, trp.toInclusive(), this.extractValueGroup(lower, upper), (IndexQuery)trp);
                    }
                }
                throw new UnsupportedOperationException(String.format("Range scan of valueCategory %s is not supported", predicate.valueGroup().category()));
            }
            case stringPrefix: {
                IndexQuery.StringPrefixPredicate spp = (IndexQuery.StringPrefixPredicate)predicate;
                return this.rangeSeekByPrefix(spp.prefix());
            }
            case stringContains: {
                IndexQuery.StringContainsPredicate scp = (IndexQuery.StringContainsPredicate)predicate;
                return this.containsString(scp.contains());
            }
            case stringSuffix: {
                IndexQuery.StringSuffixPredicate ssp = (IndexQuery.StringSuffixPredicate)predicate;
                return this.endsWith(ssp.suffix());
            }
        }
        throw new RuntimeException("Unsupported query: " + Arrays.toString(predicates));
    }

    public boolean hasFullValuePrecision(IndexQuery ... predicates) {
        return false;
    }

    public void distinctValues(IndexProgressor.NodeValueClient client, PropertyAccessor propertyAccessor) {
        throw new UnsupportedOperationException();
    }

    private PrimitiveLongResourceIterator stringSearch(StringFilter filter) {
        HashSet nodeIds = new HashSet();
        for (Map.Entry<List<Object>, Set<Long>> entry : this.data.entrySet()) {
            Object key = entry.getKey().get(0);
            if (!(key instanceof String) || !filter.test((String)key)) continue;
            nodeIds.addAll(entry.getValue());
        }
        return this.asResource(PrimitiveLongCollections.toPrimitiveIterator(nodeIds.iterator()));
    }

    private PrimitiveLongResourceIterator asResource(PrimitiveLongIterator iterator) {
        return PrimitiveLongCollections.resourceIterator((PrimitiveLongIterator)iterator, null);
    }

    @Override
    boolean hasSameContentsAs(InMemoryIndexImplementation other) {
        return this.data.equals(((HashBasedIndex)other).data);
    }

    private ValueGroup extractValueGroup(Value o1, Value o2) {
        if (o1.valueGroup() != ValueGroup.NO_VALUE && o2.valueGroup() != ValueGroup.NO_VALUE) {
            assert (o1.valueGroup() == o2.valueGroup()) : "o1.valueGroup=" + o1.valueGroup() + ", o2.valueGroup=" + o2.valueGroup();
            return o1.valueGroup();
        }
        if (o1.valueGroup() != ValueGroup.NO_VALUE) {
            return o1.valueGroup();
        }
        if (o2.valueGroup() != ValueGroup.NO_VALUE) {
            return o2.valueGroup();
        }
        throw new IllegalArgumentException("Can't decide ValueGroup from null values");
    }

    private static interface StringFilter {
        public boolean test(String var1);
    }
}

