/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.schema.SchemaTestUtil;
import org.neo4j.kernel.impl.api.store.DefaultCapableIndexReference;
import org.neo4j.kernel.impl.api.store.DefaultIndexReference;

@RunWith(value=Parameterized.class)
public class IndexReferenceTest {
    private final String expectedUserDescription;
    private final IndexReference indexReference;

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList({"Index( GENERAL, :Label1(property2) )", DefaultIndexReference.general((int)1, (int[])new int[]{2})}, {"Index( UNIQUE, :Label10(property200) )", DefaultIndexReference.unique((int)10, (int[])new int[]{200})}, {"Index( GENERAL, :Label42(property3) )", IndexReferenceTest.defaultCapableIndexReference(false, 42, 3)}, {"Index( UNIQUE, :Label42(property3) )", IndexReferenceTest.defaultCapableIndexReference(true, 42, 3)}, {"Index( GENERAL, :Label1(property2, property20) )", DefaultIndexReference.general((int)1, (int[])new int[]{2, 20})}, {"Index( UNIQUE, :Label10(property200, property2000) )", DefaultIndexReference.unique((int)10, (int[])new int[]{200, 2000})}, {"Index( GENERAL, :Label42(property3, property30) )", IndexReferenceTest.defaultCapableIndexReference(false, 42, 3, 30)}, {"Index( UNIQUE, :Label42(property3, property30) )", IndexReferenceTest.defaultCapableIndexReference(true, 42, 3, 30)});
    }

    public IndexReferenceTest(String expectedUserDescription, IndexReference indexReference) {
        this.expectedUserDescription = expectedUserDescription;
        this.indexReference = indexReference;
    }

    @Test
    public void shouldGiveNiceUserDescriptions() {
        MatcherAssert.assertThat((Object)this.indexReference.userDescription(SchemaTestUtil.simpleNameLookup), (Matcher)Matchers.equalTo((Object)this.expectedUserDescription));
    }

    private static DefaultCapableIndexReference defaultCapableIndexReference(boolean unique, int labelId, int ... propertyIds) {
        return new DefaultCapableIndexReference(unique, IndexCapability.NO_CAPABILITY, new IndexProvider.Descriptor("no-desc", "1.0"), labelId, propertyIds);
    }
}

