/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.mutable.MutableInt;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.cursor.RawCursor;
import org.neo4j.index.internal.gbptree.Hit;
import org.neo4j.kernel.impl.index.schema.GatheringNodeValueClient;
import org.neo4j.kernel.impl.index.schema.NativeDistinctValuesProgressor;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.kernel.impl.index.schema.SchemaLayout;
import org.neo4j.kernel.impl.index.schema.SimpleHit;
import org.neo4j.kernel.impl.index.schema.StringLayout;
import org.neo4j.kernel.impl.index.schema.StringSchemaKey;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class NativeDistinctValuesProgressorTest {
    private final StringLayout layout = new StringLayout();
    @Rule
    public final RandomRule random = new RandomRule();

    @Test
    public void shouldCountDistinctValues() {
        Value[] strings = this.generateRandomStrings();
        DataCursor source = new DataCursor(this.asHitData(strings));
        GatheringNodeValueClient client = new GatheringNodeValueClient();
        NativeDistinctValuesProgressor progressor = new NativeDistinctValuesProgressor((RawCursor)source, (IndexProgressor.NodeValueClient)client, new ArrayList(), (SchemaLayout)this.layout, (arg_0, arg_1) -> ((StringLayout)this.layout).compareValue(arg_0, arg_1));
        Map<Value, MutableInt> expectedCounts = this.asDistinctCounts(strings);
        int uniqueValues = 0;
        int nonUniqueValues = 0;
        while (progressor.next()) {
            Value string = client.values[0];
            MutableInt expectedCount = expectedCounts.remove(string);
            Assert.assertNotNull((Object)expectedCount);
            Assert.assertEquals((long)expectedCount.intValue(), (long)client.reference);
            if (expectedCount.intValue() > 1) {
                ++nonUniqueValues;
                continue;
            }
            ++uniqueValues;
        }
        Assert.assertTrue((boolean)expectedCounts.isEmpty());
        Assert.assertTrue((uniqueValues > 0 ? 1 : 0) != 0);
        Assert.assertTrue((nonUniqueValues > 0 ? 1 : 0) != 0);
    }

    private Map<Value, MutableInt> asDistinctCounts(Value[] strings) {
        HashMap<Value, MutableInt> map = new HashMap<Value, MutableInt>();
        for (Value string : strings) {
            map.computeIfAbsent(string, s -> new MutableInt(0)).increment();
        }
        return map;
    }

    private Value[] generateRandomStrings() {
        Value[] strings = new Value[1000];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = Values.stringValue((String)this.random.randoms().string(1, 3, 3));
        }
        Arrays.sort(strings, Values.COMPARATOR);
        return strings;
    }

    private Collection<Hit<StringSchemaKey, NativeSchemaValue>> asHitData(Value[] strings) {
        ArrayList<Hit<StringSchemaKey, NativeSchemaValue>> data = new ArrayList<Hit<StringSchemaKey, NativeSchemaValue>>(strings.length);
        for (int i = 0; i < strings.length; ++i) {
            StringSchemaKey key = this.layout.newKey();
            key.from((long)i, new Value[]{strings[i]});
            data.add(new SimpleHit<StringSchemaKey, NativeSchemaValue>(key, NativeSchemaValue.INSTANCE));
        }
        return data;
    }

    private static class DataCursor
    implements RawCursor<Hit<StringSchemaKey, NativeSchemaValue>, IOException> {
        private final Iterator<Hit<StringSchemaKey, NativeSchemaValue>> iterator;
        private Hit<StringSchemaKey, NativeSchemaValue> current;

        DataCursor(Collection<Hit<StringSchemaKey, NativeSchemaValue>> data) {
            this.iterator = data.iterator();
        }

        public boolean next() throws RuntimeException {
            if (!this.iterator.hasNext()) {
                return false;
            }
            this.current = this.iterator.next();
            return true;
        }

        public void close() throws RuntimeException {
        }

        public Hit<StringSchemaKey, NativeSchemaValue> get() {
            return this.current;
        }
    }
}

