/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.gis.spatial.index.curves.StandardConfiguration;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.LayoutTestUtil;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndexHeaderReader;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.kernel.impl.index.schema.SpatialIndexFiles;
import org.neo4j.kernel.impl.index.schema.SpatialIndexPopulator;
import org.neo4j.kernel.impl.index.schema.SpatialIndexProvider;
import org.neo4j.kernel.impl.index.schema.SpatialLayoutTestUtil;
import org.neo4j.kernel.impl.index.schema.SpatialSchemaKey;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettings;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettingsFactory;
import org.neo4j.kernel.impl.index.schema.config.SpatialIndexSettings;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.values.storable.CoordinateReferenceSystem;

public class SpatialIndexSettingsTest {
    private static final CoordinateReferenceSystem crs = CoordinateReferenceSystem.WGS84;
    private static final Config config1 = Config.defaults();
    private static final Config config2 = SpatialIndexSettingsTest.configWithRange(0.0, -90.0, 180.0, 90.0);
    private static final SpaceFillingCurveSettingsFactory settings1 = new SpaceFillingCurveSettingsFactory(config1);
    private static final SpaceFillingCurveSettingsFactory settings2 = new SpaceFillingCurveSettingsFactory(config2);
    private SchemaIndexDescriptor schemaIndexDescriptor1;
    private SchemaIndexDescriptor schemaIndexDescriptor2;
    private LayoutTestUtil<SpatialSchemaKey, NativeSchemaValue> layoutUtil1;
    private LayoutTestUtil<SpatialSchemaKey, NativeSchemaValue> layoutUtil2;
    private long indexId1 = 1L;
    private long indexId2 = 2L;
    final DefaultFileSystemRule fs = new DefaultFileSystemRule();
    private final TestDirectory directory = TestDirectory.testDirectory(this.getClass(), (FileSystemAbstraction)this.fs.get());
    private final PageCacheRule pageCacheRule = new PageCacheRule(PageCacheRule.config().withAccessChecks(true));
    @Rule
    public final RuleChain rules = RuleChain.outerRule((TestRule)this.fs).around((TestRule)this.directory).around((TestRule)this.pageCacheRule);
    private PageCache pageCache;
    private IndexProvider.Monitor monitor = IndexProvider.Monitor.EMPTY;

    @Before
    public void setupTwoIndexes() throws IOException {
        this.pageCache = this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fs);
        this.layoutUtil1 = this.createLayoutTestUtil(42, settings1);
        this.layoutUtil2 = this.createLayoutTestUtil(43, settings2);
        this.schemaIndexDescriptor1 = this.layoutUtil1.indexDescriptor();
        this.schemaIndexDescriptor2 = this.layoutUtil2.indexDescriptor();
        this.createEmptyIndex(this.indexId1, this.schemaIndexDescriptor1, settings1);
        this.createEmptyIndex(this.indexId2, this.schemaIndexDescriptor2, settings2);
    }

    @Test
    public void shouldAddToSpatialIndexWithDefaults() throws Exception {
        SpatialIndexProvider provider = this.newSpatialIndexProvider(config1);
        this.addUpdates(provider, this.indexId1, this.schemaIndexDescriptor1, this.layoutUtil1);
        this.verifySpatialSettings(this.indexFile(this.indexId1), settings1.settingsFor(crs));
    }

    @Test
    public void shouldAddToSpatialIndexWithModifiedSettings() throws Exception {
        SpatialIndexProvider provider = this.newSpatialIndexProvider(config2);
        this.addUpdates(provider, this.indexId2, this.schemaIndexDescriptor2, this.layoutUtil2);
        this.verifySpatialSettings(this.indexFile(this.indexId2), settings2.settingsFor(crs));
    }

    @Test
    public void shouldAddToTwoDifferentIndexesOneDefaultAndOneModified() throws Exception {
        SpatialIndexProvider provider = this.newSpatialIndexProvider(config2);
        this.addUpdates(provider, this.indexId1, this.schemaIndexDescriptor1, this.layoutUtil1);
        this.addUpdates(provider, this.indexId2, this.schemaIndexDescriptor2, this.layoutUtil2);
        this.verifySpatialSettings(this.indexFile(this.indexId1), settings1.settingsFor(crs));
        this.verifySpatialSettings(this.indexFile(this.indexId2), settings2.settingsFor(crs));
    }

    @Test
    public void shouldNotLeakSpaceFillingCurveSettingsBetweenExistingAndNewIndexes() throws Exception {
        Config config = SpatialIndexSettingsTest.configWithRange(-10.0, -10.0, 10.0, 10.0);
        SpatialIndexProvider provider = this.newSpatialIndexProvider(config);
        this.addUpdates(provider, this.indexId1, this.schemaIndexDescriptor1, this.layoutUtil1);
        this.addUpdates(provider, this.indexId2, this.schemaIndexDescriptor2, this.layoutUtil2);
        long indexId3 = 3L;
        SpaceFillingCurveSettingsFactory settings3 = new SpaceFillingCurveSettingsFactory(config);
        SpatialLayoutTestUtil layoutUtil3 = this.createLayoutTestUtil(44, settings3);
        SchemaIndexDescriptor schemaIndexDescriptor3 = layoutUtil3.indexDescriptor();
        this.createEmptyIndex(indexId3, schemaIndexDescriptor3, provider);
        this.addUpdates(provider, indexId3, schemaIndexDescriptor3, layoutUtil3);
        this.verifySpatialSettings(this.indexFile(this.indexId1), settings1.settingsFor(crs));
        this.verifySpatialSettings(this.indexFile(this.indexId2), settings2.settingsFor(crs));
        this.verifySpatialSettings(this.indexFile(indexId3), settings3.settingsFor(crs));
    }

    private IndexSamplingConfig samplingConfig() {
        return new IndexSamplingConfig(Config.defaults());
    }

    private SpatialLayoutTestUtil createLayoutTestUtil(int labelId, SpaceFillingCurveSettingsFactory settings) {
        return new SpatialLayoutTestUtil(SchemaIndexDescriptorFactory.forLabel((int)labelId, (int[])new int[]{666}), settings.settingsFor(crs), crs);
    }

    private SpatialIndexProvider newSpatialIndexProvider(Config config) {
        return new SpatialIndexProvider(this.pageCache, (FileSystemAbstraction)this.fs, IndexDirectoryStructure.directoriesByProvider((File)this.directory.graphDbDir()), this.monitor, RecoveryCleanupWorkCollector.immediate(), false, config);
    }

    private void addUpdates(SpatialIndexProvider provider, long indexId, SchemaIndexDescriptor schemaIndexDescriptor, LayoutTestUtil<SpatialSchemaKey, NativeSchemaValue> layoutUtil) throws IOException, IndexEntryConflictException {
        IndexAccessor accessor = provider.getOnlineAccessor(indexId, schemaIndexDescriptor, this.samplingConfig());
        try (IndexUpdater updater = accessor.newUpdater(IndexUpdateMode.ONLINE);){
            for (IndexEntryUpdate<SchemaIndexDescriptor> update : layoutUtil.someUpdates()) {
                updater.process(update);
            }
        }
        accessor.force(IOLimiter.unlimited());
        accessor.close();
    }

    private SpatialIndexFiles.SpatialFile makeIndexFile(long indexId, SpaceFillingCurveSettingsFactory settings) {
        return new SpatialIndexFiles.SpatialFile(CoordinateReferenceSystem.WGS84, settings, this.indexDir(indexId));
    }

    private File indexDir(long indexId) {
        return new File(this.indexRoot(), Long.toString(indexId));
    }

    private File indexFile(long indexId) {
        return this.makeIndexFile((long)indexId, (SpaceFillingCurveSettingsFactory)new SpaceFillingCurveSettingsFactory((Config)Config.defaults())).indexFile;
    }

    private File indexRoot() {
        return new File(new File(new File(this.directory.graphDbDir(), "schema"), "index"), "spatial-1.0");
    }

    private void createEmptyIndex(long indexId, SchemaIndexDescriptor schemaIndexDescriptor, SpaceFillingCurveSettingsFactory settings) throws IOException {
        SpatialIndexFiles.SpatialFileLayout fileLayout = this.makeIndexFile(indexId, settings).getLayoutForNewIndex();
        SpatialIndexPopulator.PartPopulator populator = new SpatialIndexPopulator.PartPopulator(this.pageCache, (FileSystemAbstraction)this.fs, fileLayout, this.monitor, schemaIndexDescriptor, indexId, this.samplingConfig(), (SpaceFillingCurveConfiguration)new StandardConfiguration());
        populator.create();
        populator.close(true);
    }

    private void createEmptyIndex(long indexId, SchemaIndexDescriptor schemaIndexDescriptor, SpatialIndexProvider provider) throws IOException {
        IndexPopulator populator = provider.getPopulator(indexId, schemaIndexDescriptor, this.samplingConfig());
        populator.create();
        populator.close(true);
    }

    private void verifySpatialSettings(File indexFile, SpaceFillingCurveSettings expectedSettings) {
        try {
            SpaceFillingCurveSettings settings = SpaceFillingCurveSettings.fromGBPTree((File)indexFile, (PageCache)this.pageCache, NativeSchemaIndexHeaderReader::readFailureMessage);
            Assert.assertThat((String)"Should get correct results from header", (Object)settings, (Matcher)Matchers.equalTo((Object)expectedSettings));
        }
        catch (IOException e) {
            Assert.fail((String)("Failed to read GBPTree header: " + e.getMessage()));
        }
    }

    private static Config configWithRange(double minX, double minY, double maxX, double maxY) {
        Setting wgs84MinX = SpatialIndexSettings.makeCRSRangeSetting((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (int)0, (String)"min");
        Setting wgs84MinY = SpatialIndexSettings.makeCRSRangeSetting((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (int)1, (String)"min");
        Setting wgs84MaxX = SpatialIndexSettings.makeCRSRangeSetting((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (int)0, (String)"max");
        Setting wgs84MaxY = SpatialIndexSettings.makeCRSRangeSetting((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (int)1, (String)"max");
        Config config = Config.defaults();
        config.augment(wgs84MinX, Double.toString(minX));
        config.augment(wgs84MinY, Double.toString(minY));
        config.augment(wgs84MaxX, Double.toString(maxX));
        config.augment(wgs84MaxY, Double.toString(maxY));
        return config;
    }
}

