/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import org.apache.commons.lang3.mutable.MutableInt;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.index.schema.fusion.InstanceSelector;

public class InstanceSelectorTest {
    @Test
    public void shouldSelect() {
        InstanceSelector<String> selector = this.selector("0", "1");
        String select0 = (String)selector.select(0);
        Assert.assertEquals((Object)"0", (Object)select0);
        String select1 = (String)selector.select(1);
        Assert.assertEquals((Object)"1", (Object)select1);
    }

    @Test
    public void shouldThrowOnNonInstantiatedSelect() {
        InstanceSelector<String> selector = this.selector("0", null);
        try {
            selector.select(1);
            Assert.fail((String)"Should have failed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowOnNonInstantiatedInstancesAs() {
        InstanceSelector<String> selector = this.selector("0", null);
        try {
            selector.instancesAs((Object[])new Number[2], Integer::parseInt);
            Assert.fail((String)"Should have failed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldInstancesAs() {
        InstanceSelector<String> selector = this.selector("0", "1");
        Number[] numbers = (Number[])selector.instancesAs((Object[])new Number[2], Integer::parseInt);
        Assert.assertEquals((Object)0, (Object)numbers[0]);
        Assert.assertEquals((Object)1, (Object)numbers[1]);
    }

    @Test
    public void shouldThrowOnNonInstantiatedForAll() {
        InstanceSelector<String> selector = this.selector("0", null);
        try {
            selector.forAll(Integer::parseInt);
            Assert.fail((String)"Should have failed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldForAll() {
        InstanceSelector<String> selector = this.selector("0", "1");
        MutableInt count = new MutableInt();
        selector.forAll(s -> count.increment());
        Assert.assertEquals((long)2L, (long)count.intValue());
    }

    @Test
    public void shouldNotThrowOnNonInstantiatedForAll() {
        InstanceSelector<String> selector = this.selector(new String[]{null});
        selector.close(Integer::parseInt);
    }

    @Test
    public void shouldCloseAll() {
        InstanceSelector<String> selector = this.selector("0", "1");
        MutableInt count = new MutableInt();
        selector.close(s -> count.increment());
        Assert.assertEquals((long)2L, (long)count.intValue());
    }

    private InstanceSelector<String> selector(String ... strings) {
        return new InstanceSelector((Object[])strings);
    }
}

