/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReaderLogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderWriter;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.test.rule.TestDirectory;

public class ReaderLogVersionBridgeTest {
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();
    private final FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
    private final LogVersionedStoreChannel channel = (LogVersionedStoreChannel)Mockito.mock(LogVersionedStoreChannel.class);
    private final long version = 10L;
    private LogFiles logFiles;

    @Before
    public void setUp() throws Exception {
        this.logFiles = this.prepareLogFiles();
    }

    @Test
    public void shouldOpenTheNextChannelWhenItExists() throws IOException {
        StoreChannel newStoreChannel = (StoreChannel)Mockito.mock(StoreChannel.class);
        ReaderLogVersionBridge bridge = new ReaderLogVersionBridge(this.logFiles);
        Mockito.when((Object)this.channel.getVersion()).thenReturn((Object)10L);
        Mockito.when((Object)this.channel.getLogFormatVersion()).thenReturn((Object)6);
        Mockito.when((Object)this.fs.fileExists((File)ArgumentMatchers.any(File.class))).thenReturn((Object)true);
        Mockito.when((Object)this.fs.open((File)ArgumentMatchers.any(File.class), (OpenMode)ArgumentMatchers.eq((Object)OpenMode.READ))).thenReturn((Object)newStoreChannel);
        Mockito.when((Object)newStoreChannel.read((ByteBuffer)ArgumentMatchers.any())).then(invocationOnMock -> {
            ByteBuffer buffer = (ByteBuffer)invocationOnMock.getArgument(0);
            buffer.putLong(LogHeaderWriter.encodeLogVersion((long)11L));
            buffer.putLong(42L);
            return 16;
        });
        LogVersionedStoreChannel result = bridge.next(this.channel);
        PhysicalLogVersionedStoreChannel expected = new PhysicalLogVersionedStoreChannel(newStoreChannel, 11L, 6);
        Assert.assertEquals((Object)expected, (Object)result);
        ((LogVersionedStoreChannel)Mockito.verify((Object)this.channel, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void shouldReturnOldChannelWhenThereIsNoNextChannel() throws IOException {
        ReaderLogVersionBridge bridge = new ReaderLogVersionBridge(this.logFiles);
        Mockito.when((Object)this.channel.getVersion()).thenReturn((Object)10L);
        Mockito.when((Object)this.fs.open((File)ArgumentMatchers.any(File.class), (OpenMode)ArgumentMatchers.eq((Object)OpenMode.READ))).thenThrow(new Throwable[]{new FileNotFoundException()});
        LogVersionedStoreChannel result = bridge.next(this.channel);
        Assert.assertEquals((Object)this.channel, (Object)result);
        ((LogVersionedStoreChannel)Mockito.verify((Object)this.channel, (VerificationMode)Mockito.never())).close();
    }

    @Test
    public void shouldReturnOldChannelWhenNextChannelHasntGottenCompleteHeaderYet() throws Exception {
        ReaderLogVersionBridge bridge = new ReaderLogVersionBridge(this.logFiles);
        StoreChannel nextVersionWithIncompleteHeader = (StoreChannel)Mockito.mock(StoreChannel.class);
        Mockito.when((Object)nextVersionWithIncompleteHeader.read((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class))).thenReturn((Object)8);
        Mockito.when((Object)this.channel.getVersion()).thenReturn((Object)10L);
        Mockito.when((Object)this.fs.fileExists((File)ArgumentMatchers.any(File.class))).thenReturn((Object)true);
        Mockito.when((Object)this.fs.open((File)ArgumentMatchers.any(File.class), (OpenMode)ArgumentMatchers.eq((Object)OpenMode.READ))).thenReturn((Object)nextVersionWithIncompleteHeader);
        LogVersionedStoreChannel result = bridge.next(this.channel);
        Assert.assertEquals((Object)this.channel, (Object)result);
        ((LogVersionedStoreChannel)Mockito.verify((Object)this.channel, (VerificationMode)Mockito.never())).close();
    }

    private LogFiles prepareLogFiles() throws IOException {
        return LogFilesBuilder.logFilesBasedOnlyBuilder((File)this.testDirectory.directory(), (FileSystemAbstraction)this.fs).build();
    }
}

